/*
 * Decompiled with CFR 0.152.
 */
package pymo.descriptors;

import java.io.IOException;
import pymo.components.MOComponent;
import pymo.components.MOTextBox;
import pymo.descriptors.AbstractFieldDescriptor;
import pymo.fields.Field;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;
import pymo.security.Constants;

public class TextDescriptor
extends AbstractFieldDescriptor {
    public static String TEXT_DESCRIPTOR_SIGNATURE = "dTXT";
    private static int _$14118 = 1;
    private String _$10383 = null;

    public TextDescriptor() {
    }

    public TextDescriptor(MOFileReader reader) throws IOException {
        this.read(reader);
    }

    public TextDescriptor(MOFileReader reader, long dID) throws IOException {
        this.setID(dID);
        this.read(reader);
    }

    public void readUniqueData(MOFileReader reader) throws IOException {
        super.readUniqueData(reader);
        this._$10383 = reader.readFixedString(64);
    }

    public void writeUniqueData(MOFileWriter writer) throws IOException {
        super.writeUniqueData(writer);
        writer.writeFixedString(this._$10383, 64);
    }

    public int getVersion() {
        return _$14118;
    }

    public String getSignature() {
        return TEXT_DESCRIPTOR_SIGNATURE;
    }

    public int getSize() {
        return 64 + super.getSize();
    }

    public String toString(Field field) {
        return (String)this.toWrapper(field);
    }

    public Object toWrapper(Field field) {
        int len = field.getDataLength();
        if (len == 0) {
            return new String();
        }
        byte[] data = field.getData();
        StringBuffer buffer = new StringBuffer(len);
        for (int i2 = 0; i2 < len; ++i2) {
            buffer.append((char)data[i2]);
        }
        return buffer.toString();
    }

    public Field toField(Object object) {
        if (!String.class.isInstance(object)) {
            return null;
        }
        String str = new String((String)object);
        int len = str.length();
        byte[] fieldData = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            fieldData[i2] = (byte)str.charAt(i2);
        }
        return new Field(fieldData);
    }

    public MOComponent makePanelComponent() {
        MOTextBox component = new MOTextBox(this);
        component.setBounds(this.getBounds());
        return component;
    }

    public int getSearchType() {
        return Constants.TEXT_SEARCH;
    }

    public int compare(Field field1, Field field2) {
        String s1 = (String)this.toWrapper(field1);
        String s2 = (String)this.toWrapper(field2);
        return s1.compareToIgnoreCase(s2);
    }

    public boolean startsWith(Field field, Field value) {
        String fieldStr = (String)this.toWrapper(field);
        String valueStr = (String)this.toWrapper(value);
        return fieldStr.toUpperCase().startsWith(valueStr.toUpperCase());
    }

    public boolean endsWith(Field field, Field value) {
        String fieldStr = (String)this.toWrapper(field);
        String valueStr = (String)this.toWrapper(value);
        return fieldStr.toUpperCase().endsWith(valueStr.toUpperCase());
    }

    public boolean contains(Field field, Field value) {
        String fieldStr = (String)this.toWrapper(field);
        String valueStr = (String)this.toWrapper(value);
        return fieldStr.toUpperCase().indexOf(valueStr.toUpperCase()) > -1;
    }

    public void setInitialValue(Object string) {
        this._$10383 = (String)string;
        this.setChanged();
    }

    public Object getInitialValue() {
        if (this._$10383 == null) {
            return null;
        }
        return new String(this._$10383);
    }
}

