/*
 * Decompiled with CFR 0.152.
 */
package pymo.descriptors;

import java.io.IOException;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jbc.grid.JbcCellRendererDecimalFormat;
import pymo.components.MOComponent;
import pymo.components.MOWholeNumberBox;
import pymo.descriptors.AbstractFieldDescriptor;
import pymo.fields.Field;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;
import pymo.security.Constants;
import pymo.tableCellEditors.WholeNumberCellEditor;
import pymo.tableCellEditors.WholeNumberField;
import pyware.toolkit.Utils;

public class WholeNumberDescriptor
extends AbstractFieldDescriptor {
    public static String WHOLE_NUMBER_DESCRIPTOR_SIGNATURE = "dNUM";
    private static int _$20283 = 1;
    private long _$10383 = 0L;

    public WholeNumberDescriptor() {
    }

    public WholeNumberDescriptor(MOFileReader reader) throws IOException {
        this.read(reader);
    }

    public WholeNumberDescriptor(MOFileReader reader, long dID) throws IOException {
        this.setID(dID);
        this.read(reader);
    }

    public void readUniqueData(MOFileReader reader) throws IOException {
        super.readUniqueData(reader);
        this._$10383 = reader.readLong();
    }

    public void writeUniqueData(MOFileWriter writer) throws IOException {
        super.writeUniqueData(writer);
        writer.writeLong(this._$10383);
    }

    public int getVersion() {
        return _$20283;
    }

    public String getSignature() {
        return WHOLE_NUMBER_DESCRIPTOR_SIGNATURE;
    }

    public int getSize() {
        return 8 + super.getSize();
    }

    public String toString(Field field) {
        return this.toWrapper(field).toString();
    }

    private long _$20186(Field field) {
        return Utils.byteArrayToLongValue(field.getData());
    }

    public Object toWrapper(Field field) {
        return new Long(this._$20186(field));
    }

    public Field toField(Object object) {
        long longValue = (Long)object;
        return new Field(Utils.longValueToByteArray(longValue));
    }

    public MOComponent makePanelComponent() {
        MOWholeNumberBox component = new MOWholeNumberBox(this);
        component.setBounds(this.getBounds());
        return component;
    }

    public TableCellRenderer makeCellRenderer() {
        return new JbcCellRendererDecimalFormat("###,###,##0");
    }

    public TableCellEditor makeCellEditor() {
        return new WholeNumberCellEditor(new WholeNumberField(0L, this.getLimit()));
    }

    public int getSearchType() {
        return Constants.NUMERIC_SEARCH;
    }

    public int compare(Field field1, Field field2) {
        long val2;
        long val1 = this._$20186(field1);
        if (val1 == (val2 = this._$20186(field2))) {
            return 0;
        }
        if (val1 < val2) {
            return -1;
        }
        return 1;
    }

    public void setInitialValue(Object longWrapper) {
        this._$10383 = (Long)longWrapper;
        this.setChanged();
    }

    public Object getInitialValue() {
        return new Long(this._$10383);
    }
}

