/*
 * Decompiled with CFR 0.152.
 */
package pymo.iPasDBTools;

import java.awt.Frame;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pymo.descriptors.IPasDescriptor;
import pymo.iPasDBTools.IPasMOAssignmentItem;
import pymo.iPasDBTools.SchedulerDateCellRenderer;
import pymo.iPasDBTools.SchedulerTableModelRow;
import pymo.tableCellEditors.DateCellEditor2;
import pyware.iPasToolkit.interactive.AssignmentItem;
import pyware.iPasToolkit.interactive.LessonList;
import pyware.toolkit.Utils;

public class SchedulerTableModel
extends AbstractTableModel {
    public static int SERIES_COLUMN = 0;
    public static int LESSON_COLUMN = 1;
    public static int ASSIGN_COLUMN = 2;
    public static int ASSIGN_DATE_COLUMN = 3;
    public static int DUE_DATE_COLUMN = 4;
    public static int REDOABLE_COLUMN = 5;
    public static int RECORD_COLUMN = 6;
    public static int GRAPH_COLUMN = 7;
    private Vector _$16967 = new Vector();
    private boolean _$6003 = false;
    private Frame _$483;
    private boolean _$16968 = false;
    private boolean[] _$16969;

    public SchedulerTableModel(Frame frame, JTable table, IPasDescriptor descriptor) {
        int i2;
        this._$483 = frame;
        LessonList lessonList = descriptor.getIPasFileLibrarian().getLessonList();
        int len = lessonList.size();
        for (i2 = 0; i2 < len; ++i2) {
            this._$12847(new SchedulerTableModelRow(lessonList.itemAt(i2)));
        }
        table.setModel(this);
        for (i2 = 0; i2 < this.getColumnCount(); ++i2) {
            TableColumn tableColumn = table.getColumnModel().getColumn(i2);
            tableColumn.setPreferredWidth(this.getColumnWidth(i2));
            if (i2 == DUE_DATE_COLUMN) {
                tableColumn.setCellEditor(new DateCellEditor2());
                tableColumn.setCellRenderer(new SchedulerDateCellRenderer());
            }
            if (i2 != ASSIGN_DATE_COLUMN) continue;
            tableColumn.setCellEditor(new DateCellEditor2());
            tableColumn.setCellRenderer(new SchedulerDateCellRenderer());
        }
        this._$16971(descriptor);
    }

    private void _$16971(IPasDescriptor descriptor) {
        int len = descriptor.getItemCount();
        this._$16969 = new boolean[this.getRowCount()];
        for (int i2 = 0; i2 < len; ++i2) {
            AssignmentItem item = descriptor.descriptorItemAt(i2);
            int index = this._$16972(item.lessonID);
            if (index == -1) continue;
            this._$16969[index] = true;
            SchedulerTableModelRow row = this.rowAt(index);
            row.assigned = true;
            row.dueDate = item.dueDate;
            row.assignDate = item.assignDate;
            row.record = item.record;
            row.graph = item.graph;
            row.redoable = item.redoable;
        }
    }

    private void _$16974(int rowIndex) {
        SchedulerTableModelRow row = this.rowAt(rowIndex);
        if (row.assignDate == 0L) {
            row.assignDate = Utils.truncateDate(System.currentTimeMillis());
            row.assigned = true;
            this.fireTableCellUpdated(rowIndex, ASSIGN_COLUMN);
        }
        if (row.dueDate < row.assignDate) {
            row.dueDate = row.assignDate;
            this.fireTableCellUpdated(rowIndex, DUE_DATE_COLUMN);
        }
    }

    private boolean _$16975(String asnName) {
        int rslt = JOptionPane.showConfirmDialog(this._$483, "You are removing an assignment from the existing class schedule.\nIf any students have turned in results for this assignment, the results\nwill be deleted from their student record.\n\nAssignment:  " + asnName + "\n" + "Okay to remove this assignment from the class schedule?", "iPAS Librarian Notice", 0, 3);
        return rslt == 0;
    }

    private void _$12847(SchedulerTableModelRow row) {
        this._$16967.addElement(row);
    }

    private int _$16972(long lessonID) {
        for (int i2 = 0; i2 < this._$16967.size(); ++i2) {
            SchedulerTableModelRow row = this.rowAt(i2);
            if (row.id != lessonID) continue;
            return i2;
        }
        return -1;
    }

    public SchedulerTableModelRow rowAt(int index) {
        return (SchedulerTableModelRow)this._$16967.elementAt(index);
    }

    public int getColumnCount() {
        return 8;
    }

    public int getRowCount() {
        return this._$16967.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        SchedulerTableModelRow row = this.rowAt(rowIndex);
        if (columnIndex == ASSIGN_COLUMN) {
            this.fireTableCellUpdated(rowIndex, DUE_DATE_COLUMN);
            this.fireTableCellUpdated(rowIndex, ASSIGN_DATE_COLUMN);
            return new Boolean(row.assigned);
        }
        if (columnIndex == GRAPH_COLUMN) {
            return new Boolean(row.graph);
        }
        if (columnIndex == REDOABLE_COLUMN) {
            return new Boolean(row.redoable);
        }
        if (columnIndex == RECORD_COLUMN) {
            return new Boolean(row.record);
        }
        if (columnIndex == SERIES_COLUMN) {
            return row.series;
        }
        if (columnIndex == LESSON_COLUMN) {
            return row.lessonDesc;
        }
        if (columnIndex == DUE_DATE_COLUMN) {
            return new Timestamp(row.dueDate);
        }
        if (columnIndex == ASSIGN_DATE_COLUMN) {
            return new Timestamp(row.assignDate);
        }
        return null;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        long date;
        this._$6003 = true;
        SchedulerTableModelRow row = this.rowAt(rowIndex);
        if (columnIndex == ASSIGN_COLUMN) {
            if (row.assigned && this._$16969[rowIndex] && !this._$16975(row.lessonDesc)) {
                return;
            }
            boolean bl2 = row.assigned = !row.assigned;
            if (row.assigned) {
                long today = Utils.truncateDate(System.currentTimeMillis());
                if (row.assignDate < today) {
                    row.assignDate = today;
                }
                if (row.dueDate < row.assignDate) {
                    row.dueDate = row.assignDate;
                }
            }
        }
        if (columnIndex == REDOABLE_COLUMN) {
            boolean bl3 = row.redoable = !row.redoable;
            if (row.redoable) {
                row.graph = false;
                row.record = false;
                this.fireTableCellUpdated(rowIndex, GRAPH_COLUMN);
                this.fireTableCellUpdated(rowIndex, RECORD_COLUMN);
                this._$16974(rowIndex);
            }
        }
        if (columnIndex == RECORD_COLUMN) {
            boolean bl4 = row.record = !row.record;
            if (row.record) {
                row.redoable = false;
                this.checkRecordOveruse();
            }
            this.fireTableCellUpdated(rowIndex, REDOABLE_COLUMN);
            this._$16974(rowIndex);
        }
        if (columnIndex == GRAPH_COLUMN) {
            boolean bl5 = row.graph = !row.graph;
            if (row.graph) {
                row.redoable = false;
            }
            this.fireTableCellUpdated(rowIndex, REDOABLE_COLUMN);
            this._$16974(rowIndex);
        }
        if (columnIndex == DUE_DATE_COLUMN) {
            date = ((Timestamp)value).getTime();
            row.dueDate = Utils.truncateDate(date);
        }
        if (columnIndex == ASSIGN_DATE_COLUMN) {
            date = ((Timestamp)value).getTime();
            row.assignDate = Utils.truncateDate(date);
            if (row.dueDate < row.assignDate) {
                row.dueDate = row.assignDate;
                this.fireTableCellUpdated(rowIndex, DUE_DATE_COLUMN);
            }
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == ASSIGN_COLUMN) {
            return Boolean.class;
        }
        if (columnIndex == RECORD_COLUMN) {
            return Boolean.class;
        }
        if (columnIndex == GRAPH_COLUMN) {
            return Boolean.class;
        }
        if (columnIndex == REDOABLE_COLUMN) {
            return Boolean.class;
        }
        if (columnIndex == DUE_DATE_COLUMN) {
            return Timestamp.class;
        }
        if (columnIndex == ASSIGN_DATE_COLUMN) {
            return Timestamp.class;
        }
        return String.class;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == ASSIGN_COLUMN) {
            return "Assign";
        }
        if (columnIndex == SERIES_COLUMN) {
            return "Series";
        }
        if (columnIndex == LESSON_COLUMN) {
            return "Lesson";
        }
        if (columnIndex == DUE_DATE_COLUMN) {
            return "Due Date";
        }
        if (columnIndex == ASSIGN_DATE_COLUMN) {
            return "Assign Date";
        }
        if (columnIndex == RECORD_COLUMN) {
            return "Record";
        }
        if (columnIndex == REDOABLE_COLUMN) {
            return "Redo";
        }
        if (columnIndex == GRAPH_COLUMN) {
            return "Graph";
        }
        return "";
    }

    public int getColumnWidth(int columnIndex) {
        if (columnIndex == ASSIGN_COLUMN) {
            return 40;
        }
        if (columnIndex == SERIES_COLUMN) {
            return 200;
        }
        if (columnIndex == LESSON_COLUMN) {
            return 300;
        }
        if (columnIndex == DUE_DATE_COLUMN) {
            return 80;
        }
        if (columnIndex == ASSIGN_DATE_COLUMN) {
            return 80;
        }
        if (columnIndex == RECORD_COLUMN) {
            return 40;
        }
        if (columnIndex == REDOABLE_COLUMN) {
            return 40;
        }
        if (columnIndex == GRAPH_COLUMN) {
            return 40;
        }
        return 0;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == DUE_DATE_COLUMN) {
            return true;
        }
        if (columnIndex == ASSIGN_DATE_COLUMN) {
            return true;
        }
        if (columnIndex == ASSIGN_COLUMN) {
            return true;
        }
        if (columnIndex == RECORD_COLUMN) {
            return true;
        }
        if (columnIndex == REDOABLE_COLUMN) {
            return true;
        }
        return columnIndex == GRAPH_COLUMN;
    }

    public boolean hasChanged() {
        return this._$6003;
    }

    public void checkRecordOveruse() {
        if (this._$16968) {
            return;
        }
        int len = this.getRowCount();
        int count = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            SchedulerTableModelRow row = this.rowAt(i2);
            if (!row.assigned || !row.record) continue;
            ++count;
        }
        if (count > 15) {
            JOptionPane.showMessageDialog(this._$483, "Assignments using the \"Record\" option will take longer for students\nto transmit (upload) their results to the online school account.\n\nTherefore, it is recommended that you do not select the \"Record\" option\nfor more assignments than you will have time to hear.\n\nYou currently have " + count + " assignments using the \"Record\" option.", "iPAS Librarian Notice", 1);
            this._$16968 = true;
        }
    }

    public void resetAllAssignments() {
        for (int i2 = 0; i2 < this._$16967.size(); ++i2) {
            if (!this.rowAt((int)i2).assigned) continue;
            this.rowAt(i2).reset();
            this._$6003 = true;
        }
        this.fireTableDataChanged();
    }

    public void updateDescriptor(IPasDescriptor descriptor) {
        int len = this.getRowCount();
        descriptor.removeItems();
        for (int i2 = 0; i2 < len; ++i2) {
            SchedulerTableModelRow row = this.rowAt(i2);
            if (!row.assigned) continue;
            descriptor.addItem(new IPasMOAssignmentItem(row.id, row.assigned, row.assignDate, row.dueDate, row.record, row.graph, row.redoable));
        }
    }
}

