/*
 * Decompiled with CFR 0.152.
 */
package pymo.io;

import com.borland.jbcl.layout.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import pymo.dataBases.DataBase;
import pymo.dataBases.DataBaseManager;
import pymo.io.AutoOpener;
import pymo.io.FileManagerDialog_btnNew_actionAdapter;
import pymo.io.FileManagerFile;
import pymo.io.FileManager_activeList_listSelectionAdapter;
import pymo.io.FileManager_btnArchive_actionAdapter;
import pymo.io.FileManager_btnDelete_actionAdapter;
import pymo.io.FileManager_btnDone_actionAdapter;
import pymo.io.FileManager_btnGetCopyFrom_actionAdapter;
import pymo.io.FileManager_btnRestore_actionAdapter;
import pymo.io.FileManager_btnSendCopyTo_actionAdapter;
import pymo.io.FileManager_inactiveList_listSelectionAdapter;
import pymo.io.LoadFileDialog;
import pymo.io.NewDataBaseDialog;
import pymo.io.SaveFileDialog;
import pymo.security.Constants;
import pymo.security.FilePath;
import pyware.toolkit.FileUtils;
import pyware.toolkit.Utils;

public class FileManagerDialog
extends JDialog {
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel centerPanel = new JPanel();
    JPanel leftPanel = new JPanel();
    JButton btnArchive = new JButton();
    JButton btnRestore = new JButton();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JButton btnSendCopyTo = new JButton();
    JPanel rightPanel = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList inactiveList = new JList();
    JScrollPane activeScrollPane = new JScrollPane();
    JList activeList = new JList();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jLabel2 = new JLabel();
    BorderLayout borderLayout3 = new BorderLayout();
    JLabel jLabel3 = new JLabel();
    JButton btnDone = new JButton();
    JButton btnGetCopyFrom = new JButton();
    JButton btnDelete = new JButton();
    JPanel jPanel2 = new JPanel();
    VerticalFlowLayout verticalFlowLayout2 = new VerticalFlowLayout();
    JPanel jPanel4 = new JPanel();
    VerticalFlowLayout verticalFlowLayout4 = new VerticalFlowLayout();
    Border border1;
    Border border2;
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    boolean selectionChanging = false;
    Frame frame;
    DataBaseManager dbManager;
    JPanel jPanel1 = new JPanel();
    JButton btnNew = new JButton();

    public FileManagerDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.frame = frame;
        try {
            this._$550();
            this.pack();
            Utils.centerDialog(frame, this);
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public FileManagerDialog() {
        this((Frame)null, "", false);
    }

    public FileManagerDialog(Frame frame, DataBaseManager dbManager) {
        this(frame, "File Manager", true);
        this.dbManager = dbManager;
        this._$15903();
    }

    private void _$550() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 10, 10, 5);
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 0, 10);
        this.panel1.setLayout(this.borderLayout1);
        this.btnArchive.setEnabled(false);
        this.btnArchive.setToolTipText("");
        this.btnArchive.setText(">>> Take Offline >>>");
        this.btnArchive.addActionListener(new FileManager_btnArchive_actionAdapter(this));
        this.btnRestore.setEnabled(false);
        this.btnRestore.setText("<<< Put Online <<<");
        this.btnRestore.addActionListener(new FileManager_btnRestore_actionAdapter(this));
        this.centerPanel.setLayout(this.verticalFlowLayout1);
        this.btnSendCopyTo.setEnabled(false);
        this.btnSendCopyTo.setText("Send Copy To");
        this.btnSendCopyTo.addActionListener(new FileManager_btnSendCopyTo_actionAdapter(this));
        this.leftPanel.setLayout(this.borderLayout2);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("ONLINE");
        this.rightPanel.setLayout(this.borderLayout3);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("OFFLINE ARCHIVES");
        this.btnDone.setText("Done");
        this.btnDone.addActionListener(new FileManager_btnDone_actionAdapter(this));
        this.btnGetCopyFrom.setText("Get Copy From");
        this.btnGetCopyFrom.addActionListener(new FileManager_btnGetCopyFrom_actionAdapter(this));
        this.btnDelete.setEnabled(false);
        this.btnDelete.setText("Delete a Database");
        this.btnDelete.addActionListener(new FileManager_btnDelete_actionAdapter(this));
        this.jPanel2.setLayout(this.verticalFlowLayout2);
        this.jPanel2.setBackground(Color.lightGray);
        this.jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPanel4.setLayout(this.verticalFlowLayout4);
        this.jPanel4.setBackground(Color.lightGray);
        this.jPanel4.setBorder(BorderFactory.createLoweredBevelBorder());
        this.verticalFlowLayout1.setAlignment(1);
        this.verticalFlowLayout1.setVgap(20);
        this.leftPanel.setBorder(this.border1);
        this.rightPanel.setBorder(this.border2);
        this.jPanel5.setLayout(this.borderLayout4);
        this.activeList.addListSelectionListener(new FileManager_activeList_listSelectionAdapter(this));
        this.inactiveList.addListSelectionListener(new FileManager_inactiveList_listSelectionAdapter(this));
        this.jPanel1.setBackground(Color.lightGray);
        this.jPanel1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.activeList.setBackground(new Color(166, 255, 111));
        this.activeList.setPreferredSize(new Dimension(250, 0));
        this.inactiveList.setBackground(new Color(255, 145, 131));
        this.inactiveList.setPreferredSize(new Dimension(250, 0));
        this.panel1.setPreferredSize(new Dimension(750, 400));
        this.btnNew.setText("Create a New Database");
        this.btnNew.addActionListener(new FileManagerDialog_btnNew_actionAdapter(this));
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.centerPanel, "Center");
        this.panel1.add((Component)this.leftPanel, "West");
        this.panel1.add((Component)this.rightPanel, "East");
        this.rightPanel.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.inactiveList, null);
        this.leftPanel.add((Component)this.activeScrollPane, "Center");
        this.leftPanel.add((Component)this.jLabel2, "North");
        this.leftPanel.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.btnGetCopyFrom, null);
        this.jPanel1.add((Component)this.btnSendCopyTo, null);
        this.activeScrollPane.getViewport().add((Component)this.activeList, null);
        this.rightPanel.add((Component)this.jLabel3, "North");
        this.rightPanel.add((Component)this.jPanel5, "South");
        this.jPanel5.add((Component)this.jPanel6, "East");
        this.jPanel6.add((Component)this.btnDone, null);
        this.centerPanel.add((Component)this.jPanel4, null);
        this.centerPanel.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.btnNew, null);
        this.jPanel2.add((Component)this.btnDelete, null);
        this.jPanel4.add((Component)this.btnRestore, null);
        this.jPanel4.add((Component)this.btnArchive, null);
    }

    private void _$15903() {
        this._$15284(".moj", this.activeList);
        this._$15284(".moa", this.inactiveList);
        this.activeList.clearSelection();
        this.inactiveList.clearSelection();
    }

    private void _$15284(String sfx, JList jList) {
        File directory = new File(FilePath.toDataFiles());
        if (!directory.exists()) {
            return;
        }
        Vector<FileManagerFile> list = new Vector<FileManagerFile>();
        String[] fileNames = directory.list();
        for (int i2 = 0; i2 < fileNames.length; ++i2) {
            if (!fileNames[i2].toLowerCase().endsWith(sfx)) continue;
            list.addElement(new FileManagerFile(FilePath.toDataFiles(fileNames[i2])));
        }
        jList.setListData(list);
    }

    private void _$6438() {
        try {
            this.dbManager.closeAllDataBases();
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
        new AutoOpener(this.frame, this.dbManager).openDataFiles();
    }

    private boolean _$15907(FileManagerFile file) {
        if (!file.hasIPasDescriptor()) {
            return true;
        }
        int rslt = JOptionPane.showConfirmDialog(this.frame, "Use caution when removing a file containing iPAS student information.\n\nAll students in this file will be removed from the online student roster.\nTherefore, they will no longer have access to the iPAS Online School Account\nfor downloading assignments and uploading results.\n\nAre you sure you want to remove this file from the active list?", "IPas Librarian", 0, 3);
        return rslt == 0;
    }

    protected void processWindowEvent(WindowEvent e2) {
        if (e2.getID() == 201) {
            this._$6438();
            super.processWindowEvent(e2);
        }
    }

    void btnDone_actionPerformed(ActionEvent e2) {
        this._$6438();
        this.hide();
    }

    void activeList_valueChanged(ListSelectionEvent e2) {
        if (e2.getValueIsAdjusting()) {
            return;
        }
        if (!this.selectionChanging) {
            this.selectionChanging = true;
            this.inactiveList.clearSelection();
            this.selectionChanging = false;
        }
        boolean selectionMade = this.activeList.getSelectedIndex() != -1;
        this.btnArchive.setEnabled(selectionMade);
        this.btnSendCopyTo.setEnabled(selectionMade);
        this.btnDelete.setEnabled(selectionMade);
        if (selectionMade) {
            this.btnDelete.setText("Delete Database");
        }
    }

    void inactiveList_valueChanged(ListSelectionEvent e2) {
        if (e2.getValueIsAdjusting()) {
            return;
        }
        if (!this.selectionChanging) {
            this.selectionChanging = true;
            this.activeList.clearSelection();
            this.selectionChanging = false;
        }
        boolean selectionMade = this.inactiveList.getSelectedIndex() != -1;
        this.btnRestore.setEnabled(selectionMade);
        this.btnSendCopyTo.setEnabled(false);
        this.btnDelete.setEnabled(selectionMade);
        if (selectionMade) {
            this.btnDelete.setText("Delete Archive");
        }
    }

    void btnArchive_actionPerformed(ActionEvent e2) {
        FileManagerFile file = (FileManagerFile)this.activeList.getSelectedValue();
        if (!this._$15907(file)) {
            return;
        }
        String sourceStr = file.getPath();
        String destStr = FileUtils.appendSuffix(FileUtils.removeSuffix(sourceStr), ".moa");
        if (!file.renameTo(destStr)) {
            JOptionPane.showMessageDialog(this.frame, "Unable to create an archive file.", "File Manager", 0);
            return;
        }
        this._$15903();
    }

    void btnRestore_actionPerformed(ActionEvent e2) {
        String sourceStr;
        String destStr;
        FileManagerFile file = (FileManagerFile)this.inactiveList.getSelectedValue();
        if (!file.renameTo(destStr = FileUtils.appendSuffix(FileUtils.removeSuffix(sourceStr = file.getPath()), ".moj"))) {
            JOptionPane.showMessageDialog(this.frame, "Unable to restore the archive file.", "File Manager", 0);
            return;
        }
        this._$15903();
    }

    void btnDelete_actionPerformed(ActionEvent e2) {
        int rslt;
        FileManagerFile file;
        int activeIndex = this.activeList.getSelectedIndex();
        int inactiveIndex = this.inactiveList.getSelectedIndex();
        if (activeIndex != -1) {
            file = (FileManagerFile)this.activeList.getSelectedValue();
            if (!this._$15907(file)) {
                return;
            }
        } else if (inactiveIndex != -1) {
            file = (FileManagerFile)this.inactiveList.getSelectedValue();
        } else {
            return;
        }
        if ((rslt = JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to delete this file.\nFile: " + file.toString(), "File Manager", 0, 3)) == 0) {
            file.erase();
            this._$15903();
        }
    }

    public void show() {
        try {
            this.dbManager.closeAllDataBases();
            super.show();
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
    }

    void btnGetCopyFrom_actionPerformed(ActionEvent e2) {
        File file = new LoadFileDialog(this.frame, FilePath.toDataFiles()).choose();
        if (file != null) {
            String dest = FilePath.toDataFiles(file.getName());
            FileUtils.copyFile(file.getPath(), dest);
            if (new File(dest).exists()) {
                JOptionPane.showMessageDialog(this.frame, "The file was successfully copied.\nFile: " + file.getName(), "File Manager", 1);
                this._$15903();
            } else {
                JOptionPane.showMessageDialog(this.frame, "File did not copy.\nFile: " + file.getName(), "File Manager", 0);
            }
        }
    }

    void btnSendCopyTo_actionPerformed(ActionEvent e2) {
        FileManagerFile sourceFile = (FileManagerFile)this.activeList.getSelectedValue();
        File destFile = new SaveFileDialog(this.frame, sourceFile.getFileName(), sourceFile.toString()).choose();
        if (destFile == null) {
            return;
        }
        FileUtils.copyFile(sourceFile.getPath(), destFile.getPath());
        if (destFile.exists()) {
            JOptionPane.showMessageDialog(this.frame, "The file was successfully copied.\nFile: " + destFile.getName(), "File Manager", 1);
            this._$15903();
        } else {
            JOptionPane.showMessageDialog(this.frame, "File did not copy.\nFile: " + destFile.getName(), "File Manager", 0);
        }
    }

    void btnNew_actionPerformed(ActionEvent e2) {
        try {
            NewDataBaseDialog dialog = new NewDataBaseDialog(this.frame);
            dialog.show();
            if (!dialog.okayClicked) {
                return;
            }
            String filePath = FileUtils.appendSuffix(dialog.getTemplatePath(), Constants.TEMPLATE_SUFFIX);
            DataBase db = this.dbManager.openDataBase(filePath);
            db.saveAs(dialog.getFilePath());
            db.setTitle(dialog.getFileTab());
            db.setFileID(System.currentTimeMillis());
            db.save();
        }
        catch (IOException ex2) {
            Utils.showErrorMessage(this.frame, ex2, "New File Error");
        }
        this._$15903();
    }
}

