/*
 * Decompiled with CFR 0.152.
 */
package pymo.io;

import java.io.IOException;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;
import pymo.security.Constants;

public class MOFileHeader {
    private short _$10039 = 0;
    private long _$2368 = 0L;
    private String _$716 = null;
    private short _$10040 = 0;
    private boolean _$6003 = true;

    public MOFileHeader() {
    }

    public MOFileHeader(short fileType, long fileID, String title) {
        this._$10039 = fileType;
        this._$2368 = fileID;
        this._$716 = title;
    }

    public MOFileHeader(MOFileReader reader) throws IOException {
        this._$7341(reader);
    }

    public MOFileHeader(MOFileHeader header) {
        this._$10039 = header._$10039;
        this._$2368 = header._$2368;
        this._$716 = header._$716;
    }

    private void _$7341(MOFileReader reader) throws IOException {
        if (reader.readFirstClusterHeader().compareTo(Constants.MOJ_FILE_SIGNATURE) != 0) {
            throw new IOException("Unsupported (or corrupted) file format.");
        }
        this._$2368 = reader.readLong();
        int majorVersion = reader.readByte();
        int minorVersion = reader.readByte();
        if (majorVersion > Constants.MAJOR_FILE_VERSION) {
            throw new IOException("This file was created on a more recent version of this program. Update and try again");
        }
        this._$10039 = reader.readShort();
        this._$716 = reader.readFixedString(16);
        this._$10040 = reader.readShort();
        this._$6003 = false;
        this.setAccess((short)0);
    }

    public void write(MOFileWriter writer) throws IOException {
        writer.seek(0L);
        writer.writeClusterHeader(Constants.MOJ_FILE_SIGNATURE, this._$10046());
        writer.writeLong(this._$2368);
        writer.writeByte(Constants.MAJOR_FILE_VERSION);
        writer.writeByte(Constants.MINOR_FILE_VERSION);
        writer.writeShort(this._$10039);
        writer.writeFixedString(this._$716, 16);
        writer.writeShort(this._$10040);
        this._$6003 = false;
    }

    public void create(MOFileWriter writer) throws IOException {
        boolean hold = this._$6003;
        this.write(writer);
        writer.writeClusterMarker(Constants.LAST_CLUSTER_MARKER);
        this._$6003 = hold;
    }

    public void save(MOFileWriter writer) throws IOException {
        if (this._$6003) {
            this.write(writer);
        }
    }

    private int _$10046() {
        return 30;
    }

    public String getTitle() {
        return this._$716;
    }

    public void setTitle(String title) {
        this._$716 = title;
        this._$6003 = true;
    }

    public void setFileID(long fileID) {
        this._$2368 = fileID;
        this._$6003 = true;
    }

    public long getDataBaseID() {
        return this._$2368;
    }

    public short getFileType() {
        return this._$10039;
    }

    public void setAccess(short accessMode) {
        this._$10040 = accessMode;
        this._$6003 = true;
    }

    public String getAccessStr() {
        if (this._$10040 == 0) {
            return "Editable";
        }
        if (this._$10040 == 1) {
            return "READ ONLY";
        }
        return "GUEST (READ ONLY)";
    }

    public boolean needsSaving() {
        return this._$6003;
    }
}

