/*
 * Decompiled with CFR 0.152.
 */
package pymo.io;

import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import pymo.io.MOFileReader;

public class MOVersion1Reader
extends MOFileReader {
    public MOVersion1Reader(File file) throws IOException {
        super(file);
    }

    public MOVersion1Reader(String fileName) throws IOException {
        super(fileName);
    }

    public short readShort() throws IOException {
        int b1 = this.readByte();
        int b2 = this.readByte();
        return new Integer(b1 + b2 * 256).shortValue();
    }

    public int readInt() throws IOException {
        int mult = 1;
        int total = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            total += this.readByte() * mult;
            mult *= 256;
        }
        return total;
    }

    public long readLong() throws IOException {
        int mult = 1;
        long total = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            total += (long)(this.readByte() * mult);
            mult *= 256;
        }
        return total;
    }

    public Timestamp readTimestamp() throws IOException {
        int mult = 1;
        long total = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            total += (long)(this.readByte() * mult);
            mult *= 256;
        }
        return new Timestamp(total);
    }

    public String readFixedString(int fixedSize) throws IOException {
        StringBuffer str = new StringBuffer(fixedSize);
        int len = this.readByte();
        for (int i2 = 0; i2 < fixedSize; ++i2) {
            int b2 = this.readByte();
            if (b2 <= 0 || i2 >= len) continue;
            str.append((char)b2);
        }
        return str.toString();
    }
}

