/*
 * Decompiled with CFR 0.152.
 */
package pymo.layout;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import pymo.components.MOComponent;
import pymo.components.MOComponentEvent;
import pymo.components.MOComponentListener;
import pymo.dataBases.DataBase;
import pymo.descriptors.AbstractFieldDescriptor;
import pymo.descriptors.ComboBoxDescriptor;
import pymo.descriptors.DescriptorList;
import pymo.descriptors.RealNumberDescriptor;
import pymo.layout.FieldTypeEditorDialog;
import pymo.panels.MOToolBar;
import pymo.records.RecordDialog;

public class LayoutEditorBar
extends MOToolBar {
    private JToggleButton _$17598 = new JToggleButton();
    private JToggleButton _$16453 = new JToggleButton();
    private JToggleButton _$17599 = new JToggleButton();
    private JToggleButton _$15900 = new JToggleButton();
    private JToggleButton _$15988 = new JToggleButton();
    private JToggleButton _$6557 = new JToggleButton();
    private RecordDialog _$7450;
    private Frame _$483;
    private DataBase _$7307;
    private FieldTypeEditorDialog _$2479;
    private Point _$17600;
    private MOComponent _$17601 = null;
    private Vector _$17602 = new Vector();
    private MOComponentListener _$9641 = new MOComponentListener(){

        public void mouseClickedInComponent(MOComponentEvent event) {
            LayoutEditorBar.this._$17603(event);
        }
    };
    private MOComponentListener _$9643 = new MOComponentListener(){

        public void mouseDraggedInComponent(MOComponentEvent event) {
            LayoutEditorBar.this._$17604(event);
        }
    };
    private MOComponentListener _$9645 = new MOComponentListener(){

        public void focusGainedInComponent(MOComponentEvent event) {
            LayoutEditorBar.this._$17605(event);
        }
    };
    boolean initialized = false;

    public LayoutEditorBar() {
        try {
            this._$550();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public LayoutEditorBar(Frame frame, RecordDialog ownerDialog, DataBase dataBase) {
        this();
        this._$2479 = new FieldTypeEditorDialog(frame);
        this._$7450 = ownerDialog;
        this._$483 = frame;
        this._$7307 = dataBase;
    }

    private void _$550() throws Exception {
        this._$17598.setActionCommand("select");
        this._$17598.setFocusPainted(false);
        this._$17598.setText("Select");
        this._$17598.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                LayoutEditorBar.this.processToolClicked(e2);
            }
        });
        this._$16453.setActionCommand("add");
        this._$16453.setFocusPainted(false);
        this._$16453.setText("Add");
        this._$16453.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                LayoutEditorBar.this.processToolClicked(e2);
            }
        });
        this._$17599.setEnabled(false);
        this._$17599.setActionCommand("edit");
        this._$17599.setFocusPainted(false);
        this._$17599.setText("Edit");
        this._$17599.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                LayoutEditorBar.this.processToolClicked(e2);
            }
        });
        this._$15900.setEnabled(false);
        this._$15900.setActionCommand("delete");
        this._$15900.setFocusPainted(false);
        this._$15900.setText("Delete");
        this._$15900.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                LayoutEditorBar.this.processToolClicked(e2);
            }
        });
        this._$15988.setEnabled(false);
        this._$15988.setActionCommand("save");
        this._$15988.setFocusPainted(false);
        this._$15988.setText("Save");
        this._$15988.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                LayoutEditorBar.this.processToolClicked(e2);
            }
        });
        this._$6557.setActionCommand("exit");
        this._$6557.setFocusPainted(false);
        this._$6557.setText("Exit");
        this._$6557.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                LayoutEditorBar.this.processToolClicked(e2);
            }
        });
        this.leftSide.add((Component)this._$17598, null);
        this.centerArea.add((Component)this._$16453, null);
        this.centerArea.add((Component)this._$17599, null);
        this.centerArea.add((Component)this._$15900, null);
        this.centerArea.add((Component)this._$15988, null);
        this.rightSide.add((Component)this._$6557, null);
    }

    private void _$17607(JToggleButton button) {
        this._$16453.setSelected(button.equals(this._$16453));
        this._$17599.setSelected(button.equals(this._$17599));
        this._$17598.setSelected(button.equals(this._$17598));
        this._$15900.setSelected(button.equals(this._$15900));
        this._$15988.setSelected(button.equals(this._$15988));
        this._$6557.setSelected(button.equals(this._$6557));
    }

    private void _$17608() {
        this._$7450.getMOPanel().setupFields();
        this._$7450.repaint();
    }

    private void _$17609() {
        try {
            this._$7307.loadDescriptors();
            this._$17608();
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this, "Unable to undo changes.");
        }
    }

    private Point _$17610() {
        DescriptorList descriptors = this._$7307.getDescriptors();
        boolean found = true;
        Point location = new Point(10, 10);
        while (found) {
            AbstractFieldDescriptor descriptor = descriptors.getDescriptorAt(location);
            if (descriptor == null) {
                return location;
            }
            location.translate(10, 10);
        }
        return new Point(10, 10);
    }

    private void _$17611() {
        this._$17607(this._$17598);
        this._$17599.setEnabled(false);
        this._$15900.setEnabled(false);
        this._$7450.getMOPanel().setComponentCursor(Cursor.getPredefinedCursor(13));
        this._$17612();
    }

    private void _$17613() {
        this._$17607(this._$16453);
        this._$2479.resetValues();
        this._$2479.show();
        if (this._$2479.okayPressed) {
            AbstractFieldDescriptor descriptor = this._$2479.getFieldDescriptor();
            descriptor.setFieldIndex(this._$7307.getDescriptors().getLastFieldIndex() + 1);
            Point location = this._$17610();
            descriptor.setBounds(new Rectangle(location.x, location.y, -1, -1));
            this._$7307.getDescriptors().addDescriptor(descriptor);
            this._$17608();
            this._$17611();
            this._$15988.setEnabled(true);
            JOptionPane.showMessageDialog(this, "The new field titled [" + descriptor.getName() + "] will appear in the record layout. " + "Drag the new field to the location you choose.");
            this._$7450.getMOPanel().setSelectedComponent(descriptor);
        } else {
            this._$16453.setSelected(false);
        }
    }

    private void _$17615() {
        this._$17607(this._$17599);
        AbstractFieldDescriptor origDescriptor = this._$17601.getOwnerDescriptor();
        this._$2479.setValues(origDescriptor, false);
        this._$2479.show();
        this._$17608();
        if (this._$2479.okayPressed) {
            AbstractFieldDescriptor newDescriptor = this._$2479.getFieldDescriptor();
            origDescriptor.setName(newDescriptor.getName());
            origDescriptor.setLimit((short)newDescriptor.getLimit());
            if (origDescriptor.getPanelID() != newDescriptor.getPanelID()) {
                origDescriptor.setLocation(this._$17610());
            }
            origDescriptor.setPanelID(newDescriptor.getPanelID());
            origDescriptor.setInitialValue(newDescriptor.getInitialValue());
            if (ComboBoxDescriptor.class.isInstance(origDescriptor)) {
                ((ComboBoxDescriptor)origDescriptor).setValues(((ComboBoxDescriptor)newDescriptor).getValues());
            }
            if (RealNumberDescriptor.class.isInstance(origDescriptor)) {
                ((RealNumberDescriptor)origDescriptor).setFractionDigits(((RealNumberDescriptor)newDescriptor).getFractionDigits());
            }
            this._$17608();
            this._$15988.setEnabled(true);
        }
        this._$17611();
    }

    private void _$17620() {
        if (this._$17601 == null) {
            return;
        }
        AbstractFieldDescriptor descriptor = this._$17601.getOwnerDescriptor();
        this._$17602.addElement(descriptor);
        this._$7307.getDescriptors().removeDescriptor(descriptor);
        this._$17599.setEnabled(false);
        this._$15900.setEnabled(false);
        this._$15988.setEnabled(true);
        this._$17608();
        this._$17611();
    }

    private void _$17621() {
        try {
            this._$7307.save();
            this._$7307.deleteDescriptors(this._$17602);
            this._$17608();
            this._$15988.setEnabled(false);
            this._$17599.setEnabled(false);
            this._$15900.setEnabled(false);
            this._$17611();
        }
        catch (Exception e12) {
            JOptionPane.showMessageDialog(this, "Unable to save changes.");
            this._$17609();
        }
    }

    public void exitClicked() {
        if (this._$15988.isEnabled()) {
            if (JOptionPane.showConfirmDialog(this._$483, "Save changes before exiting?", "Exit", 0) == 0) {
                this._$17621();
            } else {
                this._$17609();
            }
        }
        this._$17622();
        this._$7450.getMOPanel().setComponentCursor(Cursor.getPredefinedCursor(0));
        this._$7450.hide();
    }

    private void _$17612() {
        this._$17622();
        int len = this._$7450.getMOPanel().fieldComponentCount();
        for (int i2 = 0; i2 < len; ++i2) {
            MOComponent component = this._$7450.getMOPanel().getFieldComponent(i2);
            component.addListener(this._$9641);
            component.addListener(this._$9645);
            component.addListener(this._$9643);
        }
    }

    private void _$17622() {
        int len = this._$7450.getMOPanel().fieldComponentCount();
        for (int i2 = 0; i2 < len; ++i2) {
            MOComponent component = this._$7450.getMOPanel().getFieldComponent(i2);
            component.removeListener(this._$9641);
            component.removeListener(this._$9645);
            component.removeListener(this._$9643);
        }
    }

    private void _$17603(MOComponentEvent e2) {
        this._$17601 = e2.getComponent();
        this._$17600 = e2.location;
        this._$17600.translate(-this._$17601.getX(), -this._$17601.getY());
        this._$17599.setEnabled(true);
        this._$15900.setEnabled(true);
    }

    private void _$17605(MOComponentEvent e2) {
        this._$17601 = e2.getComponent();
        this._$17599.setEnabled(true);
        this._$15900.setEnabled(true);
    }

    private void _$17604(MOComponentEvent e2) {
        MOComponent component = e2.getComponent();
        Point newLocation = e2.location;
        newLocation.translate(-this._$17600.x, -this._$17600.y);
        JPanel ownerPanel = (JPanel)this._$17601.getParent();
        newLocation.x = (newLocation.x + component.getWidth()) / 5 * 5 - component.getWidth();
        newLocation.y = newLocation.y / 3 * 3;
        newLocation.x = Math.max(newLocation.x, 2);
        newLocation.y = Math.max(newLocation.y, 2);
        newLocation.x = Math.min(newLocation.x, ownerPanel.getWidth() - component.getWidth() - 2);
        newLocation.y = Math.min(newLocation.y, ownerPanel.getHeight() - component.getHeight() - 2);
        component.setLocation(newLocation);
        AbstractFieldDescriptor descriptor = component.getOwnerDescriptor();
        descriptor.setLocation(newLocation.x, newLocation.y);
        this._$15988.setEnabled(true);
    }

    void processToolClicked(ActionEvent e2) {
        this._$7450.getMOPanel().setComponentCursor(Cursor.getPredefinedCursor(0));
        if (e2.getActionCommand().equals("exit")) {
            this.exitClicked();
        }
        if (e2.getActionCommand().equals("save")) {
            this._$17621();
        }
        if (e2.getActionCommand().equals("add")) {
            this._$17613();
        }
        if (e2.getActionCommand().equals("select")) {
            this._$17611();
        }
        if (e2.getActionCommand().equals("edit")) {
            this._$17615();
        }
        if (e2.getActionCommand().equals("delete")) {
            this._$17620();
        }
    }

    public void initializeToolBar() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            this._$7307.save();
        }
        catch (IOException e2) {
            JOptionPane.showMessageDialog(this, "Unable to save the database.");
        }
        this._$17602.removeAllElements();
        this._$17611();
    }
}

