/*
 * Decompiled with CFR 0.152.
 */
package pymo.menus;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import pymo.dataBases.DataBase;
import pymo.dataBases.DataBaseManager;
import pymo.dataBases.DataBasePrefsDialog;
import pymo.iPasDBTools.reports.IPasReportSelectorDialog;
import pymo.io.BackupRestore;
import pymo.io.FileManagerDialog;
import pymo.io.TemplateEditorDialog;
import pymo.reports.LabelWizard;
import pymo.reports.SpreadsheetReport;
import pymo.security.ApplicationOptionsDialog;
import pymo.security.Settings;
import pyware.toolkit.Utils;

public class FileMenu
extends JMenu {
    private Frame _$7451;
    private DataBaseManager _$531;
    private JMenuItem _$9136 = new JMenuItem();
    private JMenuItem _$9137 = new JMenuItem();
    private JMenuItem _$9138 = new JMenuItem();
    private JMenuItem _$9139 = new JMenuItem();
    private JMenuItem _$9140 = new JMenuItem();
    private JMenuItem _$9141 = new JMenuItem();
    private JMenuItem _$9142 = new JMenuItem();
    private JMenuItem _$9143 = new JMenuItem();
    private JMenuItem _$9144 = new JMenuItem();

    public FileMenu() {
        try {
            this._$550();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public FileMenu(Frame mainFrame, DataBaseManager dbManager) {
        this();
        this._$7451 = mainFrame;
        this._$531 = dbManager;
    }

    private void _$550() {
        this.setText("File");
        this._$9136.setText("File Manager");
        this._$9136.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this._$9136.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                FileMenu.this.open();
            }
        });
        this._$9137.setText("Backup / Restore");
        this._$9137.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                FileMenu.this.backupFrontDB();
            }
        });
        this._$9138.setText("Template Library");
        this._$9138.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                FileMenu.this.createTemplate();
            }
        });
        this._$9139.setText("Print");
        this._$9139.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this._$9139.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                FileMenu.this.print();
            }
        });
        this._$9140.setText("Print Labels");
        this._$9140.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                FileMenu.this.printLabels();
            }
        });
        this._$9141.setText("IPas Reports");
        this._$9141.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                FileMenu.this.printIpas();
            }
        });
        this._$9142.setText("Database Preferences");
        this._$9142.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                FileMenu.this.documentOptions();
            }
        });
        this._$9143.setText("Application Options");
        this._$9143.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                FileMenu.this.applicationOptions();
            }
        });
        this._$9144.setText("Exit");
        this._$9144.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this._$9144.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                FileMenu.this.exit();
            }
        });
        this.add(this._$9136);
        this.add(this._$9137);
        this.add(this._$9139);
        this.add(this._$9140);
        this.add(this._$9141);
        this.addSeparator();
        this.add(this._$9138);
        this.addSeparator();
        this.add(this._$9142);
        this.add(this._$9143);
        this.addSeparator();
        this.add(this._$9144);
    }

    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        try {
            this._$531.saveAllDataBases();
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this._$7451, e2, "Saving All DataBases", 0);
        }
        boolean opened = this._$531.getDataBaseCount() > 0;
        this._$9137.setEnabled(opened);
        this._$9139.setEnabled(opened);
        this._$9140.setEnabled(opened);
        this._$9141.setEnabled(opened);
        this._$9142.setEnabled(opened);
        this._$9137.setEnabled(opened);
        if (opened) {
            DataBase frontDB = this._$531.getFrontDataBase();
            this._$9141.setEnabled(this._$531.getIPasDBOrganizer().isIPasDB(frontDB));
        }
    }

    private boolean _$2750() {
        Settings settings = this._$531.getSettings();
        if (settings.isRestrictionSet(Settings.PRINT_RESTRICTION)) {
            JOptionPane.showMessageDialog(this._$7451, "This installation of " + settings.getApplicationName() + " is restricted from printing.");
            return false;
        }
        return true;
    }

    public void exit() {
        if (this._$531.anyFilesUnsaved()) {
            try {
                this._$531.saveAllDataBases();
            }
            catch (IOException e2) {
                JOptionPane.showMessageDialog(this._$7451, e2, "Unable to save file.", 0);
            }
        }
        this._$531.getSettings().trySave();
        this._$531.getIPasLibrarian().cleanup();
        System.exit(0);
    }

    public void closeFrontDB() {
        try {
            this._$531.closeDataBase(this._$531.getFrontDataBase());
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this._$7451, e2, "Close File Error", 0);
        }
    }

    public void backupFrontDB() {
        new BackupRestore(this._$7451, this._$531).show();
    }

    public void open() {
        new FileManagerDialog(this._$7451, this._$531).show();
    }

    public void documentOptions() {
        try {
            new DataBasePrefsDialog(this._$7451, this._$531.getSettings(), this._$531.getFrontDataBase()).show();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "Document Options Error");
        }
    }

    public void applicationOptions() {
        try {
            new ApplicationOptionsDialog(this._$7451, this._$531.getIPasLibrarian(), this._$531.getSettings()).show();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "Application Options Error");
        }
    }

    public void print() {
        if (!this._$2750()) {
            return;
        }
        new SpreadsheetReport(this._$7451, this._$531.getFrontDataBase(), this._$531.getSettings()).show();
    }

    public void printLabels() {
        if (!this._$2750()) {
            return;
        }
        new LabelWizard(this._$7451, this._$531.getFrontDataBase(), this._$531.getSettings()).show();
    }

    public void printIpas() {
        try {
            new IPasReportSelectorDialog(this._$7451, this._$531).show();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "iPAS Reports");
        }
    }

    public void createTemplate() {
        new TemplateEditorDialog(this._$7451, this._$531).show();
    }
}

