/*
 * Decompiled with CFR 0.152.
 */
package pymo.records;

import java.io.IOException;
import pymo.fields.Field;
import pymo.fields.FieldList;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;
import pymo.security.Constants;

public class Record {
    private static int _$8961 = 32;
    private boolean _$6003 = true;
    private long _$8540 = -1L;
    private int _$8541 = -1;
    private long _$7337 = 0L;
    private FieldList _$6751 = null;

    public Record() {
        this._$7337 = System.currentTimeMillis();
    }

    public Record(long id) {
        this._$7337 = id;
    }

    public Record(long recordID, byte[] data) {
        this._$7337 = recordID;
        if (data != null) {
            this._$6751 = new FieldList(data);
        }
    }

    public Record(MOFileReader reader) throws IOException {
        this._$8540 = reader.getClusterLocation();
        this._$8541 = reader.getClusterSize();
        this._$7337 = reader.readLong();
        this._$6003 = false;
    }

    public Record(Record record) {
        this._$8540 = record._$8540;
        this._$8541 = record._$8541;
        this._$7337 = record._$7337;
        if (record._$6751 != null) {
            this._$6751 = new FieldList(record._$6751);
        }
    }

    private void _$7341(MOFileReader reader) throws IOException {
        if (this._$8540 == -1L && this._$6751 == null) {
            this._$6751 = new FieldList();
            return;
        }
        reader.seek(this._$8540 + 8L);
        this._$7337 = reader.readLong();
        byte[] data = new byte[this._$8541 - 8];
        reader.readByteArray(data);
        this._$6751 = new FieldList(data);
        this._$6003 = false;
    }

    private void _$6548(MOFileWriter writer) throws IOException {
        int newClusterSize;
        if (!this.isOpened()) {
            return;
        }
        if (!this.isChanged()) {
            return;
        }
        byte[] data = this._$6751.toData();
        if (data == null) {
            data = new byte[]{};
        }
        if ((newClusterSize = data.length + 8) == this._$8541) {
            writer.seek(this._$8540 + 8L);
            writer.writeLong(this._$7337);
            writer.writeByteArray(data);
        } else if (newClusterSize > this._$8541) {
            data = this._$6751.toData(_$8961);
            long newClusterLocation = writer.getFileLength() - 8L;
            newClusterSize = data.length + 8;
            writer.seek(newClusterLocation);
            writer.writeClusterHeader(Constants.RECORD_CLUSTER_MARKER, newClusterSize);
            writer.writeLong(this._$7337);
            writer.writeByteArray(data);
            writer.writeClusterMarker(Constants.LAST_CLUSTER_MARKER);
            if (this._$8540 != -1L) {
                writer.seek(this._$8540);
                writer.writeClusterHeader(Constants.EMPTY_CLUSTER_MARKER, this._$8541);
            }
            this._$8541 = newClusterSize;
            this._$8540 = newClusterLocation;
        } else {
            writer.seek(this._$8540 + 8L);
            writer.writeLong(this._$7337);
            writer.writeByteArray(data);
        }
        this._$6003 = false;
    }

    void appendTo(MOFileWriter destination) throws IOException {
        byte[] data = this._$6751.toData(_$8961);
        int newClusterSize = data.length + 8;
        destination.seek(destination.getFileLength() - 8L);
        destination.writeClusterHeader(Constants.RECORD_CLUSTER_MARKER, newClusterSize);
        destination.writeLong(this._$7337);
        destination.writeByteArray(data);
        destination.writeClusterMarker(Constants.LAST_CLUSTER_MARKER);
    }

    void delete(MOFileWriter writer) throws IOException {
        if (this._$8540 != -1L) {
            writer.seek(this._$8540);
            writer.writeClusterHeader(Constants.EMPTY_CLUSTER_MARKER, this._$8541);
        }
        this._$8540 = -1L;
        this._$8541 = -1;
        this._$6751 = null;
        this._$6003 = false;
    }

    void open(MOFileReader reader) throws IOException {
        if (this.isOpened()) {
            return;
        }
        this._$7341(reader);
    }

    void close(MOFileWriter writer) throws IOException {
        this.save(writer);
        this._$6751 = null;
    }

    void save(MOFileWriter writer) throws IOException {
        this._$6548(writer);
    }

    Field getFieldData(int fieldIndex) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Can't getFieldData. Record is not opened.");
        }
        return new Field(this._$6751.fieldAt(fieldIndex));
    }

    void putFieldData(int fieldIndex, Field field) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Can't putFieldData. Record is not opened.");
        }
        this._$6751.setFieldAt(field, fieldIndex);
        this._$6003 = true;
    }

    public void expandTotalFields(int totalFields) {
        for (int i2 = this._$6751.size(); i2 < totalFields; ++i2) {
            this._$6751.add(new Field());
            this._$6003 = true;
        }
    }

    public void setFieldDeleteFlag(int index, boolean deleteFlag) throws IOException {
        Field field = this.getFieldData(index);
        if (field.isDeleteSet() && deleteFlag) {
            return;
        }
        if (!field.isDeleteSet() && !deleteFlag) {
            return;
        }
        field.setDeleteFlag(deleteFlag);
        this.putFieldData(index, field);
    }

    public int fieldCountInRecord() {
        return this._$6751.size();
    }

    public long getRecordID() {
        return this._$7337;
    }

    boolean isOpened() {
        return this._$6751 != null;
    }

    boolean isChanged() {
        return this._$6003;
    }
}

