/*
 * Decompiled with CFR 0.152.
 */
package pymo.records;

import java.io.IOException;
import pymo.io.MOFileReader;
import pymo.records.MasterList;
import pymo.records.Record;
import pymo.records.RecordManager;
import pymo.security.Constants;

public class RecordReader {
    RecordManager recordManager = null;
    float totalEmpty = 0.0f;
    float totalUsed = 0.0f;

    public RecordReader(RecordManager recordManager) {
        this.recordManager = recordManager;
    }

    public MasterList createMasterList() throws IOException {
        MasterList records = new MasterList(this.recordManager);
        this.readList(records);
        return records;
    }

    public void readList(MasterList records) throws IOException {
        MOFileReader reader = this.recordManager.getReader();
        reader.readFirstClusterHeader();
        records.removeAllElements();
        reader.readNextClusterHeader();
        this.totalEmpty = 0.0f;
        this.totalUsed = 0.0f;
        while (reader.readNextClusterHeader().compareTo(Constants.LAST_CLUSTER_MARKER) != 0) {
            if (reader.isClusterSignature(Constants.RECORD_CLUSTER_MARKER)) {
                records.addRecordQuietly(new Record(reader));
            }
            if (reader.isClusterSignature(Constants.EMPTY_CLUSTER_MARKER)) {
                this.totalEmpty += (float)reader.getClusterSize();
                continue;
            }
            this.totalUsed += (float)reader.getClusterSize();
        }
        records.sort();
        records.dispatchListChanged();
    }

    public int getPercentEmpty() {
        return this.totalUsed == 0.0f ? 0 : new Float(this.totalEmpty / (this.totalUsed + this.totalEmpty) * 100.0f).intValue();
    }

    public int calculatePercentEmpty() throws IOException {
        MOFileReader reader = this.recordManager.getReader();
        reader.readFirstClusterHeader();
        this.totalEmpty = 0.0f;
        this.totalUsed = 0.0f;
        while (reader.readNextClusterHeader().compareTo(Constants.LAST_CLUSTER_MARKER) != 0) {
            if (reader.isClusterSignature(Constants.EMPTY_CLUSTER_MARKER)) {
                this.totalEmpty += (float)reader.getClusterSize();
                continue;
            }
            this.totalUsed += (float)reader.getClusterSize();
        }
        return this.getPercentEmpty();
    }
}

