/*
 * Decompiled with CFR 0.152.
 */
package pymo.reports.labelWizard;

import com.wildcrest.j2printerworks.J2Printer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;

class PrintingStatusListener
implements PropertyChangeListener {
    JLabel status;
    J2Printer printer;
    int totalPages;

    PrintingStatusListener(J2Printer printer, JLabel status) {
        this.printer = printer;
        this.status = status;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("printing")) {
            if (this.printer.isPrinting()) {
                this.status.setText("About to print...");
                this.totalPages = this.printer.getPageable().getNumberOfPages();
            } else if (this.printer.isPrintDialogResponse()) {
                this.status.setText("Printing finished.");
            }
        }
        if (evt.getPropertyName().equals("printDialogResponse")) {
            if (this.printer.isPrintDialogResponse()) {
                this.status.setText("Start printing...");
            } else {
                this.status.setText("Printing cancelled...");
            }
        }
        if (evt.getPropertyName().equals("pageBeingPrinted") && this.printer.isPrinting() && this.printer.getPageBeingPrinted() > 0) {
            int thisPage = this.printer.getPageBeingPrinted();
            this.status.setText("Printing page " + thisPage + " of " + this.totalPages);
        }
    }
}

