/*
 * Decompiled with CFR 0.152.
 */
package pymo.searcher;

import java.io.IOException;
import pymo.dataBases.DataBase;
import pymo.descriptors.AbstractFieldDescriptor;
import pymo.descriptors.DescriptorList;
import pymo.fields.Field;
import pymo.records.RecordList;
import pymo.searcher.SearchItem;
import pymo.searcher.SearchModel;

public class Searcher {
    DataBase dataBase;
    private SearchModel _$6851;
    private RecordList _$6752;
    private RecordList _$8374;

    public Searcher(DataBase dataBase) throws IOException {
        this.dataBase = dataBase;
        this._$8374 = new RecordList(dataBase.getRecordManager());
    }

    private boolean _$12167(int recordIndex, int descriptionIndex) throws IOException {
        SearchItem item = this._$6851.searchItemAt(descriptionIndex);
        DescriptorList descriptors = this.dataBase.getDescriptors();
        long id = item.getDescriptorID();
        int modifier = item.getModifier();
        AbstractFieldDescriptor descriptor = descriptors.getFieldDescriptor(id);
        if (descriptor == null) {
            return false;
        }
        Field field1 = this._$6752.getField(recordIndex, descriptor.getFieldIndex());
        Field field2 = item.getField();
        short comparer = item.getComparer();
        if (comparer == SearchItem.COMPARE_EQUAL) {
            return descriptor.compare(modifier, field1, field2) == 0;
        }
        if (comparer == SearchItem.COMPARE_LESS_THAN) {
            return descriptor.compare(modifier, field1, field2) < 0;
        }
        if (comparer == SearchItem.COMPARE_GREATER_THAN) {
            return descriptor.compare(modifier, field1, field2) > 0;
        }
        if (comparer == SearchItem.COMPARE_NOT_EQUAL) {
            return descriptor.compare(modifier, field1, field2) != 0;
        }
        if (comparer == SearchItem.COMPARE_CONTAINS) {
            return descriptor.contains(field1, field2);
        }
        if (comparer == SearchItem.COMPARE_STARTS_WITH) {
            return descriptor.startsWith(field1, field2);
        }
        if (comparer == SearchItem.COMPARE_ENDS_WITH) {
            return descriptor.endsWith(field1, field2);
        }
        return false;
    }

    public RecordList linearSearch(RecordList records, SearchModel searchModel) throws IOException {
        if (searchModel.isEmpty()) {
            return this._$8374;
        }
        this._$6752 = records;
        this._$6851 = searchModel;
        int len = records.size();
        for (int i2 = 0; i2 < len; ++i2) {
            int searchIndex = 0;
            boolean found = true;
            while (found && searchIndex < searchModel.getSearchItemCount()) {
                found = this._$12167(i2, searchIndex++);
            }
            if (!found) continue;
            this._$8374.addElement(records.elementAt(i2));
        }
        return this._$8374;
    }
}

