/*
 * Decompiled with CFR 0.152.
 */
package pymo.security;

import java.awt.Frame;
import javax.swing.JOptionPane;
import pymo.security.Constants;
import pymo.security.Settings;
import pyware.iPasToolkit.interactive.IPasLibrarian;
import pyware.iPasToolkit.interactive.IPasLibrarianEvent;
import pyware.iPasToolkit.interactive.IPasLibrarianException;
import pyware.iPasToolkit.interactive.IPasLibrarianListener;
import pyware.iPasToolkit.interactive.IPasLibrarianTask;

public class InstallValidater {
    private Frame _$483;
    private Settings _$2752;
    private IPasLibrarian _$6591;
    private IPasLibrarianListener _$6956 = null;
    private long _$12484 = System.currentTimeMillis();
    private boolean _$12485 = false;

    public InstallValidater(Frame frame, IPasLibrarian librarian, Settings settings) {
        this._$483 = frame;
        this._$2752 = settings;
        this._$6591 = librarian;
    }

    private void _$2670() {
        this._$6956 = new IPasLibrarianListener(){

            public void taskListFinished(IPasLibrarianEvent event) {
                InstallValidater.this._$6527();
                if (event.getTaskListID() == InstallValidater.this._$12484) {
                    InstallValidater.this._$2752.unblockInstallation();
                    JOptionPane.showMessageDialog(InstallValidater.this._$483, "This installation of " + InstallValidater.this._$2752.getApplicationName() + "\n" + "has been validated.\n\n" + "Thank you.", "Software Validation", 1);
                    InstallValidater.this._$12485 = false;
                }
            }

            public void taskListAborted(IPasLibrarianEvent event) {
                InstallValidater.this._$6527();
                if (event.getTaskListID() == InstallValidater.this._$12484) {
                    JOptionPane.showMessageDialog(InstallValidater.this._$483, "Unable to validate this installation, please try again later.\nUntil validated, the program will fully operate except for printing and online features.\nReason: " + event.getErrorMessage(), "Software Validation", 1);
                    InstallValidater.this._$2752.setAllRestrictions(true);
                    if (event.getErrorID() == (long)IPasLibrarianException.ACCOUNT_EXPIRED) {
                        InstallValidater.this._$2752.askSwitchProgramToLocalOnly(InstallValidater.this._$483);
                    }
                    InstallValidater.this._$12485 = false;
                }
            }
        };
        this._$6591.addListener(this._$6956);
    }

    private void _$6527() {
        if (this._$6956 == null) {
            return;
        }
        this._$6591.removeListener(this._$6956);
        this._$6956 = null;
    }

    private void _$6655() {
        this._$6591.setWorkingOffline(false);
        this._$6591.setOnlineAccountDir(this._$2752.getHomeAccount());
        this._$6591.createNewTaskList(this._$12484);
        this._$6591.addTask(IPasLibrarianTask.createOpenRootDirectory("Accessing iPAS Online."));
        this._$6591.addTask(IPasLibrarianTask.createDownloadSystemPrefsTask(this._$6591.getLocalPath()));
        this._$6591.addTask(IPasLibrarianTask.createOpenAccountTask("Opening the online school account."));
        this._$6591.addTask(IPasLibrarianTask.createDownloadAccountPrefsTask(this._$6591.getLocalPath()));
        this._$2670();
        this._$6591.executeTaskList();
        this._$12485 = true;
        while (this._$12485) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void validate() {
        if (!this._$2752.isSecuritySet(Settings.FTP_INVALID_INSTALL_CHECK)) {
            return;
        }
        if (this._$2752.isBlockDateExpired()) {
            String errorMsg = "Installation was not validated online within the " + Constants.ONLINE_AUTHORIZATION_DEADLINE + " day window.";
            JOptionPane.showMessageDialog(this._$483, "Did not validate your installation.\n" + errorMsg, "Installation Security", 0);
            this._$2752.blockInstallation(errorMsg);
            return;
        }
        if (this._$2752.isBlockDateSet()) {
            int rslt = JOptionPane.showConfirmDialog(this._$483, "This installation of " + this._$2752.getApplicationName() + " must check online to be validated before " + this._$2752.getBlockDate() + '.' + '\n' + "Do you want to do that now?", "Software Validation", 0);
            if (rslt == 0) {
                this._$6655();
            } else {
                JOptionPane.showMessageDialog(this._$483, "Until validated, the program will fully operate except for printing and online features.\n", "Software Validation", 1);
                this._$2752.setAllRestrictions(true);
            }
        }
    }
}

