/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AssignmentItem {
    public long assignDate = 0L;
    public boolean assigned = false;
    public long dueDate = 0L;
    public boolean graph = false;
    public long lessonID;
    public boolean record = false;
    public boolean redoable = false;

    public AssignmentItem(AssignmentItem item) {
        this.lessonID = item.lessonID;
        this.assigned = item.assigned;
        this.assignDate = item.assignDate;
        this.dueDate = item.dueDate;
        this.record = item.record;
        this.graph = item.graph;
        this.redoable = item.redoable;
    }

    public AssignmentItem(long lessonID) {
        this.lessonID = lessonID;
    }

    public AssignmentItem(long lessonID, boolean assigned, long assignDate, long dueDate, boolean record, boolean graph, boolean redoable) {
        this.lessonID = lessonID;
        this.assigned = assigned;
        this.assignDate = assignDate;
        this.dueDate = dueDate;
        this.record = record;
        this.graph = graph;
        this.redoable = redoable;
    }

    public AssignmentItem() {
    }

    public static int getSize() {
        return 28;
    }

    public static AssignmentItem readAssignmentListItem(DataInputStream is) throws IOException {
        long lessonID = is.readLong();
        if (lessonID == 0L) {
            return null;
        }
        AssignmentItem item = new AssignmentItem(lessonID);
        item.assignDate = is.readLong();
        item.dueDate = is.readLong();
        item.record = is.readByte() != 0;
        item.graph = is.readByte() != 0;
        item.redoable = is.readByte() != 0;
        item.assigned = true;
        return item;
    }

    public void writeAssignmentListItem(DataOutputStream os) throws IOException {
        os.writeLong(this.lessonID);
        os.writeLong(this.assignDate);
        os.writeLong(this.dueDate);
        if (this.record) {
            os.writeByte(1);
        } else {
            os.writeByte(0);
        }
        if (this.graph) {
            os.writeByte(1);
        } else {
            os.writeByte(0);
        }
        if (this.redoable) {
            os.writeByte(1);
        } else {
            os.writeByte(0);
        }
    }
}

