/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import pyware.iPasToolkit.interactive.IPasStudentTable;
import pyware.iPasToolkit.interactive.IPasStudentTableRow;

public class GradingScheme {
    public static int GRADE_STYLE_AVERAGE;
    public static int GRADE_STYLE_MERIT;
    public static long MILLIS_PER_DAY;
    public static int TOLERANCE_ABSOLUTE;
    public static int TOLERANCE_RELATIVE;
    public int absAttack = 400;
    public int absPitch = 20;
    public int absRelease = 400;
    public boolean canTurnInPastDue = true;
    boolean changed = false;
    public int deductPerDayPastDue = 5;
    public int demeritPerDayPastDue = 1;
    public int earnedMerits = 0;
    public int grade = 0;
    public int gradeStyle = GRADE_STYLE_AVERAGE;
    public int meritPassPoints = 5;
    public int meritPassScore = 50;
    public int possibleMerits = 0;
    public int relAttack = 0;
    public int relPitch = 0;
    public int relRelease = 0;
    public int toleranceType = TOLERANCE_RELATIVE;
    public boolean useCustomTolerances = false;

    static {
        MILLIS_PER_DAY = 86400000L;
        GRADE_STYLE_AVERAGE = 0;
        GRADE_STYLE_MERIT = 1;
        TOLERANCE_RELATIVE = 0;
        TOLERANCE_ABSOLUTE = 1;
    }

    public GradingScheme(DataInputStream reader) throws IOException {
        this.readFromAsnFile(reader);
    }

    public GradingScheme() {
    }

    public int calcOverdueDeduction(long extendedDueDate, long completionDate, int grade) {
        int days = new Long((completionDate - extendedDueDate) / MILLIS_PER_DAY).intValue();
        int deduction = new Float((float)Math.max(days, 0) * this.getDeductionPerDay()).intValue();
        if (this.gradeStyle == GRADE_STYLE_AVERAGE && deduction > grade) {
            deduction = grade;
        }
        if (this.gradeStyle == GRADE_STYLE_MERIT && deduction > this.meritPassPoints) {
            deduction = this.meritPassPoints;
        }
        return deduction;
    }

    private void _$1413(IPasStudentTable data) {
        int len = data.getRowCount();
        int sum = 0;
        int count = 0;
        int i2 = 0;
        while (i2 < len) {
            IPasStudentTableRow row = data.getRowAt(i2);
            boolean completed = row.isCompleted();
            boolean overdue = row.isOverdue();
            boolean addToActual = false;
            boolean addToPossible = false;
            if (!completed && overdue) {
                addToPossible = true;
            }
            if (completed && !overdue) {
                addToPossible = true;
                addToActual = true;
            }
            if (completed && overdue) {
                addToPossible = true;
                addToActual = true;
            }
            if (addToActual) {
                int aGrade = row.getGrade() - row.getOverdueDeduction(this);
                sum += Math.max(aGrade, 0);
            }
            if (addToPossible) {
                ++count;
            }
            ++i2;
        }
        this.grade = count == 0 ? 0 : Math.round((float)sum / (float)count);
    }

    private void _$1432(IPasStudentTable data) {
        int len = data.getRowCount();
        int actual = 0;
        int possible = 0;
        int i2 = 0;
        while (i2 < len) {
            IPasStudentTableRow row = data.getRowAt(i2);
            boolean completed = row.isCompleted();
            boolean passed = row.getGrade() >= this.meritPassScore;
            boolean overdue = row.isOverdue();
            boolean addToActual = false;
            boolean addToPossible = false;
            if (!completed && !passed && overdue) {
                addToPossible = true;
            }
            if (completed && !passed && !overdue) {
                addToPossible = true;
            }
            if (completed && !passed && overdue) {
                addToPossible = true;
            }
            if (completed && passed && !overdue) {
                addToPossible = true;
                addToActual = true;
            }
            if (completed && passed && overdue) {
                addToPossible = true;
                addToActual = true;
            }
            if (addToActual) {
                int merits = this.meritPassPoints - row.getOverdueDeduction(this);
                actual += Math.max(merits, 0);
            }
            if (addToPossible) {
                possible += this.meritPassPoints;
            }
            ++i2;
        }
        this.earnedMerits = actual;
        this.possibleMerits = possible;
        this.grade = possible == 0 ? 0 : Math.round((float)actual / (float)possible * 100.0f);
    }

    public float getDeductionPerDay() {
        if (this.gradeStyle == GRADE_STYLE_AVERAGE) {
            return this.deductPerDayPastDue;
        }
        if (this.gradeStyle == GRADE_STYLE_MERIT) {
            return this.demeritPerDayPastDue;
        }
        return 0.0f;
    }

    public String getResultStr() {
        String str = "";
        str = this.gradeStyle == GRADE_STYLE_AVERAGE ? "Grade Average=" + this.grade : "Overall Grade=" + this.grade + "  (Merit Points " + this.earnedMerits + " of " + this.possibleMerits + ")";
        return str;
    }

    public String gradingSchemeExplanation() {
        StringBuffer str = new StringBuffer();
        if (this.gradeStyle == GRADE_STYLE_AVERAGE) {
            str.append("Your grade is based on an average of all assignments.  ");
            if (this.canTurnInPastDue) {
                str.append("You can turn in assignments past due, but there will be a " + this.deductPerDayPastDue + " point deduction from an assignments " + "grade for each day the assignment is overdue.  " + "When a grade in the grade column includes a subtraction such " + "as 90-5, the subtraction value is the overdue deduction.  " + "For example: 90-5 has a 5 point deduction, and the student " + "would earn 85 for the assignment.  ");
            } else {
                str.append("Any assignments past due, will be given a zero.  ");
            }
        } else {
            str.append("Your grade is based on merit points earned per assignment.  All assignments scoring at least " + this.meritPassScore + " will be given " + this.meritPassPoints + " merit points.  ");
            if (this.canTurnInPastDue) {
                str.append("You can turn in assignments past due.  However, if an assignment is past due, there will be a " + this.demeritPerDayPastDue + " point deduction from the merit points " + "earned for each day the assignment is overdue.  ");
            } else {
                str.append("Any assignments past due, will be given no merit points.  ");
            }
            str.append("Your grade is the percentage of total possible merit points that you have earned.  ");
            if (this.gradeStyle == GRADE_STYLE_MERIT) {
                str.append("The Grd|Pt column shows both the assignment grade and the merit points earned for the assignment.  For example: 100|5 earned 5 merit points for an assignment that was given an assessment grade of 100.  ");
            }
        }
        return str.toString();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void readFromAsnFile(DataInputStream reader) throws IOException {
        this.gradeStyle = reader.readByte();
        this.deductPerDayPastDue = reader.readByte();
        this.meritPassScore = reader.readByte();
        this.meritPassPoints = reader.readByte();
        this.demeritPerDayPastDue = reader.readByte();
        this.canTurnInPastDue = reader.readBoolean();
        this.useCustomTolerances = reader.readBoolean();
        this.toleranceType = reader.readByte();
        this.absPitch = reader.readShort();
        this.absAttack = reader.readShort();
        this.absRelease = reader.readShort();
        this.relPitch = reader.readShort();
        this.relAttack = reader.readShort();
        this.relRelease = reader.readShort();
    }

    public int recalcOverallGrade(IPasStudentTable data) {
        if (this.gradeStyle == GRADE_STYLE_AVERAGE) {
            this._$1413(data);
        } else {
            this._$1432(data);
        }
        return this.grade;
    }

    public void setChanged() {
        this.changed = true;
    }

    public void writeToAsn(DataOutputStream writer) throws IOException {
        writer.writeByte(this.gradeStyle);
        writer.writeByte(this.deductPerDayPastDue);
        writer.writeByte(this.meritPassScore);
        writer.writeByte(this.meritPassPoints);
        writer.writeByte(this.demeritPerDayPastDue);
        writer.writeBoolean(this.canTurnInPastDue);
        writer.writeBoolean(this.useCustomTolerances);
        writer.writeByte(this.toleranceType);
        writer.writeShort(this.absPitch);
        writer.writeShort(this.absAttack);
        writer.writeShort(this.absRelease);
        writer.writeShort(this.relPitch);
        writer.writeShort(this.relAttack);
        writer.writeShort(this.relRelease);
    }
}

