/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

public class IPasLibrarianTask {
    public static int CHECK_FILE_EXIST;
    public static int COPY_LOCAL;
    public static int DELETE_EXPIRED_ATTACHMENTS_FROM_SERVER;
    public static int DELETE_FROM_SERVER;
    public static int DOWNLOAD;
    public static int DOWNLOAD_ACCOUNT_PREFS;
    public static int DOWNLOAD_ALL_LOGS;
    public static int DOWNLOAD_CUSTOM_LESSONS;
    public static int DOWNLOAD_DIRECTION;
    public static int DOWNLOAD_STUDENT_ANNOUNCEMENTS;
    public static int DOWNLOAD_STUDENT_ASSIGNMENT;
    public static int DOWNLOAD_STUDENT_ROSTER;
    public static int DOWNLOAD_SYSTEM_PREFS;
    public static int DO_NOTHING;
    public static int ONLINE_NOT_NEWER;
    public static int ONLINE_WAS_NEWER;
    public static int OPEN_ACCOUNT;
    public static int OPEN_HEADQUARTERS;
    public static int PAUSE;
    public static int RENAME_LOCAL;
    public static int UPLOAD;
    public static int UPLOAD_DIRECTION;
    String altPath = null;
    boolean canOverwrite = true;
    String completionCode = null;
    int completionRepeat = 0;
    long id;
    boolean ifNewer = true;
    boolean leaveOnSource = true;
    String localPath = null;
    String message = null;
    boolean mustExist = true;
    String remoteFile = null;
    String remotePath = null;
    int taskResult = 0;
    int taskStage = 0;
    int taskType = DO_NOTHING;
    int transferDirection = 0;

    static {
        DO_NOTHING = 0;
        OPEN_HEADQUARTERS = 1;
        OPEN_ACCOUNT = 2;
        UPLOAD = 3;
        DOWNLOAD = 4;
        RENAME_LOCAL = 5;
        COPY_LOCAL = 6;
        DOWNLOAD_STUDENT_ASSIGNMENT = 7;
        DOWNLOAD_STUDENT_ROSTER = 8;
        DOWNLOAD_ALL_LOGS = 9;
        DOWNLOAD_STUDENT_ANNOUNCEMENTS = 10;
        DOWNLOAD_SYSTEM_PREFS = 11;
        DOWNLOAD_ACCOUNT_PREFS = 12;
        DOWNLOAD_CUSTOM_LESSONS = 13;
        DELETE_FROM_SERVER = 14;
        DELETE_EXPIRED_ATTACHMENTS_FROM_SERVER = 15;
        CHECK_FILE_EXIST = 16;
        PAUSE = 17;
        ONLINE_WAS_NEWER = 1;
        ONLINE_NOT_NEWER = 2;
        DOWNLOAD_DIRECTION = 1;
        UPLOAD_DIRECTION = 2;
    }

    public IPasLibrarianTask(int taskType, String message) {
        this();
        this.taskType = taskType;
        this.message = message;
    }

    public IPasLibrarianTask() {
        this.id = System.currentTimeMillis();
        this.id = this.hashCode();
    }

    public boolean checkCompletion(String msg) {
        if (this.completionCode == null) {
            return false;
        }
        if (msg.startsWith(this.completionCode)) {
            --this.completionRepeat;
            return this.completionRepeat <= 0;
        }
        return false;
    }

    public static IPasLibrarianTask createCheckFileExists(boolean checkOnline, boolean mustExist, String fileName, String message) {
        IPasLibrarianTask task = new IPasLibrarianTask(CHECK_FILE_EXIST, null);
        if (checkOnline) {
            task.remoteFile = IPasLibrarianTask._$10451(fileName);
        } else {
            task.localPath = IPasLibrarianTask._$10451(fileName);
        }
        task.message = "Checking for existing file: " + fileName;
        task.altPath = message;
        task.mustExist = mustExist;
        return task;
    }

    public static IPasLibrarianTask createDeleteExpiredAttachmentsFromServer() {
        IPasLibrarianTask task = new IPasLibrarianTask(DELETE_EXPIRED_ATTACHMENTS_FROM_SERVER, null);
        task.message = "Checking account for expired recordings and graphs.";
        task.mustExist = false;
        task.completionCode = "250";
        task.completionRepeat = 1;
        return task;
    }

    public static IPasLibrarianTask createDeleteFromServer(String remoteFile, boolean mustExist, String message) {
        IPasLibrarianTask item = new IPasLibrarianTask(DELETE_FROM_SERVER, message);
        item.remoteFile = IPasLibrarianTask._$10451(remoteFile);
        item.mustExist = mustExist;
        return item;
    }

    public static IPasLibrarianTask createDownloadAccountPrefsTask(String localPath) {
        IPasLibrarianTask task = IPasLibrarianTask.createDownloadTask("prefs.txt", localPath + "temp/", true, "Downloading account settings.");
        task.taskType = DOWNLOAD_ACCOUNT_PREFS;
        return task;
    }

    public static IPasLibrarianTask createDownloadAllLogsTask() {
        IPasLibrarianTask task = new IPasLibrarianTask(DOWNLOAD_ALL_LOGS, "Downloading student results.");
        task.transferDirection = 0;
        return task;
    }

    public static IPasLibrarianTask createDownloadAnnouncementsTask(String localPath, String studentID, String password) {
        IPasLibrarianTask item = IPasLibrarianTask.createDownloadTask(null, localPath, true, "Downloading class announcements.");
        item.taskType = DOWNLOAD_STUDENT_ANNOUNCEMENTS;
        item.altPath = IPasLibrarianTask._$10450(studentID, password);
        item.mustExist = false;
        return item;
    }

    public static IPasLibrarianTask createDownloadAssignmentTask(String localPath, String studentID, String password) {
        IPasLibrarianTask task = IPasLibrarianTask.createDownloadTask(null, localPath, true, "Downloading student assignments.");
        task.taskType = DOWNLOAD_STUDENT_ASSIGNMENT;
        task.altPath = IPasLibrarianTask._$10450(studentID, password);
        return task;
    }

    public static IPasLibrarianTask createDownloadCustomLessonsTask(String localPath) {
        IPasLibrarianTask task = IPasLibrarianTask.createDownloadTask("lessons.pkg", localPath, true, "Downloading custom lessons.");
        task.taskType = DOWNLOAD_CUSTOM_LESSONS;
        task.mustExist = false;
        return task;
    }

    public static IPasLibrarianTask createDownloadRosterTask(String localPath) {
        IPasLibrarianTask item = IPasLibrarianTask.createDownloadTask("students.lst", localPath, true, "Downloading student roster.");
        item.taskType = DOWNLOAD_STUDENT_ROSTER;
        return item;
    }

    public static IPasLibrarianTask createDownloadSystemPrefsTask(String localPath) {
        IPasLibrarianTask task = IPasLibrarianTask.createDownloadTask("system.prefs.txt", localPath + "temp/", true, "Downloading system settings.");
        task.taskType = DOWNLOAD_SYSTEM_PREFS;
        return task;
    }

    public static IPasLibrarianTask createDownloadTask(String remoteFile, String localPath, boolean ifNewer, String message) {
        if (remoteFile != null && localPath.endsWith("/") | localPath.endsWith("\\")) {
            localPath = localPath + remoteFile;
        }
        IPasLibrarianTask task = new IPasLibrarianTask(DOWNLOAD, message);
        task.localPath = IPasLibrarianTask._$10451(localPath);
        task.remoteFile = IPasLibrarianTask._$10451(remoteFile);
        task.ifNewer = ifNewer;
        task.transferDirection = DOWNLOAD_DIRECTION;
        task.completionCode = "226";
        task.completionRepeat = 1;
        return task;
    }

    public static IPasLibrarianTask createLocalCopyTask(String localPath, String destPath, String message) {
        IPasLibrarianTask task = new IPasLibrarianTask(COPY_LOCAL, message);
        task.localPath = IPasLibrarianTask._$10451(localPath);
        task.altPath = IPasLibrarianTask._$10451(destPath);
        return task;
    }

    public static IPasLibrarianTask createLocalRenameTask(String localPath, String newName, String message) {
        IPasLibrarianTask task = new IPasLibrarianTask(RENAME_LOCAL, message);
        task.localPath = IPasLibrarianTask._$10451(localPath);
        task.altPath = IPasLibrarianTask._$10451(newName);
        return task;
    }

    public static IPasLibrarianTask createOpenAccountTask(String account, boolean readDirectory, String message) {
        IPasLibrarianTask task = new IPasLibrarianTask(OPEN_ACCOUNT, message);
        task.remotePath = IPasLibrarianTask._$10451(account);
        if (readDirectory) {
            task.completionCode = "200";
            task.completionRepeat = 2;
        } else {
            task.completionCode = "250";
            task.completionRepeat = 1;
        }
        task.mustExist = readDirectory;
        return task;
    }

    public static IPasLibrarianTask createOpenAccountTask(String message) {
        return IPasLibrarianTask.createOpenAccountTask(null, true, message);
    }

    public static IPasLibrarianTask createOpenHeadquarters(boolean readDirectory) {
        IPasLibrarianTask task = IPasLibrarianTask.createOpenAccountTask("headquarters", readDirectory, "Accessing Pygraphics Headquarters.");
        task.taskType = OPEN_HEADQUARTERS;
        return task;
    }

    public static IPasLibrarianTask createOpenRootDirectory(String message) {
        return IPasLibrarianTask.createOpenAccountTask("<root>", false, message);
    }

    public static IPasLibrarianTask createPauseTask(String message) {
        return new IPasLibrarianTask(PAUSE, message);
    }

    public static IPasLibrarianTask createUploadTask(String localPath, String remoteFile, boolean leaveOnSource, boolean canOverwriteExisting, String message) {
        IPasLibrarianTask task = new IPasLibrarianTask(UPLOAD, message);
        task.localPath = IPasLibrarianTask._$10451(localPath);
        task.remoteFile = IPasLibrarianTask._$10451(remoteFile);
        task.leaveOnSource = leaveOnSource;
        task.canOverwrite = canOverwriteExisting;
        task.transferDirection = UPLOAD_DIRECTION;
        task.completionCode = "250";
        task.completionRepeat = 1;
        return task;
    }

    public int getTaskResult() {
        return this.taskResult;
    }

    public int getTaskType() {
        return this.taskType;
    }

    public boolean isType(int taskType) {
        return taskType == this.taskType;
    }

    private static String _$10450(String studentID, String password) {
        if (password == null) {
            return studentID;
        }
        if (password.length() == 0) {
            return studentID;
        }
        return studentID + '.' + password;
    }

    private static String _$10451(String str) {
        if (str == null) {
            return null;
        }
        return str.trim().toLowerCase();
    }
}

