/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.Date;
import pyware.iPasToolkit.interactive.AssignmentItem;
import pyware.iPasToolkit.interactive.ClassModifier;
import pyware.iPasToolkit.interactive.EvaluationDatFile;
import pyware.iPasToolkit.interactive.GradeDetailInfo;
import pyware.iPasToolkit.interactive.GradeSummaryInfo;
import pyware.iPasToolkit.interactive.GradingScheme;
import pyware.iPasToolkit.interactive.LessonList;
import pyware.iPasToolkit.interactive.StudentModifier;
import pyware.toolkit.Utils;

public class IPasStudentTableRow {
    public static int GRADE_LOCKED;
    public static int GRADE_NOT_LOCKED;
    public static int METHOD_SOE;
    public static int METHOD_STANDARD;
    public static long MILLIS_PER_DAY;
    ClassModifier classModifier;
    String description = "";
    GradeDetailInfo gradeDetail;
    GradeSummaryInfo gradeSummary = new GradeSummaryInfo();
    long instrumentID = 0L;
    long lessonID = 0L;
    boolean setByEvaluation = false;
    StudentModifier studentModifier;

    static {
        MILLIS_PER_DAY = 86400000L;
        METHOD_STANDARD = 1;
        METHOD_SOE = 2;
        GRADE_NOT_LOCKED = 0;
        GRADE_LOCKED = 1;
    }

    public IPasStudentTableRow(AssignmentItem descriptorItem) {
        this.gradeDetail = new GradeDetailInfo();
        this.classModifier = new ClassModifier();
        this.studentModifier = new StudentModifier();
        this.lessonID = descriptorItem.lessonID;
        this.classModifier.setValues(descriptorItem);
    }

    public IPasStudentTableRow(byte[] data, int offset) {
        this.gradeDetail = new GradeDetailInfo();
        this.classModifier = new ClassModifier();
        this.studentModifier = new StudentModifier();
        this._$1412(data, offset);
    }

    public IPasStudentTableRow(IPasStudentTableRow item) {
        this(item.lessonID);
        this.gradeSummary.setValues(item.gradeSummary);
        this.gradeDetail.setValues(item.gradeDetail);
        this.studentModifier.setValues(item.studentModifier);
        this.classModifier.setValue(item.classModifier);
        this.description = item.description;
    }

    public IPasStudentTableRow(long lessonID) {
        this.gradeDetail = new GradeDetailInfo();
        this.classModifier = new ClassModifier();
        this.studentModifier = new StudentModifier();
        this.lessonID = lessonID;
    }

    public boolean canAttachGraph() {
        return this.classModifier.graph;
    }

    public boolean canAttachRecording() {
        return this.classModifier.record;
    }

    public static IPasStudentTableRow createFromLogFile(DataInputStream is) throws Exception {
        long lessonID = is.readLong();
        if (lessonID == 0L) {
            return null;
        }
        IPasStudentTableRow item = new IPasStudentTableRow(lessonID);
        item.gradeSummary = new GradeSummaryInfo(is);
        item.gradeDetail = new GradeDetailInfo(is);
        return item;
    }

    private void _$1412(byte[] data, int offset) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        byteBuffer.position(offset);
        this.lessonID = byteBuffer.getLong();
        this.gradeSummary.completionDateTime = byteBuffer.getLong();
        this.gradeSummary.grade = byteBuffer.get();
        this.gradeDetail.gradeMethod = byteBuffer.get();
        this.studentModifier.gradeLock = byteBuffer.get();
        this.studentModifier.extension = byteBuffer.get();
        this.gradeDetail.subGrade1 = byteBuffer.get();
        this.gradeDetail.subGrade2 = byteBuffer.get();
        this.gradeDetail.subGrade3 = byteBuffer.get();
        this.gradeDetail.subGrade4 = byteBuffer.get();
        this.gradeDetail.tempoFactor = byteBuffer.get();
        this.gradeDetail.timer = byteBuffer.get();
        this.gradeDetail.attachmentID = byteBuffer.getLong();
    }

    public long getAssignedDate() {
        return this.classModifier.assignedDate;
    }

    public String getAssignedDateStr() {
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        return dateFormat.format(new Date(this.getAssignedDate()));
    }

    public long getAttachmentID() {
        return this.gradeDetail.attachmentID;
    }

    public long getCompletionDate() {
        return Utils.truncateDate(this.getCompletionDateTime());
    }

    public long getCompletionDateTime() {
        return this.gradeSummary.completionDateTime;
    }

    public String getDescription() {
        return this.description;
    }

    public long getDueDate() {
        return this.classModifier.dueDate;
    }

    public long getExtendedDueDate() {
        return this.getDueDate() + (long)this.getExtension() * MILLIS_PER_DAY;
    }

    public int getExtension() {
        return this.studentModifier.extension;
    }

    public int getGrade() {
        return this.gradeSummary.grade;
    }

    public String getInstrument() {
        return this.gradeDetail.instrument;
    }

    public long getLessonID() {
        return this.lessonID;
    }

    public int getOverdueDeduction(GradingScheme gradingScheme) {
        return gradingScheme.calcOverdueDeduction(this.getExtendedDueDate(), this.getCompletionDate(), this.getGrade());
    }

    public String getSubGradeInfo(int index) {
        return this.gradeDetail.getSubGradeStr(index);
    }

    public int getTempoFactor() {
        return this.gradeDetail.tempoFactor;
    }

    public int getTimer() {
        return this.gradeDetail.timer;
    }

    public boolean hasFutureAssignmentDate() {
        return this.getAssignedDate() > Utils.truncateDate(System.currentTimeMillis());
    }

    public boolean isCompleted() {
        return this.gradeSummary.isCompleted();
    }

    public boolean isCompletedPastDue() {
        if (!this.isCompleted()) {
            return false;
        }
        return this.getCompletionDate() > this.getExtendedDueDate();
    }

    public boolean isEmpty() {
        return !this.gradeSummary.isCompleted() && !this.studentModifier.isLocked() && this.studentModifier.extension == 0;
    }

    public boolean isExtended() {
        return this.getExtension() > 0;
    }

    public boolean isLocked() {
        return this.studentModifier.isLocked();
    }

    public boolean isOverdue() {
        return Utils.truncateDate(System.currentTimeMillis()) > this.getExtendedDueDate();
    }

    public boolean isRedoable() {
        return this.classModifier.redoable;
    }

    public boolean isSetByEvaluation() {
        return this.setByEvaluation;
    }

    public String makePngAttachmentName(String studentID) {
        long attachmentID = this.gradeDetail.attachmentID;
        if (attachmentID == 0L | this.classModifier.redoable | !this.classModifier.graph) {
            return null;
        }
        return Long.toHexString(attachmentID) + '.' + studentID + ".png";
    }

    public String makeWavAttachmentName(String studentID) {
        long attachmentID = this.gradeDetail.attachmentID;
        if (attachmentID == 0L | this.classModifier.redoable | !this.classModifier.record) {
            return null;
        }
        return Long.toHexString(attachmentID) + '.' + studentID + ".wav";
    }

    public void mergeBackupLogItem(IPasStudentTableRow backItem) {
        if (backItem == null) {
            return;
        }
        if (this.isLocked()) {
            return;
        }
        if (!backItem.isCompleted()) {
            return;
        }
        if (backItem.getCompletionDate() < this.getAssignedDate()) {
            return;
        }
        if (!this.isCompleted()) {
            this.gradeSummary.setValues(backItem.gradeSummary);
        }
        if (this.getCompletionDateTime() == backItem.getCompletionDateTime() && !this.gradeDetail.hasDetail()) {
            this.gradeDetail.setValues(backItem.gradeDetail);
        }
        if (this.isRedoable()) {
            this.gradeDetail.attachmentID = 0L;
        }
    }

    public static IPasStudentTableRow readFromAsnFile(DataInputStream is) throws IOException {
        long lessonID = is.readLong();
        if (lessonID == 0L) {
            return null;
        }
        IPasStudentTableRow item = new IPasStudentTableRow(lessonID);
        item.gradeSummary = new GradeSummaryInfo(is);
        item.studentModifier = new StudentModifier(is);
        return item;
    }

    public static int rowByteSize() {
        return 34;
    }

    public void setDescription(LessonList lessonList) {
        this.description = lessonList.findDescription(this.lessonID);
    }

    public int setTimer(int timer) {
        this.gradeDetail.timer = new Integer(timer).byteValue();
        return this.gradeDetail.timer;
    }

    public void setValues(EvaluationDatFile evaluation) {
        this.lessonID = evaluation.lessonID;
        this.instrumentID = evaluation.instrumentID;
        this.gradeSummary.setValues(evaluation);
        this.gradeDetail.setValues(evaluation);
        this.setByEvaluation = true;
    }

    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(IPasStudentTableRow.rowByteSize());
        byteBuffer.putLong(this.lessonID);
        byteBuffer.putLong(this.gradeSummary.completionDateTime);
        byteBuffer.put(this.gradeSummary.grade);
        byteBuffer.put(this.gradeDetail.gradeMethod);
        byteBuffer.put(this.studentModifier.gradeLock);
        byteBuffer.put(this.studentModifier.extension);
        byteBuffer.put(this.gradeDetail.subGrade1);
        byteBuffer.put(this.gradeDetail.subGrade2);
        byteBuffer.put(this.gradeDetail.subGrade3);
        byteBuffer.put(this.gradeDetail.subGrade4);
        byteBuffer.put(this.gradeDetail.tempoFactor);
        byteBuffer.put(this.gradeDetail.timer);
        byteBuffer.putLong(this.gradeDetail.attachmentID);
        return byteBuffer.array();
    }

    public String toString(GradingScheme gradingScheme) {
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        int deduction = this.getOverdueDeduction(gradingScheme);
        if (deduction == 0) {
            return this.toString();
        }
        int aGrade = Math.max(this.getGrade() - deduction, 0);
        return this.getDescription() + " Due:" + dateFormat.format(new Date(this.getDueDate())) + " Done:" + dateFormat.format(new Date(this.getCompletionDate())) + " Overdue Deduction:" + deduction + " Grade:(" + this.getGrade() + "-" + deduction + ") " + aGrade;
    }

    public String toString() {
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        return this.getDescription() + " Due:" + dateFormat.format(new Date(this.getDueDate())) + " Done:" + dateFormat.format(new Date(this.getCompletionDate())) + " Grade:" + this.getGrade();
    }

    public void writeToAsnFile(DataOutputStream os) throws IOException {
        os.writeLong(this.lessonID);
        this.gradeSummary.write(os);
        this.studentModifier.write(os);
    }

    public void writeToLogFile(DataOutputStream os) throws Exception {
        os.writeLong(this.lessonID);
        this.gradeSummary.write(os);
        this.gradeDetail.write(os);
    }
}

