/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import pyware.iPasToolkit.interactive.AssignmentFile;
import pyware.iPasToolkit.interactive.IPasStudentTableRow;
import pyware.iPasToolkit.interactive.LessonListItem;
import pyware.iPasToolkit.interactive.StudentRoster;
import pyware.iPasToolkit.interactive.StudentRosterItem;
import pyware.toolkit.FileUtils;

public class LessonList {
    String[] lessonPaths;
    Vector list = new Vector();
    String localPath = null;

    public LessonList(String[] pathToLessons, String localPath) {
        this.initialize(pathToLessons, localPath);
    }

    public LessonList() {
        this.initialize(null, null);
    }

    private void _$7807(LessonListItem item) {
        if (this.findLesson(item.getID()) == null) {
            this.list.add(item);
        }
    }

    private void _$10325(String iPasPath) {
        String[] seriesNames = FileUtils.getFileList(iPasPath + "lessons/");
        if (seriesNames.length == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < seriesNames.length) {
            String path = iPasPath + "lessons/" + seriesNames[i2] + "/";
            this._$10338(seriesNames[i2], path);
            path = iPasPath + "lessons/" + seriesNames[i2] + "/Scripts/";
            this._$10338(seriesNames[i2], path);
            ++i2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void buildTop10(StudentRoster students, String fileName) {
        this._$6821(0L);
        try {
            DataInputStream is = new DataInputStream(new FileInputStream(fileName));
            AssignmentFile asn = new AssignmentFile(is);
            int totalStudents = is.readShort();
            int i2 = 0;
            while (i2 < totalStudents) {
                IPasStudentTableRow studentLesson;
                String aStudentID = LessonList._$7810(is);
                while ((studentLesson = IPasStudentTableRow.readFromAsnFile(is)) != null) {
                    StudentRosterItem studentInfo;
                    void var8_9;
                    if (!var8_9.isCompleted() || (studentInfo = students.findStudent(aStudentID)) == null) continue;
                    this._$6824(var8_9.lessonID, studentInfo.getFullName(), var8_9.getGrade());
                }
                ++i2;
            }
            this.saveTop10(asn.getCreationDate());
        }
        catch (Exception ex2) {
            System.out.println("Unable to load top 10 lists from assignment file.");
        }
    }

    public String findDescription(long id) {
        LessonListItem item = this.findLesson(id);
        if (item == null) {
            return "<lesson not found>";
        }
        return item.lessonDesc;
    }

    public String findFullDescription(long id) {
        LessonListItem item = this.findLesson(id);
        if (item == null) {
            return "";
        }
        return "[" + item.series + "]     Lesson:  " + item.lessonDesc;
    }

    public LessonListItem findLesson(long id) {
        int len = this.list.size();
        int i2 = 0;
        while (i2 < len) {
            if (this.itemAt(i2).getID() == id) {
                return this.itemAt(i2);
            }
            ++i2;
        }
        return null;
    }

    public void initialize(String[] pathToLessons, String localPath) {
        this.localPath = localPath;
        this.lessonPaths = pathToLessons;
        this.reload();
    }

    public LessonListItem itemAt(int index) {
        return (LessonListItem)this.list.elementAt(index);
    }

    private void _$10338(String seriesName, String seriesPath) {
        String[] scriptNames = FileUtils.getFileList(seriesPath);
        if (scriptNames == null) {
            return;
        }
        if (seriesName.toLowerCase().endsWith(".lsn")) {
            seriesName = "Custom Lessons";
        }
        int j2 = 0;
        while (j2 < scriptNames.length) {
            if (scriptNames[j2].endsWith(".scp")) {
                try {
                    this._$7807(this._$10337(seriesName, seriesPath + scriptNames[j2]));
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            ++j2;
        }
    }

    public void loadTop10() {
        if (this.localPath == null) {
            return;
        }
        String fileName = this.localPath + "top10.dat";
        try {
            DataInputStream is = new DataInputStream(new FileInputStream(fileName));
            long creationDate = is.readLong();
            this._$6821(creationDate);
            int len = is.readShort();
            int i2 = 0;
            while (i2 < len) {
                LessonListItem lesson = this.findLesson(is.readLong());
                int topLen = is.readByte();
                int j2 = 0;
                while (j2 < topLen) {
                    String name = is.readUTF();
                    byte grade = is.readByte();
                    if (lesson != null) {
                        lesson.updateTop10(name, grade);
                    }
                    ++j2;
                }
                ++i2;
            }
        }
        catch (Exception ex2) {
        }
    }

    private LessonListItem _$10327(String scriptLine) {
        int slashIndex;
        LessonListItem scriptLineInfo = new LessonListItem();
        String line = this._$10333(scriptLine);
        int colonIndex = line.indexOf(58);
        int equalIndex = line.indexOf(61);
        if ((colonIndex != -1 && colonIndex < equalIndex) | (colonIndex != -1 && equalIndex == -1)) {
            String label = line.substring(0, colonIndex);
            line = line.substring(colonIndex + 1).trim();
        }
        if ((equalIndex = line.indexOf(61)) == -1 | equalIndex > (slashIndex = line.indexOf(47))) {
            equalIndex = slashIndex;
        }
        String command = line.substring(0, equalIndex);
        scriptLineInfo.lessonDesc = "";
        if (equalIndex < slashIndex - 1) {
            scriptLineInfo.lessonDesc = line.substring(equalIndex + 1, slashIndex);
        }
        if ((line = line.substring(slashIndex + 1).trim()).length() > 0) {
            do {
                if ((equalIndex = line.indexOf(61)) == -1 | equalIndex > (slashIndex = line.indexOf(47))) {
                    equalIndex = slashIndex;
                }
                String aPName = line.substring(0, equalIndex);
                String aPValue = null;
                if (equalIndex < slashIndex) {
                    aPValue = line.substring(equalIndex + 1, slashIndex);
                }
                if (aPName.compareToIgnoreCase("ID") == 0) {
                    scriptLineInfo.setID(aPValue);
                }
                line = line.substring(slashIndex + 1).trim();
            } while (line.length() > 0);
        }
        return scriptLineInfo;
    }

    private LessonListItem _$10337(String series, String filePath) throws Exception {
        InputStream stream = null;
        try {
            URL url = new URL("file:" + filePath);
            stream = url.openStream();
        }
        catch (Exception ex1) {
            throw new Exception();
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String str = reader.readLine();
            LessonListItem info = this._$10327(str);
            info.filePath = filePath;
            info.series = series;
            stream.close();
            return info;
        }
        catch (Exception ex2) {
            stream.close();
            throw new Exception();
        }
    }

    private static String _$7810(DataInputStream is) throws Exception {
        byte[] array = new byte[is.readByte()];
        is.read(array);
        return new String(array).trim();
    }

    public void reload() {
        this.list.removeAllElements();
        if (this.lessonPaths == null) {
            this._$10325("");
        } else if (this.lessonPaths.length == 0) {
            this._$10325("");
        } else {
            int i2 = 0;
            while (i2 < this.lessonPaths.length) {
                this._$10325(this.lessonPaths[i2]);
                ++i2;
            }
        }
        this.loadTop10();
    }

    private void _$6821(long creationDate) {
        int i2 = 0;
        while (i2 < this.list.size()) {
            this.itemAt(i2).resetTop10(creationDate);
            ++i2;
        }
    }

    private String _$10333(String line) {
        if (!(line = line.trim()).endsWith("/")) {
            line = line + '/';
        }
        return line;
    }

    public void saveTop10(long creationDate) {
        String fileName = this.localPath + "top10.dat";
        try {
            DataOutputStream os = new DataOutputStream(new FileOutputStream(fileName));
            os.writeLong(creationDate);
            os.writeShort(this.list.size());
            int i2 = 0;
            while (i2 < this.list.size()) {
                this.itemAt(i2).writeTop10(os);
                ++i2;
            }
        }
        catch (Exception ex2) {
        }
    }

    public int size() {
        return this.list.size();
    }

    private void _$6824(long lessonID, String studentName, int grade) {
        LessonListItem lesson = this.findLesson(lessonID);
        if (lesson != null) {
            lesson.updateTop10(studentName, grade);
        }
    }
}

