/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;
import pyware.iPasToolkit.interactive.StudentRosterItem;

public class StudentRoster {
    public static int STUDENT_ROSTER_VERSION = 1;
    Vector list = new Vector();

    public StudentRoster(String fileName) throws Exception {
        this.load(fileName);
    }

    public StudentRoster() {
    }

    public void addStudent(String firstName, String lastName, String studentID, String password, long dbID) {
        this.addStudent(new StudentRosterItem(firstName, lastName, studentID, password, dbID));
    }

    public void addStudent(StudentRosterItem item) {
        this.list.add(item);
    }

    public StudentRosterItem[] findDuplicates() {
        Vector<StudentRosterItem> dups = new Vector<StudentRosterItem>();
        int i2 = 0;
        while (i2 < this.list.size()) {
            StudentRosterItem student1 = this.studentAt(i2);
            int j2 = i2 + 1;
            while (j2 < this.list.size()) {
                StudentRosterItem student2 = this.studentAt(j2);
                if (student1.sameIDas(student2)) {
                    dups.addElement(student1);
                    dups.addElement(student2);
                    j2 = this.list.size();
                }
                ++j2;
            }
            ++i2;
        }
        StudentRosterItem[] rslt = new StudentRosterItem[dups.size()];
        int i3 = 0;
        while (i3 < rslt.length) {
            rslt[i3] = (StudentRosterItem)dups.elementAt(i3);
            ++i3;
        }
        return rslt;
    }

    public StudentRosterItem findStudent(String iPasStudentID) {
        int len = this.list.size();
        int i2 = 0;
        while (i2 < len) {
            if (iPasStudentID.compareToIgnoreCase(this.studentAt((int)i2).iPasID) == 0) {
                return this.studentAt(i2);
            }
            ++i2;
        }
        return null;
    }

    public long getDataBaseID(String iPasStudentID) {
        try {
            return this.findStudent((String)iPasStudentID).dbID;
        }
        catch (Exception e2) {
            return 0L;
        }
    }

    public int getStudentCount() {
        return this.list.size();
    }

    public void load(String fileName) throws Exception {
        this.list.removeAllElements();
        DataInputStream is = new DataInputStream(new FileInputStream(fileName));
        short version = is.readShort();
        if (version > STUDENT_ROSTER_VERSION) {
            throw new Exception("Incompatible version of downloaded student roster file.");
        }
        int len = is.readShort();
        long dbID = -1L;
        int i2 = 0;
        while (i2 < len) {
            StudentRosterItem info = new StudentRosterItem();
            info.iPasID = StudentRoster._$7810(is);
            if (info.iPasID.equalsIgnoreCase("~")) {
                dbID = is.readLong();
                info.iPasID = StudentRoster._$7810(is);
            }
            info.dbID = dbID;
            info.firstName = StudentRoster._$7810(is);
            info.lastName = StudentRoster._$7810(is);
            info.password = StudentRoster._$7810(is);
            this.list.add(info);
            ++i2;
        }
        is.close();
    }

    private static String _$7810(DataInputStream is) throws Exception {
        int len = is.readByte();
        StringBuffer strBuf = new StringBuffer();
        int i2 = 0;
        while (i2 < len) {
            strBuf.append((char)is.readByte());
            ++i2;
        }
        return strBuf.toString();
    }

    public void removeAll() {
        this.list.removeAllElements();
    }

    public void save(String fileName) throws Exception {
        DataOutputStream os = new DataOutputStream(new FileOutputStream(fileName));
        os.writeShort(STUDENT_ROSTER_VERSION);
        int len = this.list.size();
        long lastDbID = -1L;
        os.writeShort(len);
        int i2 = 0;
        while (i2 < len) {
            StudentRosterItem student = this.studentAt(i2);
            long dbID = student.dbID;
            if (dbID != lastDbID) {
                this._$10356("~", os);
                os.writeLong(dbID);
                lastDbID = dbID;
            }
            this._$10356(student.iPasID, os);
            this._$10356(student.firstName, os);
            this._$10356(student.lastName, os);
            this._$10356(student.password, os);
            ++i2;
        }
        os.close();
    }

    public void sortByDBID() {
        int len = this.getStudentCount();
        int a10 = 0;
        while (a10 < len) {
            int b2 = a10 + 1;
            while (b2 < len) {
                String s2;
                String s1 = this.studentAt((int)a10).dbID + this.studentAt(a10).getFullNameLastFirst();
                if (s1.compareToIgnoreCase(s2 = this.studentAt((int)b2).dbID + this.studentAt(b2).getFullNameLastFirst()) > 0) {
                    Object objA = this.list.elementAt(a10);
                    Object objB = this.list.elementAt(b2);
                    this.list.setElementAt(objA, b2);
                    this.list.setElementAt(objB, a10);
                }
                ++b2;
            }
            ++a10;
        }
    }

    public void sortByName() {
        int len = this.getStudentCount();
        int a10 = 0;
        while (a10 < len) {
            int b2 = a10 + 1;
            while (b2 < len) {
                String s2;
                String s1 = this.studentAt(a10).getFullNameLastFirst();
                if (s1.compareToIgnoreCase(s2 = this.studentAt(b2).getFullNameLastFirst()) > 0) {
                    Object objA = this.list.elementAt(a10);
                    Object objB = this.list.elementAt(b2);
                    this.list.setElementAt(objA, b2);
                    this.list.setElementAt(objB, a10);
                }
                ++b2;
            }
            ++a10;
        }
    }

    public StudentRosterItem studentAt(int index) {
        return (StudentRosterItem)this.list.elementAt(index);
    }

    private void _$10356(String str, DataOutputStream os) throws Exception {
        os.write((byte)str.length());
        os.write(str.getBytes());
    }
}

