/*
 * Decompiled with CFR 0.152.
 */
package pyware.toolkit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FileUtils {
    public static String[] getFileList(String path) {
        File f2 = new File(FileUtils.appendFileName(path, "."));
        if (f2.list() == null) {
            return new String[0];
        }
        return f2.list();
    }

    public static String appendFileName(String path, String fileName) {
        if (path.endsWith(File.separator)) {
            return path + fileName;
        }
        return path + File.separator + fileName;
    }

    public static boolean hasSuffix(String path, String sfx) {
        if (path == null) {
            return false;
        }
        if (sfx == null) {
            return false;
        }
        if (!sfx.startsWith(".")) {
            sfx = "." + sfx;
        }
        return path.toLowerCase().endsWith(sfx.toLowerCase());
    }

    public static String appendSuffix(String path, String sfx) {
        if (path == null) {
            return null;
        }
        if (sfx == null) {
            return path;
        }
        if (!sfx.startsWith(".")) {
            sfx = "." + sfx;
        }
        if (!path.toLowerCase().endsWith(sfx.toLowerCase())) {
            return path + sfx;
        }
        return path;
    }

    private String _$560(String path) {
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public static String replaceSuffix(String path, String sfx) {
        int len;
        if (path == null) {
            return null;
        }
        if (sfx == null) {
            return path;
        }
        int pos = -1;
        for (int i2 = len = path.length() - 1; i2 >= 0; --i2) {
            if (pos != -1 || path.charAt(i2) != '.') continue;
            pos = i2;
        }
        path = path.substring(0, pos);
        if (!sfx.startsWith(".")) {
            sfx = "." + sfx;
        }
        if (!path.toLowerCase().endsWith(sfx.toLowerCase())) {
            return path + sfx;
        }
        return path;
    }

    public static String removeSuffix(String path, String sfx) {
        if (path == null) {
            return null;
        }
        if (sfx == null) {
            return path;
        }
        if (!sfx.startsWith(".")) {
            sfx = "." + sfx;
        }
        if (path.toLowerCase().endsWith(sfx.toLowerCase())) {
            return path.substring(0, path.length() - sfx.length());
        }
        return path;
    }

    public static String removeSuffix(String path) {
        int len;
        int pos = -1;
        for (int i2 = len = path.length() - 1; i2 >= 0; --i2) {
            if (pos != -1 || path.charAt(i2) != '.') continue;
            pos = i2;
        }
        if (pos == -1) {
            return path;
        }
        return path.substring(0, pos);
    }

    public static boolean isValid(String path) {
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return false;
        }
        File f2 = new File(path);
        return f2.isFile();
    }

    public static boolean isDir(String path) {
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return false;
        }
        File f2 = new File(path);
        return f2.isDirectory();
    }

    public static String extractFileName(String path) {
        File f2 = new File(path);
        String name = f2.getName();
        int len = name.length() - 1;
        StringBuffer buf = new StringBuffer();
        for (int i2 = len; i2 >= 0; --i2) {
            char ch = name.charAt(i2);
            if (ch == '\\' | ch == '/') {
                return buf.toString();
            }
            buf.insert(0, ch);
        }
        return name;
    }

    public static String extractPath(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        File f2 = new File(path);
        int pos = path.indexOf(f2.getName());
        if (pos <= 0) {
            return path;
        }
        return path.substring(0, pos - 1) + File.separator;
    }

    public static void transferFile(File sourceFile, String destinationPath) {
        if (sourceFile.isHidden()) {
            return;
        }
        if (sourceFile.getName().compareToIgnoreCase(".DS_Store") == 0) {
            return;
        }
        String child = sourceFile.getName();
        File destFile = new File(destinationPath, child);
        if (!destFile.exists()) {
            sourceFile.renameTo(destFile);
        }
    }

    public static void transferDirectory(String directoryPath, String destinationPath) {
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            return;
        }
        File[] fileList = directory.listFiles();
        for (int i2 = 0; i2 < fileList.length; ++i2) {
            File aFile = fileList[i2];
            if (!aFile.isFile()) continue;
            FileUtils.transferFile(aFile, destinationPath);
        }
    }

    public static void eraseFile(String path) {
        File f2 = new File(path);
        f2.delete();
    }

    public static long fileSize(String path) {
        File f2 = new File(path);
        if (FileUtils.isValid(path)) {
            return f2.length();
        }
        return 0L;
    }

    public static String sanatizeFTPDirName(String name) {
        if (name == null) {
            return null;
        }
        char[] validChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        StringBuffer newStr = new StringBuffer();
        name = name.toLowerCase().trim();
        int len = name.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char ch = name.charAt(i2);
            for (int j2 = 0; j2 < validChars.length; ++j2) {
                if (ch != validChars[j2]) continue;
                newStr.append(ch);
            }
        }
        return newStr.toString();
    }

    public static boolean copyFile(String source, String destination) {
        if (source.equalsIgnoreCase(destination)) {
            return true;
        }
        if (new File(source).compareTo(new File(destination)) == 0) {
            return true;
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            in.close();
            out.close();
        }
        catch (Exception ex2) {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static boolean compareFiles(String file1, String file2) {
        FileInputStream in1 = null;
        FileInputStream in2 = null;
        try {
            in1 = new FileInputStream(file1);
            in2 = new FileInputStream(file2);
            byte[] buffer1 = new byte[1024];
            byte[] buffer2 = new byte[1024];
            int len1 = 0;
            while ((len1 = in1.read(buffer1)) != -1) {
                int len2 = in2.read(buffer2);
                if (len1 != len2) {
                    throw new Exception();
                }
                for (int i2 = 0; i2 < len1; ++i2) {
                    if (buffer1[i2] == buffer2[i2]) continue;
                    throw new Exception();
                }
            }
            in1.close();
            in2.close();
        }
        catch (Exception ex2) {
            try {
                if (in1 != null) {
                    in1.close();
                }
                if (in2 != null) {
                    in2.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            return false;
        }
        return true;
    }
}

