/*
 * Decompiled with CFR 0.152.
 */
package pyware.toolkit;

import java.io.File;
import java.util.Vector;
import pyware.toolkit.FindFileEvent;
import pyware.toolkit.FindFileListener;

public class FindFile
implements Runnable {
    File currentSearchDir = null;
    Vector findFileListenerList = new Vector();
    String omitDir = null;
    boolean omitSystemFiles = true;
    File resultFile = null;
    Vector resultFileList = new Vector();
    String[] searchFileNames;
    int searchProgress = 0;
    boolean searchSubDir = true;
    boolean searching = false;
    String startingDirectoryPath = "/";
    boolean stopAfterFirst = true;
    Thread thread = null;

    public synchronized void addFindFileListener(FindFileListener findFileListener) {
        this.findFileListenerList.addElement(findFileListener);
    }

    public void dispatchFindFileCompleted() {
        FindFileEvent e2 = new FindFileEvent();
        if (this.stopAfterFirst) {
            e2.setFileFound(this.resultFile);
        } else {
            e2.setFileList(this.resultFileList);
        }
        if (this.thread == null) {
            e2.setStatus(FindFileEvent.SEARCH_ABORTED);
        }
        int i2 = 0;
        while (i2 < this.findFileListenerList.size()) {
            ((FindFileListener)this.findFileListenerList.elementAt(i2)).findFileCompleted(e2);
            ++i2;
        }
    }

    public void dispatchFound(File file) {
        FindFileEvent e2 = new FindFileEvent(file);
        int i2 = 0;
        while (i2 < this.findFileListenerList.size()) {
            ((FindFileListener)this.findFileListenerList.elementAt(i2)).found(e2);
            ++i2;
        }
    }

    public void dispatchSearching(File directory) {
        FindFileEvent e2 = new FindFileEvent(directory);
        int i2 = 0;
        while (i2 < this.findFileListenerList.size()) {
            ((FindFileListener)this.findFileListenerList.elementAt(i2)).searching(e2);
            ++i2;
        }
    }

    private boolean _$518(File aFile) {
        String aFileName = aFile.getName();
        int i2 = 0;
        while (i2 < this.searchFileNames.length) {
            if (aFileName.compareToIgnoreCase(this.searchFileNames[i2]) == 0) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private File _$523(String directoryPath) {
        if (this.thread == null) {
            return null;
        }
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            return null;
        }
        this.currentSearchDir = directory;
        ++this.searchProgress;
        this.dispatchSearching(this.currentSearchDir);
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < fileList.length) {
            if (this.thread == null) {
                return null;
            }
            File aFile = fileList[i2];
            if (!aFile.isHidden()) {
                if (aFile.isFile()) {
                    if (this._$518(aFile)) {
                        this.dispatchFound(aFile);
                        if (this.stopAfterFirst) {
                            return aFile;
                        }
                        this.resultFileList.add(aFile);
                    }
                } else if (aFile.isDirectory() && this.searchSubDir) {
                    boolean directorySearchable = true;
                    File foundFile = null;
                    String fileName = aFile.getName();
                    if (this.omitSystemFiles) {
                        if (this.isMacintosh() && fileName.compareToIgnoreCase("System Folder") == 0) {
                            directorySearchable = false;
                        }
                        if (this.isMacintosh() && fileName.compareToIgnoreCase("Applications (Mac OS 9)") == 0) {
                            directorySearchable = false;
                        }
                        if (this.isMacintosh() && fileName.compareToIgnoreCase("Network") == 0) {
                            directorySearchable = false;
                        }
                        if (this.isMacintosh() && fileName.compareToIgnoreCase("Private") == 0) {
                            directorySearchable = false;
                        }
                        if (this.isMacintosh() && fileName.compareToIgnoreCase("Library") == 0) {
                            directorySearchable = false;
                        }
                        if (!this.isMacintosh() && fileName.compareToIgnoreCase("Windows") == 0) {
                            aFile = this._$514(aFile);
                        }
                    }
                    if (this.omitDir != null && fileName.compareToIgnoreCase(this.omitDir) == 0) {
                        directorySearchable = false;
                    }
                    if (directorySearchable) {
                        foundFile = this._$523(aFile.getPath());
                    }
                    if (foundFile != null) {
                        return foundFile;
                    }
                }
            }
            ++i2;
        }
        return null;
    }

    private File _$514(File aFile) {
        File desktopDirectory = new File(aFile, "Desktop");
        if (desktopDirectory.exists()) {
            return desktopDirectory;
        }
        return aFile;
    }

    public File getCurrentSearchDir() {
        if (this.isSearching()) {
            return this.currentSearchDir;
        }
        return null;
    }

    public File getResultFile() {
        return this.resultFile;
    }

    public int getSearchProgress() {
        return this.searchProgress;
    }

    public boolean isMacintosh() {
        return System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    }

    public boolean isSearching() {
        return this.searching;
    }

    public synchronized void removeFindFileListener(FindFileListener findFileListener) {
        this.findFileListenerList.removeElement(findFileListener);
    }

    public void run() {
        this.searching = true;
        this.resultFile = this._$523(this.startingDirectoryPath);
        this.searching = false;
        this.dispatchFindFileCompleted();
        this.thread = null;
    }

    public void setOmitDirectory(String omitDir) {
        this.omitDir = omitDir;
    }

    public void setOmitSystemFiles(boolean omitSystemFiles) {
        this.omitSystemFiles = omitSystemFiles;
    }

    public void setStartingDirectory(String directoryPath) {
        this.startingDirectoryPath = directoryPath;
    }

    public void setStopAfterFirstFind(boolean stopAfterFirst) {
        this.stopAfterFirst = stopAfterFirst;
    }

    public void setSubDirSearch(boolean searchSubDir) {
        this.searchSubDir = searchSubDir;
    }

    public void start() {
        if (this.thread != null) {
            this.stop();
        }
        this.thread = new Thread(this);
        this.thread.setName("FindFile");
        this.thread.start();
    }

    public void startSearch(String[] fileNames) {
        this.searchFileNames = fileNames;
        this.searchProgress = 0;
        this.resultFile = null;
        this.resultFileList = new Vector();
        this.start();
    }

    public void startSearch(String fileName) {
        String[] fileNames = new String[]{fileName};
        this.startSearch(fileNames);
    }

    public void stop() {
        this.thread = null;
    }

    public void stopSearch() {
        this.stop();
    }
}

