/*
 * Decompiled with CFR 0.152.
 */
package lessonWiz;

import com.borland.jbcl.layout.BoxLayout2;
import com.borland.jbcl.layout.VerticalFlowLayout;
import ipas.Constants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import jbc.beans.JbcMetallicPushButton;
import lessonWiz.MidiFileFilter;
import lessonWiz.MidiFilePanel_btnFind_actionAdapter;
import lessonWiz.MidiFilePanel_btnPlay_actionAdapter;
import lessonWiz.MidiFilePanel_cbAccompaniment_actionAdapter;
import lessonWiz.MidiFilePanel_cbInstruments_itemAdapter;
import lessonWiz.MidiFilePanel_midiFileNames_listSelectionAdapter;
import lessonWiz.MidiFilePanel_rbUseDifferent_actionAdapter;
import lessonWiz.MidiFilePanel_rbUseSame_actionAdapter;
import lessonWiz.Project;
import lessonWiz.TabbedPanel;
import pyware.iPasToolkit.AmaSequence;
import pyware.iPasToolkit.MidiPlayer;
import pyware.iPasToolkit.MidiPlayerEvent;
import pyware.iPasToolkit.MidiPlayerListener;
import pyware.toolkit.FileUtils;

public class MidiFilePanel
extends TabbedPanel {
    JTextArea header = new JTextArea();
    Border border1;
    Border border2;
    JPanel centerPanel = new JPanel();
    Border border3;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel topPanel = new JPanel();
    Border border4;
    BorderLayout borderLayout2 = new BorderLayout();
    Border border5;
    JPanel jPanel2 = new JPanel();
    JScrollPane scrollPanel = new JScrollPane();
    JPanel playPanel = new JPanel();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    Vector list = new Vector();
    String currentMidiFile = null;
    JList midiFileNames = new JList();
    JPanel radioButtons = new JPanel();
    JRadioButton rbUseDifferent = new JRadioButton();
    JRadioButton rbUseSame = new JRadioButton();
    JTextField tbCurrentMidi = new JTextField();
    VerticalFlowLayout verticalFlowLayout2 = new VerticalFlowLayout();
    JPanel useSamePanel = new JPanel();
    BoxLayout2 boxLayout21 = new BoxLayout2();
    JPanel jPanel4 = new JPanel();
    BoxLayout2 boxLayout22 = new BoxLayout2();
    MidiPlayer player = null;
    JComboBox cbInstruments = new JComboBox();
    JCheckBox cbAccompaniment = new JCheckBox();
    JbcMetallicPushButton btnPlay = new JbcMetallicPushButton();
    Frame frame;
    JPanel jPanel1 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JButton btnFind = new JButton();
    BoxLayout2 boxLayout23 = new BoxLayout2();
    JPanel jPanel5 = new JPanel();
    Border border6;
    JPanel jPanel6 = new JPanel();

    public MidiFilePanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MidiFilePanel(Frame frame, JButton btnNext, JButton btnPrevious, Project project) {
        super(btnNext, btnPrevious, project);
        this.frame = frame;
        try {
            this.jbInit();
            this._$4075();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.player = new MidiPlayer(Constants.GENERAL_MIDI_TABLE_PATH);
            this._$4077();
        }
        catch (Exception ex1) {
            // empty catch block
        }
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(20, 0, 20, 0);
        this.border2 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(124, 124, 124), new Color(178, 178, 178)), BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.border3 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(178, 178, 178)), BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border4 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border5 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(109, 109, 110), new Color(156, 156, 158)), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border6 = BorderFactory.createEmptyBorder(0, 0, 20, 0);
        this.setLayout(this.borderLayout1);
        this.header.setBackground(Color.lightGray);
        this.header.setFont(new Font("Dialog", 1, 12));
        this.header.setBorder(this.border2);
        this.header.setOpaque(true);
        this.header.setEditable(false);
        this.header.setMargin(new Insets(0, 0, 0, 0));
        this.header.setText("Pick the MIDI file that goes with this lesson.  This is a specially designed MIDI file with tracks designated for accompaniment and soloists.  (See manual for details.)  Click \"Next\" to continue.");
        this.header.setLineWrap(true);
        this.header.setWrapStyleWord(true);
        this.topPanel.setBorder(this.border4);
        this.topPanel.setLayout(this.borderLayout2);
        this.scrollPanel.setVerticalScrollBarPolicy(22);
        this.scrollPanel.setPreferredSize(new Dimension(390, 100));
        this.playPanel.setBackground(Color.lightGray);
        this.playPanel.setBorder(this.border5);
        this.playPanel.setMinimumSize(new Dimension(257, 57));
        this.playPanel.setPreferredSize(new Dimension(390, 50));
        this.jPanel2.setLayout(this.verticalFlowLayout1);
        this.jPanel2.setPreferredSize(new Dimension(450, 365));
        this.midiFileNames.addListSelectionListener(new MidiFilePanel_midiFileNames_listSelectionAdapter(this));
        this.rbUseDifferent.setEnabled(true);
        this.rbUseDifferent.setMinimumSize(new Dimension(180, 23));
        this.rbUseDifferent.setPreferredSize(new Dimension(180, 23));
        this.rbUseDifferent.setFocusPainted(false);
        this.rbUseDifferent.setText("Pick a new MIDI file.");
        this.rbUseDifferent.addActionListener(new MidiFilePanel_rbUseDifferent_actionAdapter(this));
        this.rbUseSame.setEnabled(true);
        this.rbUseSame.setMinimumSize(new Dimension(150, 23));
        this.rbUseSame.setPreferredSize(new Dimension(180, 23));
        this.rbUseSame.setToolTipText("");
        this.rbUseSame.setFocusPainted(false);
        this.rbUseSame.setText("Use the same MIDI file.");
        this.rbUseSame.addActionListener(new MidiFilePanel_rbUseSame_actionAdapter(this));
        this.tbCurrentMidi.setBackground(Color.white);
        this.tbCurrentMidi.setEditable(false);
        this.tbCurrentMidi.setText("");
        this.radioButtons.setLayout(this.verticalFlowLayout2);
        this.useSamePanel.setLayout(this.boxLayout21);
        this.jPanel4.setLayout(this.boxLayout22);
        this.centerPanel.setPreferredSize(new Dimension(500, 375));
        this.cbAccompaniment.setOpaque(false);
        this.cbAccompaniment.setFocusPainted(false);
        this.cbAccompaniment.setSelected(true);
        this.cbAccompaniment.setText("with accompaniment");
        this.cbAccompaniment.addActionListener(new MidiFilePanel_cbAccompaniment_actionAdapter(this));
        this.cbInstruments.addItemListener(new MidiFilePanel_cbInstruments_itemAdapter(this));
        this.btnPlay.setPreferredSize(new Dimension(100, 30));
        this.btnPlay.setText("Play");
        this.btnPlay.setVerifyInputWhenFocusTarget(true);
        this.btnPlay.addActionListener(new MidiFilePanel_btnPlay_actionAdapter(this));
        this.btnFind.setMinimumSize(new Dimension(200, 23));
        this.btnFind.setPreferredSize(new Dimension(235, 23));
        this.btnFind.setText("Find MIDI Files");
        this.btnFind.addActionListener(new MidiFilePanel_btnFind_actionAdapter(this));
        this.jPanel1.setLayout(this.boxLayout23);
        this.jPanel3.setMaximumSize(new Dimension(180, Short.MAX_VALUE));
        this.jPanel3.setMinimumSize(new Dimension(10, 10));
        this.jPanel3.setPreferredSize(new Dimension(180, 10));
        this.verticalFlowLayout2.setVgap(5);
        this.jPanel1.setBorder(this.border6);
        this.add((Component)this.topPanel, "North");
        this.topPanel.add((Component)this.header, "Center");
        this.add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.radioButtons, null);
        this.radioButtons.add((Component)this.useSamePanel, null);
        this.useSamePanel.add((Component)this.rbUseSame, null);
        this.useSamePanel.add((Component)this.tbCurrentMidi, null);
        this.radioButtons.add((Component)this.jPanel5, null);
        this.radioButtons.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.rbUseDifferent, null);
        this.jPanel4.add((Component)this.scrollPanel, null);
        this.radioButtons.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jPanel3, null);
        this.jPanel1.add((Component)this.btnFind, null);
        this.jPanel1.add((Component)this.jPanel6, null);
        this.scrollPanel.getViewport().add((Component)this.midiFileNames, null);
        this.jPanel2.add((Component)this.playPanel, null);
        this.playPanel.add((Component)this.btnPlay, null);
        this.playPanel.add((Component)this.cbInstruments, null);
        this.playPanel.add((Component)this.cbAccompaniment, null);
    }

    private void _$4077() {
        MidiPlayerListener listener = new MidiPlayerListener(){

            public void error(MidiPlayerEvent e) {
                JOptionPane.showMessageDialog(MidiFilePanel.this.frame, "There is a problem playing the MIDI file.\n" + e.getError(), "iPAS Lesson Wizard", 0);
            }

            public void stateChanged(MidiPlayerEvent e) {
                if (e.getState() == MidiPlayer.STATE_FINISHED) {
                    MidiFilePanel.this.btnPlay.setText("Play");
                }
            }

            public void playerLoaded(MidiPlayerEvent e) {
            }
        };
        this.player.addListener(listener);
    }

    private void _$4075() {
        String[] fileList = new File("My MIDI Files/").list();
        if (fileList == null) {
            return;
        }
        this.list.removeAllElements();
        for (int i2 = 0; i2 < fileList.length; ++i2) {
            try {
                String fullPath = "My MIDI Files/" + fileList[i2];
                if (!FileUtils.hasSuffix(fullPath, "mid")) continue;
                this.list.add(new File(fullPath).getName());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.midiFileNames.setListData(this.list);
    }

    void midiFileNames_valueChanged(ListSelectionEvent e) {
        if (this.midiFileNames.getSelectedIndex() == -1) {
            this.currentMidiFile = null;
        } else {
            this._$4134("My MIDI Files/", (String)this.midiFileNames.getSelectedValue());
        }
        this.btnNext.setEnabled(this.currentMidiFile != null);
        this.btnPlay.setEnabled(this.currentMidiFile != null && this.player != null);
    }

    public void start(int tabDirection) {
        if (this.player == null) {
            JOptionPane.showMessageDialog(this, "Unable to setup MIDI Player.");
        } else {
            this.player.open();
        }
        if (this.project.isNewLesson()) {
            this.currentMidiFile = this.project.getMIDIFileName();
            if (this.currentMidiFile == null) {
                this.midiFileNames.clearSelection();
            }
        } else {
            File file = new File(this.project.getURL().getFile());
            this._$4134(file.getParent() + '/', this.project.getMIDIFileName());
        }
        this.btnNext.setEnabled(this.currentMidiFile != null);
        this.rbUseSame.setEnabled(this.currentMidiFile != null);
        this.rbUseDifferent.setSelected(this.currentMidiFile == null);
        this.tbCurrentMidi.setText(this.currentMidiFile);
        this.btnPlay.setEnabled(this.currentMidiFile != null && this.player != null);
        this.btnPlay.setText("Play");
        if (this.currentMidiFile == null) {
            this.rbUseDifferent_actionPerformed(null);
        } else {
            this.rbUseSame_actionPerformed(null);
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
        }
        this.project.setMIDIFileName(this.currentMidiFile);
    }

    void rbUseSame_actionPerformed(ActionEvent e) {
        this.rbUseSame.setSelected(true);
        this.rbUseDifferent.setSelected(false);
        this.scrollPanel.setEnabled(false);
        this.midiFileNames.setEnabled(false);
    }

    void rbUseDifferent_actionPerformed(ActionEvent e) {
        this.rbUseSame.setSelected(false);
        this.rbUseDifferent.setSelected(true);
        this.scrollPanel.setEnabled(true);
        this.midiFileNames.setEnabled(true);
    }

    private void _$4134(String filePath, String fileName) {
        if (this.player == null) {
            return;
        }
        try {
            String path = filePath + fileName;
            AmaSequence sequence = new AmaSequence(this.player, path, AmaSequence.PROGRAM2_LAYOUT);
            sequence.setBenchmark(1);
            this.player.loadPlayer(sequence);
            String[] instruments = sequence.getInstrumentNames();
            this.cbInstruments.removeAllItems();
            for (int i2 = 0; i2 < instruments.length; ++i2) {
                this.cbInstruments.addItem(instruments[i2]);
            }
            this.player.setTrackEnabled(AmaSequence.TRACK_CLICK, true);
            this.player.setTrackEnabled(AmaSequence.TRACK_ACCOMPANY, this.cbAccompaniment.isSelected());
            this.player.setTrackEnabled(AmaSequence.TRACK_BENCHMARK, true);
            this.currentMidiFile = fileName;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.frame, "Unable to use this MIDI file.\n" + ex.getMessage() + "\n\nFile name:  " + fileName, "MIDI File Reader", 0);
            this.currentMidiFile = null;
        }
    }

    void btnPlay_actionPerformed(ActionEvent e) {
        if (!this.player.isPlaying()) {
            this.player.play();
            this.btnPlay.setText("Stop");
        } else {
            this.player.stop();
            this.btnPlay.setText("Play");
        }
    }

    void cbInstruments_itemStateChanged(ItemEvent e) {
        if (this.player == null) {
            return;
        }
        AmaSequence sequence = this.player.getSequence();
        if (sequence != null) {
            sequence.setBenchmark(this.cbInstruments.getSelectedIndex() + 1);
        }
        if (this.player.isPlaying()) {
            this.player.play();
        }
    }

    void cbAccompaniment_actionPerformed(ActionEvent e) {
        if (this.player == null) {
            return;
        }
        this.player.setTrackEnabled(AmaSequence.TRACK_ACCOMPANY, this.cbAccompaniment.isSelected());
    }

    void btnFind_actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new MidiFileFilter());
        if (chooser.showOpenDialog(this) == 0) {
            String path = chooser.getSelectedFile().getPath();
            String fileName = chooser.getSelectedFile().getName();
            FileUtils.copyFile(path, "My MIDI Files/" + fileName);
            this._$4075();
        }
    }
}

