/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit;

import java.io.File;
import java.util.Hashtable;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import pyware.iPasToolkit.Measure;
import pyware.iPasToolkit.MeasureList;
import pyware.iPasToolkit.MidiFileEncryptor;
import pyware.iPasToolkit.MidiPlayer;
import pyware.iPasToolkit.MidiUtils;
import pyware.pyMusicTools.MusicConstants;
import pyware.toolkit.FileUtils;
import pyware.toolkit.Utils;

public class AmaSequence {
    public static int TRACK_CONDUCTOR = 0;
    public static int TRACK_BENCHMARK = 1;
    public static int TRACK_ACCOMPANY = 2;
    public static int TRACK_CLICK = 3;
    public static int TRACK_UNUSED_SOLO = 4;
    public static int NO_LAYOUT = 0;
    public static int PROGRAM_LAYOUT = 1;
    public static int LABEL_LAYOUT = 2;
    public static int PROGRAM2_LAYOUT = 3;
    private int _$579 = NO_LAYOUT;
    private static int _$580 = 116;
    private static int _$581 = 72;
    private static int _$582 = 58;
    private static int _$583 = 61;
    private static int _$584 = 59;
    private MidiPlayer _$585;
    private Sequence _$586;
    private String[] _$587;
    private int[] _$588;
    private long _$589 = 0L;
    private int _$590 = 0;
    private int _$591 = -1;
    private int _$592 = -1;
    private float _$593 = 1.0f;
    private int _$594 = 0;
    private long _$595 = System.currentTimeMillis();
    private long _$597 = 0L;
    private String _$598 = null;
    private MeasureList _$599 = new MeasureList();
    static /* synthetic */ Class class$javax$sound$midi$MetaMessage;
    static /* synthetic */ Class class$javax$sound$midi$ShortMessage;

    public AmaSequence(MidiPlayer player, String fileName, int layout) throws Exception {
        this._$579 = layout;
        this._$585 = player;
        this._$586 = this._$601(fileName);
        this._$598 = this._$602(fileName);
        this._$597 = this._$586.getTickLength();
        if (layout == LABEL_LAYOUT) {
            this._$604();
        } else if (layout == PROGRAM2_LAYOUT) {
            this._$605();
        } else {
            this._$606();
        }
        if (this._$586.getDivisionType() != 0.0f) {
            throw new Exception("SMPTE time codes in MIDI file not implemented.");
        }
        if (this._$586.getResolution() != 240) {
            throw new Exception("Can only use MIDI files set to 240 ticks per beat.");
        }
        this._$592 = this._$610();
    }

    public AmaSequence(MidiPlayer player, Sequence sequence) {
        this._$586 = sequence;
        this._$585 = player;
        this._$597 = sequence.getTickLength();
        this._$592 = this._$610();
    }

    private Sequence _$601(String fileName) {
        boolean decrypted = false;
        String path = fileName;
        try {
            if (MidiFileEncryptor.isEncrypted(path)) {
                MidiFileEncryptor.decrypt(path, "temp.mid");
                path = "temp.mid";
                decrypted = true;
            }
            if (FileUtils.isValid(path)) {
                File file = new File(path);
                if (decrypted) {
                    file.deleteOnExit();
                }
                return MidiSystem.getSequence(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String _$602(String fileName) {
        String name = FileUtils.removeSuffix(fileName);
        if (new File(name = FileUtils.appendSuffix(name, "wvs")).exists()) {
            return name;
        }
        return null;
    }

    private void _$604() {
        this._$624();
        this._$625();
        this._$626();
        this._$627();
        this._$628();
    }

    private void _$606() {
        this._$624();
        this._$629();
        this._$626();
        this._$627();
        this._$628();
    }

    private void _$605() {
        this._$624();
        this._$630();
        this._$626();
        this._$627();
        this._$628();
    }

    private void _$629() {
        String[] clarinets = new String[]{"Bb Clarinet", "Eb Alto Clarinet", "Bb Bass Clarinet"};
        String[] bones = new String[]{"Trombone", "Baritone BC", "Bb Baritone TC"};
        int clarinetNum = 0;
        int boneNum = 0;
        this._$587 = new String[this._$588.length];
        for (int i2 = 0; i2 < this._$588.length; ++i2) {
            int program = this._$588[i2];
            this._$587[i2] = program == _$581 ? clarinets[Math.min(clarinetNum++, clarinets.length - 1)] : (program == _$582 ? bones[Math.min(boneNum++, bones.length - 1)] : (program == 0 ? null : this._$585.getGeneralMidiName(program)));
        }
    }

    private void _$630() {
        String[] clarinets = new String[]{"Bb Clarinet", "Eb Alto Clarinet", "Bb Bass Clarinet"};
        String[] bones = new String[]{"Trombone", "Trombone TC (Brass Band)", "Baritone BC", "Bb Baritone TC"};
        String[] horns = new String[]{"French Horn", "Eb Horn (Brass Band)"};
        String[] tubas = new String[]{"Tuba", "Eb Tuba (Brass Band)", "Bb Tuba TC (Brass Band)"};
        int clarinetNum = 0;
        int boneNum = 0;
        int hornNum = 0;
        int tubaNum = 0;
        this._$587 = new String[this._$588.length];
        for (int i2 = 0; i2 < this._$588.length; ++i2) {
            int program = this._$588[i2];
            this._$587[i2] = program == _$581 ? clarinets[Math.min(clarinetNum++, clarinets.length - 1)] : (program == _$582 ? bones[Math.min(boneNum++, bones.length - 1)] : (program == _$583 ? horns[Math.min(hornNum++, horns.length - 1)] : (program == _$584 ? tubas[Math.min(tubaNum++, tubas.length - 1)] : (program == 0 ? null : this._$585.getGeneralMidiName(program)))));
        }
    }

    private int _$610() {
        int i2;
        if (this._$579 == PROGRAM_LAYOUT) {
            for (i2 = 0; i2 < this._$588.length; ++i2) {
                if (this._$588[i2] != _$580) continue;
                return i2;
            }
        }
        if (this._$579 == PROGRAM2_LAYOUT) {
            for (i2 = 0; i2 < this._$588.length; ++i2) {
                if (this._$588[i2] != _$580) continue;
                return i2;
            }
        }
        if (this._$579 == LABEL_LAYOUT) {
            for (i2 = 0; i2 < this._$587.length; ++i2) {
                if (this._$587[i2] == null || !this._$587[i2].toUpperCase().startsWith("CLICK")) continue;
                return i2;
            }
        }
        return -1;
    }

    private void _$624() {
        Track[] tracks = this._$586.getTracks();
        this._$588 = new int[tracks.length];
        for (int trackNum = 0; trackNum < tracks.length; ++trackNum) {
            Track track = tracks[trackNum];
            for (int eventNum = 0; eventNum < track.size(); ++eventNum) {
                MidiEvent event;
                MidiMessage message;
                if (!(class$javax$sound$midi$ShortMessage == null ? AmaSequence.class$("javax.sound.midi.ShortMessage") : class$javax$sound$midi$ShortMessage).isInstance(message = (event = track.get(eventNum)).getMessage()) || this._$588[trackNum] != 0 || ((ShortMessage)message).getCommand() != 192) continue;
                this._$588[trackNum] = ((ShortMessage)message).getData1() + 1;
                eventNum = track.size();
            }
        }
    }

    public Hashtable extractAccidentalInfo(Track track) {
        Hashtable<Long, Integer> table = new Hashtable<Long, Integer>();
        for (int eventNum = 0; eventNum < track.size(); ++eventNum) {
            MidiEvent event;
            MidiMessage message;
            if (!(class$javax$sound$midi$MetaMessage == null ? AmaSequence.class$("javax.sound.midi.MetaMessage") : class$javax$sound$midi$MetaMessage).isInstance(message = (event = track.get(eventNum)).getMessage()) || ((MetaMessage)message).getType() != 5) continue;
            byte[] data = ((MetaMessage)message).getData();
            String lyric = new String(data);
            if (lyric.length() == 1) {
                lyric = lyric + ' ';
            }
            Integer value = null;
            if (lyric.equalsIgnoreCase("b ")) {
                value = new Integer(MusicConstants.BIAS_FLAT);
            } else if (lyric.equalsIgnoreCase("# ") | lyric.equalsIgnoreCase("m ")) {
                value = new Integer(MusicConstants.BIAS_SHARP);
            } else if (lyric.equalsIgnoreCase("n ")) {
                value = new Integer(MusicConstants.BIAS_NEUTRAL);
            }
            if (value == null) continue;
            table.put(new Long(event.getTick()), value);
        }
        return table;
    }

    public Hashtable extractAccidentalInfo(int trackNum) {
        Track[] tracks;
        if (trackNum < 0 | trackNum > (tracks = this._$586.getTracks()).length) {
            return null;
        }
        return this.extractAccidentalInfo(tracks[trackNum]);
    }

    private void _$625() {
        Track[] tracks = this._$586.getTracks();
        this._$587 = new String[tracks.length];
        for (int trackNum = 0; trackNum < tracks.length; ++trackNum) {
            Track track = tracks[trackNum];
            for (int eventNum = 0; eventNum < track.size(); ++eventNum) {
                MidiEvent event;
                MidiMessage message;
                if (!(class$javax$sound$midi$MetaMessage == null ? AmaSequence.class$("javax.sound.midi.MetaMessage") : class$javax$sound$midi$MetaMessage).isInstance(message = (event = track.get(eventNum)).getMessage()) || ((MetaMessage)message).getType() != 3) continue;
                byte[] data = ((MetaMessage)message).getData();
                this._$587[trackNum] = new String(data).toUpperCase().trim();
                eventNum = track.size();
            }
        }
    }

    private void _$626() {
        Track track = this.getTracks()[0];
        MidiEvent event = null;
        MidiMessage message = null;
        Measure lastMeasure = null;
        for (int eventNum = 0; eventNum < track.size(); ++eventNum) {
            int type;
            if (!(class$javax$sound$midi$MetaMessage == null ? AmaSequence.class$("javax.sound.midi.MetaMessage") : class$javax$sound$midi$MetaMessage).isInstance(message = (event = track.get(eventNum)).getMessage()) || (type = ((MetaMessage)message).getType()) != 88) continue;
            byte[] data = ((MetaMessage)message).getData();
            byte numerator = data[0];
            int denominator = new Double(Math.pow(2.0, data[1])).intValue();
            lastMeasure = new Measure(numerator, denominator, event.getTick());
            this._$599.addTimeSig(lastMeasure, true);
        }
        if (lastMeasure != null) {
            lastMeasure = new Measure(lastMeasure);
            lastMeasure.time = this.getTickLength();
            this._$599.addTimeSig(lastMeasure, false);
        }
    }

    private void _$628() {
        Track track = this.getTracks()[0];
        for (int eventNum = 0; eventNum < track.size(); ++eventNum) {
            MidiEvent event;
            MidiMessage message;
            if (!(class$javax$sound$midi$MetaMessage == null ? AmaSequence.class$("javax.sound.midi.MetaMessage") : class$javax$sound$midi$MetaMessage).isInstance(message = (event = track.get(eventNum)).getMessage())) continue;
            int type = ((MetaMessage)message).getType();
            byte[] data = ((MetaMessage)message).getData();
            if (type != 89) continue;
            byte sf = data[0];
            if (sf == 0) {
                this._$594 = MusicConstants.KEY_C;
            }
            if (sf == 1) {
                this._$594 = MusicConstants.KEY_F;
            }
            if (sf == 2) {
                this._$594 = MusicConstants.KEY_Bb;
            }
            if (sf == 3) {
                this._$594 = MusicConstants.KEY_Eb;
            }
            if (sf == 4) {
                this._$594 = MusicConstants.KEY_Ab;
            }
            if (sf == 5) {
                this._$594 = MusicConstants.KEY_Db;
            }
            if (sf == 6) {
                this._$594 = MusicConstants.KEY_Gb;
            }
            if (sf == 7) {
                this._$594 = MusicConstants.KEY_Cb;
            }
            if (sf == -1) {
                this._$594 = MusicConstants.KEY_G;
            }
            if (sf == -2) {
                this._$594 = MusicConstants.KEY_D;
            }
            if (sf == -3) {
                this._$594 = MusicConstants.KEY_A;
            }
            if (sf == -4) {
                this._$594 = MusicConstants.KEY_E;
            }
            if (sf == -5) {
                this._$594 = MusicConstants.KEY_B;
            }
            if (sf == -6) {
                this._$594 = MusicConstants.KEY_CSharp;
            }
            if (sf == -7) {
                this._$594 = MusicConstants.KEY_FSharp;
            }
            return;
        }
    }

    private void _$627() {
        Track track = this.getTracks()[0];
        for (int eventNum = 0; eventNum < track.size(); ++eventNum) {
            MidiEvent event;
            MidiMessage message;
            if (!(class$javax$sound$midi$MetaMessage == null ? AmaSequence.class$("javax.sound.midi.MetaMessage") : class$javax$sound$midi$MetaMessage).isInstance(message = (event = track.get(eventNum)).getMessage())) continue;
            int type = ((MetaMessage)message).getType();
            byte[] data = ((MetaMessage)message).getData();
            if (type != 81) continue;
            this._$589 = Utils.byteArrayToLongValue(data) / 1000L;
            this._$590 = new Long(60000L / this._$589).intValue();
        }
    }

    public int findSmallestNoteDuration(Track track) {
        long smallTick = Long.MAX_VALUE;
        int n2 = track.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            MidiEvent e = track.get(i2);
            if (!MidiUtils.isNoteOn(e)) continue;
            int midiNote = MidiUtils.getData1(e);
            long startTick = e.getTick();
            long tick = (e = MidiUtils.findNextNoteOff(track, e)).getTick() - startTick;
            if (tick >= smallTick || tick < 0L) continue;
            smallTick = tick;
        }
        return new Long(smallTick).intValue();
    }

    public int findSmallestNoteDuration(int trackNum) {
        Track[] tracks;
        if (trackNum < 0 | trackNum > (tracks = this._$586.getTracks()).length) {
            return -1;
        }
        return this.findSmallestNoteDuration(tracks[trackNum]);
    }

    public int getNumTracks() {
        return this.getTracks().length;
    }

    public Track[] getTracks() {
        return this._$586.getTracks();
    }

    public String getTrackName(int index) {
        return this._$587[index];
    }

    public int getTrackNum(String trackName) {
        trackName = trackName.toUpperCase().trim();
        for (int i2 = 1; i2 < this._$587.length; ++i2) {
            if (this._$587[i2] == null || trackName.compareToIgnoreCase(this._$587[i2]) != 0) continue;
            return i2;
        }
        return -1;
    }

    public String getBenchmarkTrackName() {
        if (this._$591 == -1) {
            return null;
        }
        return this._$587[this._$591];
    }

    public Track getBenchmarkTrack() {
        if (this._$591 == -1) {
            return null;
        }
        return this.getTracks()[this._$591];
    }

    public int getTempo() {
        return this._$590;
    }

    public void setTempoFactor(float tempoFactor) {
        this._$593 = tempoFactor;
        this._$585.setTempoFactor(tempoFactor);
    }

    public float getTempoFactor() {
        return this._$593;
    }

    public Track createNewTrack() {
        return this._$586.createTrack();
    }

    public String getWaveSyncFile() {
        return this._$598;
    }

    public AmaSequence createEmptySequence() {
        try {
            Sequence newSequence = new Sequence(this._$586.getDivisionType(), this._$586.getResolution());
            return this._$585.createAmaSequence(newSequence);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Sequence getSequence() {
        return this._$586;
    }

    public long getTickLength() {
        return this._$597;
    }

    public String[] getInstrumentNames() {
        int lastInstrument = this._$592 - 1;
        if (lastInstrument == -1) {
            return new String[0];
        }
        String[] list = new String[lastInstrument];
        for (int i2 = 1; i2 <= lastInstrument; ++i2) {
            list[i2 - 1] = this._$587[i2];
        }
        return list;
    }

    public void setBenchmark(int benchmark) {
        this._$591 = benchmark;
    }

    public int getTrackType(int trackNum) {
        if (trackNum == 0) {
            return TRACK_CONDUCTOR;
        }
        if (trackNum == this._$591) {
            return TRACK_BENCHMARK;
        }
        if (trackNum == this._$592) {
            return TRACK_CLICK;
        }
        if (trackNum < this._$592) {
            return TRACK_UNUSED_SOLO;
        }
        return TRACK_ACCOMPANY;
    }

    public int getDenomonator(int index) {
        return this._$599.getDenominator(index);
    }

    public int getNumerator(int index) {
        return this._$599.getNumerator(index);
    }

    public int getTotalMeasures() {
        return this._$599.size();
    }

    public long getMeasureTime(int measure) {
        return this._$599.measureAt((int)measure).time;
    }

    public boolean isTimeSig(int measure) {
        return this._$599.measureAt((int)measure).timeSigChange;
    }

    public int getKeySig() {
        return this._$594;
    }

    public long getCreationDate() {
        return this._$595;
    }

    public void setCreationDate(long creationDate) {
        this._$595 = creationDate;
    }
}

