/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class MidiFileEncryptor {
    public static void decrypt(String sourceName, String destName) throws Exception {
        if (!MidiFileEncryptor.isEncrypted(sourceName)) {
            throw new Exception("The file [" + sourceName + "] is not encrypted.");
        }
        int BUFFER_LEN = 1024;
        byte[] midiFileSig = new byte[]{77, 84, 104, 100};
        byte[] buffer = new byte[BUFFER_LEN];
        FileInputStream in = new FileInputStream(sourceName);
        FileOutputStream out = new FileOutputStream(destName);
        boolean first = true;
        while (in.read(buffer) != -1) {
            if (first) {
                buffer[1] = midiFileSig[1];
            }
            first = false;
            out.write(buffer);
        }
        in.close();
        out.close();
    }

    public static void encrypt(String sourceName, String destName) throws Exception {
        if (MidiFileEncryptor.isEncrypted(sourceName)) {
            throw new Exception("The file [" + sourceName + "] is already encrypted.");
        }
        int BUFFER_LEN = 1024;
        byte[] encryptedMidiFileSig = new byte[]{77, 80, 104, 100};
        byte[] buffer = new byte[BUFFER_LEN];
        FileInputStream in = new FileInputStream(sourceName);
        FileOutputStream out = new FileOutputStream(destName);
        boolean first = true;
        while (in.read(buffer) != -1) {
            if (first) {
                buffer[1] = encryptedMidiFileSig[1];
            }
            first = false;
            out.write(buffer);
        }
        in.close();
        out.close();
    }

    public static boolean isEncrypted(String fileName) {
        byte[] encryptedMidiFileSig = new byte[]{77, 80, 104, 100};
        try {
            FileInputStream stream = new FileInputStream(fileName);
            byte[] headerSig = new byte[4];
            int len = stream.read(headerSig);
            if (len == 4 && headerSig[0] == encryptedMidiFileSig[0] && headerSig[1] == encryptedMidiFileSig[1] && headerSig[2] == encryptedMidiFileSig[2] && headerSig[3] == encryptedMidiFileSig[3]) {
                stream.close();
                return true;
            }
            stream.close();
        }
        catch (IOException ex) {}
        return false;
    }
}

