/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.swing.JCheckBox;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pyware.iPasToolkit.AmaSequence;
import pyware.iPasToolkit.MidiPlayerEvent;
import pyware.iPasToolkit.MidiPlayerListener;
import pyware.iPasToolkit.WaveSyncPlayer;
import pyware.iPasToolkit.WaveSyncPlayerEvent;
import pyware.iPasToolkit.WaveSyncPlayerListener;

public class MidiPlayer {
    public static int STATE_CLOSED = 0;
    public static int STATE_FINISHED;
    public static int STATE_OPENED;
    public static int STATE_STARTED;
    public static int STATE_STOPPED;
    private boolean _$3734 = true;
    private String[] _$3724;
    private String _$3726 = "";
    private Vector _$452 = new Vector();
    private boolean _$3729 = false;
    private boolean _$3728 = false;
    private boolean _$3730 = false;
    private AmaSequence _$3727 = null;
    private Sequencer _$3148;
    private int _$447 = -1;
    private double _$3732 = 0.0;
    private String _$3725 = "";
    private int _$3731 = 64;
    private WaveSyncPlayer _$3733 = new WaveSyncPlayer();

    static {
        STATE_OPENED = 1;
        STATE_STARTED = 2;
        STATE_STOPPED = 3;
        STATE_FINISHED = 4;
    }

    public MidiPlayer(String paramFilePath) throws Exception {
        this._$3148 = MidiSystem.getSequencer();
        this._$3736(paramFilePath);
        this._$3148.addMetaEventListener(new MetaEventListener(){

            public void meta(MetaMessage meta) {
                MidiPlayer.this._$3738(meta);
            }
        });
        this._$3733.addListener(new WaveSyncPlayerListener(){

            public void error(WaveSyncPlayerEvent e) {
                MidiPlayer.this._$505("WaveSyncPlayer Error\n" + e.getError());
            }

            public void stateChanged(WaveSyncPlayerEvent e) {
                MidiPlayer.this._$454(e.getState());
            }
        });
    }

    public synchronized void addListener(MidiPlayerListener listener) {
        this._$452.addElement(listener);
    }

    private void _$3769() {
        if (this._$3727 == null) {
            return;
        }
        double ticksPerBeat = this._$3727.getSequence().getResolution();
        float beatsPerMinute = this._$3773();
        double ticksPerMinute = (double)beatsPerMinute * ticksPerBeat;
        double ticksPerSec = ticksPerMinute / 60.0;
        this._$3732 = ticksPerSec / 1000.0;
    }

    public boolean canUseWaveSyncPlayer() {
        return this._$3734 && this._$3733.getFileName() != null;
    }

    public void close() {
        this._$3148.close();
        this._$453(STATE_CLOSED);
    }

    public AmaSequence createAmaSequence(Sequence sequence) {
        return new AmaSequence(this, sequence);
    }

    public AmaSequence createAmaSequence(String fileName, int layout) throws Exception {
        return new AmaSequence(this, fileName, layout);
    }

    private void _$505(String msg) {
        MidiPlayerEvent e = MidiPlayerEvent.createErrorEvent(this, msg);
        int i2 = 0;
        while (i2 < this._$452.size()) {
            ((MidiPlayerListener)this._$452.elementAt(i2)).error(e);
            ++i2;
        }
    }

    private void _$3778(Sequencer sequencer) {
        MidiPlayerEvent e = MidiPlayerEvent.createPlayerLoadedEvent(this, sequencer);
        int i2 = 0;
        while (i2 < this._$452.size()) {
            ((MidiPlayerListener)this._$452.elementAt(i2)).playerLoaded(e);
            ++i2;
        }
    }

    private void _$3787() {
        MidiPlayerEvent e = MidiPlayerEvent.createRestartNeededEvent(this);
        int i2 = 0;
        while (i2 < this._$452.size()) {
            ((MidiPlayerListener)this._$452.elementAt(i2)).restartNeeded(e);
            ++i2;
        }
    }

    private void _$454(int state) {
        MidiPlayerEvent e = MidiPlayerEvent.createStateChangedEvent(this, state);
        int i2 = 0;
        while (i2 < this._$452.size()) {
            ((MidiPlayerListener)this._$452.elementAt(i2)).stateChanged(e);
            ++i2;
        }
    }

    public void finish() {
        if (this._$3148.isRunning()) {
            this._$3148.stop();
        }
        if (this._$3733.isPlaying()) {
            this._$3733.stop();
        }
        this._$453(STATE_FINISHED);
    }

    public ActionListener getControlListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().toUpperCase().startsWith("BENCHMARK")) {
                    MidiPlayer.this.setTrackEnabled(AmaSequence.TRACK_BENCHMARK, ((JCheckBox)e.getSource()).isSelected());
                }
                if (e.getActionCommand().toUpperCase().startsWith("ACCOMPANIMENT")) {
                    MidiPlayer.this.setTrackEnabled(AmaSequence.TRACK_ACCOMPANY, ((JCheckBox)e.getSource()).isSelected());
                }
                if (e.getActionCommand().toUpperCase().startsWith("CLICKS")) {
                    MidiPlayer.this.setTrackEnabled(AmaSequence.TRACK_CLICK, ((JCheckBox)e.getSource()).isSelected());
                }
            }
        };
    }

    public String getGeneralMidiName(int program) {
        if (program < 0 | program >= this._$3724.length) {
            return null;
        }
        return this._$3724[program];
    }

    public AmaSequence getSequence() {
        return this._$3727;
    }

    public Sequencer getSequencer() {
        return this._$3148;
    }

    public int getState() {
        return this._$447;
    }

    private float _$3773() {
        return this._$3148.getTempoInBPM() * this._$3148.getTempoFactor();
    }

    public long getTickPosition() {
        if (this.isWaveSyncPlaying()) {
            return this._$3733.getTickPosition();
        }
        if (this.isPlaying()) {
            return this._$3148.getTickPosition();
        }
        return 0L;
    }

    public double getTicksPerMSec() {
        return this._$3732;
    }

    public ChangeListener getVolumeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MidiPlayer.this.setVolume(((JSlider)e.getSource()).getValue());
            }
        };
    }

    public boolean isPlaying() {
        if (this._$3733.isPlaying()) {
            return true;
        }
        return this._$447 == STATE_STARTED;
    }

    public boolean isTrackEnabled(int trackType) {
        if (trackType == AmaSequence.TRACK_ACCOMPANY) {
            return this._$3729;
        }
        if (trackType == AmaSequence.TRACK_CLICK) {
            return this._$3730;
        }
        if (trackType == AmaSequence.TRACK_BENCHMARK) {
            return this._$3728;
        }
        return trackType == AmaSequence.TRACK_CONDUCTOR;
    }

    public boolean isWaveSyncPlaying() {
        return this._$3733 == null ? false : this._$3733.isPlaying();
    }

    public void loadPlayer(AmaSequence sequence) {
        try {
            this._$3727 = sequence;
            this._$3148.setSequence(sequence.getSequence());
            this._$3148.setTempoFactor(sequence.getTempoFactor());
            this._$3751();
            this._$3769();
            this.setWaveSyncFile(sequence.getWaveSyncFile());
        }
        catch (Exception e) {
            this._$505("Unable to load MIDI Player.\nError:" + e.getMessage());
            e.printStackTrace();
        }
        this._$3778(this._$3148);
    }

    public void open() {
        if (this._$3148.isOpen()) {
            return;
        }
        try {
            this._$3148.open();
            this._$453(STATE_OPENED);
        }
        catch (Exception e) {
            this._$505("Unable to open MIDI Player.");
            e.printStackTrace();
        }
    }

    public void play() {
        if (this._$3148.isRunning()) {
            this._$3148.stop();
        }
        if (this._$3733.isPlaying()) {
            this._$3733.stop();
        }
        this._$3148.setTickPosition(0L);
        if (this.usingWaveSyncPlayer()) {
            this._$3733.start();
        } else {
            this._$3148.start();
        }
        this._$3751();
        this._$3761();
        this._$453(STATE_STARTED);
    }

    private void _$3738(MetaMessage meta) {
        int type = meta.getType();
        byte[] data = meta.getData();
        if (type == 47 && this.isPlaying() && !this._$3148.isRunning()) {
            this._$453(STATE_FINISHED);
        }
        if (type == 88) {
            byte numerator = data[0];
            int denomonator = data[1] ^ 2;
        }
        if (type == 3) {
            this._$3725 = new String(data);
        }
        if (type == 4) {
            this._$3726 = new String(data);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void _$3736(String paramFilePath) throws Exception {
        String str;
        URL url = new URL("file:" + paramFilePath);
        InputStream stream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        this._$3724 = new String[129];
        this._$3724[0] = "Undefined";
        int i2 = 1;
        while ((str = reader.readLine()) != null && i2 < 129) {
            void var5_6;
            this._$3724[i2++] = var5_6.substring(4);
        }
        stream.close();
    }

    public synchronized void removeListener(MidiPlayerListener listener) {
        this._$452.removeElement(listener);
    }

    public boolean setSoundBand(String filePath) {
        try {
            File file = new File(filePath);
            MidiSystem.getSoundbank(file);
        }
        catch (IOException ex) {
            return false;
        }
        catch (InvalidMidiDataException ex) {
            return false;
        }
        return true;
    }

    private void _$453(int state) {
        this._$447 = state;
        this._$454(state);
    }

    public void setTempoFactor(float tempoFactor) {
        this._$3148.setTempoFactor(tempoFactor);
        this._$3769();
    }

    public void setTrackEnabled(int trackType, boolean enabled) {
        boolean wasPlayAccompany = this._$3729;
        if (trackType == AmaSequence.TRACK_ACCOMPANY) {
            this._$3729 = enabled;
        }
        if (trackType == AmaSequence.TRACK_CLICK) {
            this._$3730 = enabled;
        }
        if (trackType == AmaSequence.TRACK_BENCHMARK) {
            this._$3728 = enabled;
        }
        this._$3751();
        if (this.isPlaying() && this.canUseWaveSyncPlayer() && this._$3729 != wasPlayAccompany) {
            this._$3787();
        }
    }

    public void setVolume(int volume) {
        this._$3731 = volume;
        this._$3761();
    }

    public void setWaveSyncFile(String fileName) throws Exception {
        try {
            this._$3733.setFileName(fileName);
        }
        catch (Exception ex) {
            this._$505("Error loading WaveSync file.\n" + ex.getMessage());
            throw ex;
        }
    }

    public void stop() {
        if (this._$3148.isRunning()) {
            this._$3148.stop();
        }
        if (this._$3733.isPlaying()) {
            this._$3733.stop();
        }
        this._$453(STATE_STOPPED);
    }

    private synchronized void _$3751() {
        if (this._$3727 == null) {
            return;
        }
        boolean playMidiAccompany = this._$3729;
        if (this.usingWaveSyncPlayer()) {
            playMidiAccompany = false;
        }
        int len = this._$3727.getNumTracks();
        boolean[] enabledTracks = new boolean[len];
        int i2 = 0;
        while (i2 < len) {
            int type = this._$3727.getTrackType(i2);
            if (type == AmaSequence.TRACK_CONDUCTOR) {
                enabledTracks[i2] = true;
            } else if (type == AmaSequence.TRACK_UNUSED_SOLO) {
                enabledTracks[i2] = false;
            } else if (type == AmaSequence.TRACK_ACCOMPANY) {
                enabledTracks[i2] = playMidiAccompany;
            } else if (type == AmaSequence.TRACK_BENCHMARK) {
                enabledTracks[i2] = this._$3728;
            } else if (type == AmaSequence.TRACK_CLICK) {
                enabledTracks[i2] = this._$3730;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < enabledTracks.length) {
            this._$3148.setTrackMute(i3, !enabledTracks[i3]);
            ++i3;
        }
    }

    public boolean usingWaveSyncPlayer() {
        return this.canUseWaveSyncPlayer() && !this._$3728 && !this._$3730 && this._$3729;
    }

    private synchronized void _$3761() {
        if (this._$3733.isPlaying()) {
            this._$3733.setVolume(this._$3731);
            return;
        }
        Synthesizer synthesizer = (Synthesizer)((Object)this._$3148);
        MidiChannel[] channels = synthesizer.getChannels();
        int i2 = 0;
        while (i2 < channels.length) {
            channels[i2].controlChange(7, this._$3731);
            if (channels[i2].getController(7) != this._$3731) {
                channels[i2].setChannelPressure(this._$3731);
            }
            ++i2;
        }
    }
}

