/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit;

import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import pyware.iPasToolkit.TrackExtents;

public class MidiUtils {
    static /* synthetic */ Class class$javax$sound$midi$ShortMessage;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static void dumpTrack(Track track, String msg) {
        System.out.println("Track NoteOn/Off Dump");
        if (msg != null && msg.length() > 0) {
            System.out.println(msg);
        }
        System.out.println("Index\tNote#\tMIDI#\tNoteOn\tNoteOff");
        int count = 0;
        int i2 = 0;
        while (i2 < track.size()) {
            MidiEvent e = track.get(i2);
            if (MidiUtils.isNoteOn(e)) {
                System.out.print(i2 + "\t" + count++ + "\t" + MidiUtils.getData1(e) + "\t" + e.getTick() + "\t");
            }
            if (MidiUtils.isNoteOff(e)) {
                System.out.print(e.getTick() + "\n");
            }
            ++i2;
        }
    }

    public static MidiEvent findNextNoteOff(Track track, MidiEvent noteOn) {
        if (!MidiUtils.isNoteOn(noteOn)) {
            return null;
        }
        int noteOnIndex = MidiUtils.midiTrackIndexOf(track, noteOn);
        int i2 = noteOnIndex + 1;
        while (i2 < track.size()) {
            if (MidiUtils.isNoteOff(track.get(i2))) {
                return track.get(i2);
            }
            ++i2;
        }
        return null;
    }

    public static MidiEvent findNoteOnAt(Track track, long timestamp) {
        if (track == null) {
            return null;
        }
        MidiEvent lastNoteOn = null;
        int len = track.size();
        int i2 = 0;
        while (i2 < len) {
            MidiEvent event = track.get(i2);
            if (event.getTick() >= timestamp) {
                i2 = track.size();
            } else if (MidiUtils.isNoteOn(event)) {
                lastNoteOn = event;
            } else if (MidiUtils.isNoteOff(event)) {
                lastNoteOn = null;
            }
            ++i2;
        }
        return lastNoteOn;
    }

    public static int getData1(MidiEvent event) {
        if (!(class$javax$sound$midi$ShortMessage == null ? (class$javax$sound$midi$ShortMessage = MidiUtils.class$("javax.sound.midi.ShortMessage")) : class$javax$sound$midi$ShortMessage).isInstance(event.getMessage())) {
            return -1;
        }
        ShortMessage msg = (ShortMessage)event.getMessage();
        return msg.getData1();
    }

    public static int getData2(MidiEvent event) {
        if (!(class$javax$sound$midi$ShortMessage == null ? (class$javax$sound$midi$ShortMessage = MidiUtils.class$("javax.sound.midi.ShortMessage")) : class$javax$sound$midi$ShortMessage).isInstance(event.getMessage())) {
            return -1;
        }
        ShortMessage msg = (ShortMessage)event.getMessage();
        return msg.getData2();
    }

    public static int getMidiCommand(MidiEvent event) {
        if (!(class$javax$sound$midi$ShortMessage == null ? (class$javax$sound$midi$ShortMessage = MidiUtils.class$("javax.sound.midi.ShortMessage")) : class$javax$sound$midi$ShortMessage).isInstance(event.getMessage())) {
            return -1;
        }
        ShortMessage msg = (ShortMessage)event.getMessage();
        return msg.getCommand();
    }

    public static TrackExtents getTrackExtents(Track track) {
        int minNoteNum = 128;
        int maxNoteNum = 0;
        int i2 = 0;
        while (i2 < track.size()) {
            MidiEvent e = track.get(i2);
            if (MidiUtils.isNoteOn(e)) {
                int noteNum = MidiUtils.getData1(e);
                minNoteNum = Math.min(noteNum, minNoteNum);
                maxNoteNum = Math.max(noteNum, maxNoteNum);
            }
            ++i2;
        }
        return new TrackExtents(minNoteNum, maxNoteNum);
    }

    public static boolean isMidiCommand(MidiEvent event, int shortMessageCommand) {
        int command = MidiUtils.getMidiCommand(event);
        if (command == -1) {
            return false;
        }
        return command == shortMessageCommand;
    }

    public static boolean isNoteOff(MidiEvent event) {
        if (event == null) {
            return false;
        }
        if (MidiUtils.isMidiCommand(event, 144) && MidiUtils.getData2(event) == 0) {
            return true;
        }
        return MidiUtils.isMidiCommand(event, 128);
    }

    public static boolean isNoteOn(MidiEvent event) {
        if (event == null) {
            return false;
        }
        return MidiUtils.isMidiCommand(event, 144) && MidiUtils.getData2(event) > 0;
    }

    public static int mSecToTicks(float tempo, int resolution, float divisionType, long mSec) {
        float fTicks = 0.0f;
        if (divisionType == 0.0f) {
            float beatsPerMsec = tempo / 60.0f / 1000.0f;
            float ticksPerBeat = resolution;
            float beats = (float)mSec * beatsPerMsec;
            fTicks = beats * ticksPerBeat;
        }
        return new Float(fTicks).intValue();
    }

    public static int mSecToTicks(Sequencer sequencer, long mSec) {
        float tempo = sequencer.getTempoInBPM() * sequencer.getTempoFactor();
        int resolution = sequencer.getSequence().getResolution();
        float divisionType = sequencer.getSequence().getDivisionType();
        return MidiUtils.mSecToTicks(tempo, resolution, divisionType, mSec);
    }

    public static int midiTrackIndexOf(Track track, MidiEvent event) {
        int i2 = 0;
        while (i2 < track.size()) {
            if (track.get(i2).equals(event)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static double pitchBendToCents(MidiEvent event) {
        if (!MidiUtils.isMidiCommand(event, 224)) {
            return 0.0;
        }
        MidiMessage msg = event.getMessage();
        byte[] data = msg.getMessage();
        int val = data[1] + data[2] * 128 - 8192;
        return (double)val / 8192.0;
    }
}

