/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit;

import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import pyware.iPasToolkit.WaveSyncPlayerEvent;
import pyware.iPasToolkit.WaveSyncPlayerListener;
import pyware.toolkit.FileUtils;

public class WaveSyncPlayer
implements Runnable {
    private static int _$1983;
    public static int FINISHED;
    public static int LATENCY;
    public static int PLAYING;
    public static int STARTING;
    public static int STOPPED;
    private AudioInputStream _$1987;
    private SourceDataLine _$1988;
    private byte[] _$492;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;
    private String _$474 = null;
    private int _$1993 = 0;
    private int _$1994 = 0;
    private int _$1992 = 0;
    private Vector _$452;
    private byte[] _$1996;
    private BitSet _$1995 = null;
    private double _$1989;
    private long _$1990 = 0L;
    private int _$447 = STOPPED;
    private Thread _$451;
    private int _$1991 = 0;
    private BitSet _$1643 = null;

    static {
        LATENCY = 280;
        _$1983 = 1028;
        STARTING = 1;
        PLAYING = 2;
        STOPPED = 3;
        FINISHED = 4;
    }

    public WaveSyncPlayer() {
        this._$452 = new Vector();
    }

    public synchronized void addListener(WaveSyncPlayerListener listener) {
        this._$452.addElement(listener);
    }

    private void _$2017() {
        if (this._$1996.length == 0) {
            return;
        }
        long time = System.currentTimeMillis() - this._$1990;
        int index = Math.min(this._$2011(time) + 1, this._$1643.length());
        int i2 = this._$1993 + 1;
        while (i2 < index) {
            if (this._$1995.get(i2)) {
                this._$2021(this._$2012(i2), this._$1996[this._$1994++]);
            }
            ++i2;
        }
        this._$1993 = index;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void _$511() {
        if (!this._$1997()) {
            return;
        }
        try {
            this._$1987.close();
        }
        catch (IOException ex) {
            this._$505(ex.getMessage());
        }
        this._$1987 = null;
        this._$1988.close();
        this._$1988 = null;
    }

    private void _$505(String msg) {
        WaveSyncPlayerEvent e = WaveSyncPlayerEvent.createErrorEvent(this, msg);
        int i2 = 0;
        while (i2 < this._$452.size()) {
            ((WaveSyncPlayerListener)this._$452.elementAt(i2)).error(e);
            ++i2;
        }
    }

    private void _$2021(long time, byte value) {
        WaveSyncPlayerEvent e = WaveSyncPlayerEvent.createStateChangedEvent(this, this._$447);
        int i2 = 0;
        while (i2 < this._$452.size()) {
            ((WaveSyncPlayerListener)this._$452.elementAt(i2)).que(e);
            ++i2;
        }
    }

    private void _$454(int state) {
        WaveSyncPlayerEvent e = WaveSyncPlayerEvent.createStateChangedEvent(this, state);
        int i2 = 0;
        while (i2 < this._$452.size()) {
            ((WaveSyncPlayerListener)this._$452.elementAt(i2)).stateChanged(e);
            ++i2;
        }
    }

    private int _$2022(double time) {
        int index = Math.min(this._$2011(time) + 1, this._$1643.length());
        int i2 = this._$1992 + 1;
        while (i2 < index) {
            if (this._$1643.get(i2)) {
                ++this._$1991;
            }
            ++i2;
        }
        this._$1992 = index;
        return this._$1991;
    }

    public String getFileName() {
        return this._$474;
    }

    public long getTickPosition() {
        return this._$2022(System.currentTimeMillis() - this._$1990);
    }

    public int getTotalBeats() {
        if (this._$1643 == null) {
            return 0;
        }
        int len = this._$1643.length();
        int count = 0;
        int i2 = 0;
        while (i2 < len) {
            if (this._$1643.get(i2)) {
                ++count;
            }
            ++i2;
        }
        return count;
    }

    private long _$2012(int index) {
        return new Double((double)index / this._$1989).longValue();
    }

    private boolean _$1997() {
        return this._$1987 != null;
    }

    public boolean isPlaying() {
        return this._$447 == PLAYING && this._$451 != null;
    }

    /*
     * WARNING - void declaration
     */
    private void _$1998() throws Exception {
        int i2;
        int bytesRead;
        long size = this._$1987.getFrameLength();
        this._$1643 = new BitSet(new Long(size).intValue());
        this._$1995 = new BitSet(new Long(size).intValue());
        Vector<Byte> vQueValue = new Vector<Byte>();
        int frameCount = 0;
        while ((bytesRead = this._$1987.read(this._$492, 0, this._$492.length)) != -1) {
            void var4_4;
            i2 = 1;
            while (i2 < var4_4) {
                if (this._$492[i2] == 1) {
                    this._$1643.set(frameCount, true);
                }
                if (this._$492[i2] > 1) {
                    this._$1995.set(frameCount, true);
                    vQueValue.add(new Byte(this._$492[i2]));
                }
                ++frameCount;
                i2 += 2;
            }
        }
        this._$1996 = new byte[vQueValue.size()];
        i2 = 0;
        while (i2 < this._$1996.length) {
            this._$1996[i2] = (Byte)vQueValue.elementAt(i2);
            ++i2;
        }
    }

    private void _$508() throws Exception {
        if (this._$1997()) {
            return;
        }
        this._$492 = new byte[_$1983];
        AudioFormat audioFormat = this._$2002(this._$474);
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = WaveSyncPlayer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
        this._$1988 = (SourceDataLine)AudioSystem.getLine(info);
        this._$1988.open(audioFormat);
        this._$1988.start();
    }

    private AudioFormat _$2002(String fileName) throws Exception {
        File soundFile = new File(fileName);
        this._$1987 = AudioSystem.getAudioInputStream(soundFile);
        long size = this._$1987.getFrameLength();
        if (size > Integer.MAX_VALUE) {
            throw new Exception("The Wave Sync file is too big for the WaveSyncPlayer to handle.");
        }
        AudioFormat audioFormat = this._$1987.getFormat();
        if (audioFormat.getChannels() != 2 | audioFormat.getSampleSizeInBits() != 8) {
            throw new Exception("The Wave Sync file is not in the correct format (8 bit, 2 channel).");
        }
        this._$1989 = (double)audioFormat.getSampleRate() / 1000.0;
        this._$1998();
        this._$1987.close();
        this._$1987 = AudioSystem.getAudioInputStream(soundFile);
        return audioFormat;
    }

    public synchronized void removeListener(WaveSyncPlayerListener listener) {
        this._$452.removeElement(listener);
    }

    public void run() {
        this._$453(STARTING);
        int bytesRead = 0;
        try {
            this._$508();
            this._$1991 = 0;
            this._$1992 = 0;
            this._$1993 = 0;
            this._$1994 = 0;
            this._$1990 = System.currentTimeMillis();
            this._$453(PLAYING);
            while (this._$451 != null) {
                bytesRead = this._$1987.read(this._$492, 0, this._$492.length);
                if (bytesRead != -1) {
                    byte[] audioBuf = new byte[bytesRead];
                    int i2 = 0;
                    while (i2 < bytesRead) {
                        audioBuf[i2] = this._$492[i2];
                        audioBuf[i2 + 1] = this._$492[i2];
                        i2 += 2;
                    }
                    int bytesWritten = this._$1988.write(audioBuf, 0, audioBuf.length);
                    this._$2017();
                }
                if (bytesRead != -1) continue;
                this._$1988.drain();
                this._$451 = null;
            }
        }
        catch (Exception ex) {
            this._$505(ex.getMessage());
        }
        if (bytesRead != -1) {
            this._$1988.flush();
        }
        this._$511();
        if (bytesRead == -1) {
            this._$453(FINISHED);
        } else {
            this._$453(STOPPED);
        }
    }

    public synchronized void setFileName(String fileName) throws Exception {
        if (fileName == null) {
            this._$474 = null;
            return;
        }
        if (!FileUtils.hasSuffix(fileName, "wvs")) {
            fileName = FileUtils.appendSuffix(fileName, "wvs");
        }
        this._$474 = fileName;
    }

    private void _$453(int state) {
        this._$447 = state;
        this._$454(state);
    }

    public void setVolume(int percent) {
        SourceDataLine line = this._$1988;
        if (line == null) {
            return;
        }
        FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
        if (gainControl != null) {
            float value = (float)percent / 100.0f;
            float dB = (float)(Math.log((double)value == 0.0 ? 1.0E-4 : (double)value) / Math.log(10.0) * 20.0);
            gainControl.setValue(dB);
        }
    }

    public synchronized void start() {
        if (this._$451 != null) {
            this.stop();
        }
        this._$451 = new Thread(this);
        this._$451.setName("WaveSyncPlayer");
        this._$451.start();
    }

    public synchronized void stop() {
        this._$451 = null;
    }

    private int _$2011(double time) {
        return new Double(time * this._$1989).intValue();
    }
}

