/*
 * Decompiled with CFR 0.152.
 */
package pyware.pyMusicTools;

import java.util.Vector;

public class MusicConstants {
    public static int BIAS_FLAT;
    public static int BIAS_NEUTRAL;
    public static int BIAS_SHARP;
    public static int CLEF_ALTO;
    public static int CLEF_BASS;
    public static int CLEF_TENOR;
    public static int CLEF_TREBLE;
    public static int KEY_A;
    public static int KEY_Ab;
    public static int KEY_B;
    public static int KEY_Bb;
    public static int KEY_C;
    public static int KEY_CSharp;
    public static int KEY_Cb;
    public static int KEY_D;
    public static int KEY_Db;
    public static int KEY_E;
    public static int KEY_Eb;
    public static int KEY_F;
    public static int KEY_FSharp;
    public static int KEY_G;
    public static int KEY_Gb;
    public static int KEY_SolFeg;
    public static int TOTAL_BIAS_TYPES;
    public static int TOTAL_CLEFS;
    public static int TOTAL_KEYS;
    private static String _$387;
    private static String _$405;

    static {
        CLEF_TREBLE = 0;
        CLEF_ALTO = 1;
        CLEF_TENOR = 2;
        CLEF_BASS = 3;
        TOTAL_CLEFS = 4;
        _$387 = "Treble,Alto..,Tenor.,Bass..,";
        KEY_C = 0;
        KEY_CSharp = 1;
        KEY_Db = 2;
        KEY_D = 3;
        KEY_Eb = 4;
        KEY_E = 5;
        KEY_F = 6;
        KEY_FSharp = 7;
        KEY_Gb = 8;
        KEY_G = 9;
        KEY_Ab = 10;
        KEY_A = 11;
        KEY_Bb = 12;
        KEY_B = 13;
        KEY_Cb = 14;
        KEY_SolFeg = 15;
        TOTAL_KEYS = 16;
        _$405 = "C.,C#,Db,D.,Eb,E.,F.,F#,Gb,G.,Ab,A.,Bb,B.,Cb,So,";
        BIAS_SHARP = 0;
        BIAS_FLAT = 1;
        BIAS_NEUTRAL = 2;
        TOTAL_BIAS_TYPES = 3;
    }

    public static Vector getClefList() {
        Vector<String> list = new Vector<String>();
        int i2 = 0;
        while (i2 < TOTAL_CLEFS) {
            list.addElement(MusicConstants.toClefString(i2));
            ++i2;
        }
        return list;
    }

    public static int parseBiasString(String bias) {
        if (bias.toUpperCase().startsWith("FLAT")) {
            return BIAS_FLAT;
        }
        return BIAS_SHARP;
    }

    public static int parseClefString(String clefStr) {
        clefStr = clefStr.toUpperCase();
        int i2 = clefStr.length();
        while (i2 < 6) {
            clefStr = clefStr + '.';
            ++i2;
        }
        clefStr = clefStr + ',';
        int pos = _$387.toUpperCase().indexOf(clefStr);
        if (pos == -1) {
            return 0;
        }
        return pos / 7;
    }

    public static int parseKeyString(String keyStr) {
        if ((keyStr = keyStr.substring(0, 2).toUpperCase()).length() == 1) {
            keyStr = keyStr + '.';
        }
        keyStr = keyStr + ',';
        int pos = _$405.toUpperCase().indexOf(keyStr);
        if (pos == -1) {
            return 0;
        }
        return pos / 3;
    }

    public String toBiasString(int bias) {
        if (bias == BIAS_FLAT) {
            return "Flat";
        }
        if (bias == BIAS_SHARP) {
            return "Sharp";
        }
        return "";
    }

    public static String toClefString(int clef) {
        int pos = clef * 7;
        return _$387.substring(pos, pos + 6).replace('.', ' ').trim();
    }
}

