/*
 * Decompiled with CFR 0.152.
 */
package pymo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pymo.dataBases.DataBase;
import pymo.dataBases.DataBaseEvent;
import pymo.dataBases.DataBaseListener;
import pymo.dataBases.DataBaseManager;
import pymo.io.AutoOpener;
import pymo.menus.MOMenuBar;
import pymo.menus.MOMenuToolBar;
import pymo.panels.LibraryRecordPanel;
import pymo.panels.MOControlPanel;
import pymo.panels.MOPanel;
import pymo.panels.MOTablePanel;
import pymo.panels.StudentRecordPanel;
import pymo.security.AboutDialog;
import pymo.security.Activator;
import pymo.security.ComputerChangedAfterInstall;
import pymo.security.Constants;
import pymo.security.FilePath;
import pymo.security.InstallValidater;
import pymo.security.License;
import pymo.security.Settings;
import pymo.security.Updater;
import pyware.iPasToolkit.interactive.IPasLibrarian;
import pyware.iPasToolkit.interactive.IPasLibrarianException;
import pyware.toolkit.AskForPassword;
import pyware.toolkit.Decoder;
import pyware.toolkit.FileUtils;
import pyware.toolkit.IniFile;
import pyware.toolkit.NewPassword;

public class MainFrame
extends JFrame {
    private Settings _$2752 = new Settings(FilePath.toSettingsFile(), FilePath.toInitialSettingsFile());
    private IPasLibrarian _$3981 = new IPasLibrarian(this);
    private DataBaseManager _$531 = new DataBaseManager(this, this._$2752, this._$3981);
    private JPanel _$3982;
    private JPanel _$3983 = new JPanel();
    private JLabel _$3984 = new JLabel();
    private MOMenuBar _$2669 = new MOMenuBar(this, this._$531);
    private MOMenuToolBar _$3985 = new MOMenuToolBar(this._$2669, this._$531);
    private JTabbedPane _$3986 = new JTabbedPane();
    private MOControlPanel _$3987 = new MOControlPanel(this._$531);
    private Border _$546;

    public MainFrame() {
        this.enableEvents(64L);
        try {
            this._$550();
            this.pack();
            new AboutDialog((Frame)this, this._$2752).show();
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this, e2.getMessage(), "Startup Error", 0);
            e2.printStackTrace();
        }
    }

    private void _$550() throws Exception {
        this._$546 = BorderFactory.createEmptyBorder(0, 10, 0, 10);
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(FilePath.toImages("appIcon.png")));
        this.setTitle(this._$2752.getApplicationName() + "      " + this._$2752.getLicensedToAndSN());
        this.enableEvents(16L);
        this.setJMenuBar(this._$2669);
        this._$3984.setBackground(Color.gray);
        this._$3984.setBorder(this._$546);
        this._$3984.setOpaque(true);
        this._$3984.setText(" ");
        this._$3986.setTabPlacement(3);
        this._$3986.setBackground(Color.gray);
        this._$3986.setOpaque(true);
        this._$3983.setLayout(new BorderLayout());
        this._$3983.setSize(new Dimension(100, 100));
        this._$3987.setPreferredSize(new Dimension(0, 42));
        this._$3987.setSize(new Dimension(50, 50));
        this._$3983.add((Component)this._$3985, "North");
        this._$3983.add((Component)this._$3987, "South");
        this._$3982 = (JPanel)this.getContentPane();
        this._$3982.setOpaque(true);
        this._$3982.setLayout(new BorderLayout());
        this._$3982.add((Component)this._$3986, "Center");
        this._$3982.add((Component)this._$3984, "South");
        this._$3982.add((Component)this._$3983, "North");
        this._$3986.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                MainFrame.this._$3997(e2);
            }
        });
    }

    private void _$2856() {
        this._$531.addListener(new DataBaseListener(){

            public void dbOpened(DataBaseEvent e2) {
                MainFrame.this._$3998(e2);
            }

            public void dbClosing(DataBaseEvent e2) {
                MainFrame.this._$4000(e2);
            }

            public void dbTitleChanged(DataBaseEvent e2) {
                MainFrame.this._$4001(e2);
            }

            public void dbStatusInfoChanged(DataBaseEvent e2) {
                MainFrame.this._$4003(e2);
            }
        });
    }

    private void _$600() {
        new File(Constants.LOCAL_DATA_FILES_DIR).mkdir();
        new File(Constants.ONLINE_UPDATE_PATH).mkdir();
        File[] list = new File(Constants.ONLINE_UPDATE_PATH).listFiles();
        if (list != null) {
            for (int i2 = 0; i2 < list.length; ++i2) {
                list[i2].delete();
            }
        }
        new AutoOpener(this, this._$531).openDataFiles();
        this._$3981.setOnlineAccountDir(this._$2752.getHomeAccount());
        new Updater((Frame)this, this._$531).showIfDue();
    }

    private void _$4005() {
        try {
            this._$3981.initialize(new IniFile(Constants.FTP_PARAMETERS_FILE_PATH), "FTP", this._$2752, new Decoder());
            this._$3981.setWorkingOffline(!this._$2752.isRemoteFTPAccessEnabled());
            if (Constants.OVERRIDE_SECURITY) {
                this._$3981.setTraceLevel(IPasLibrarian.TRACE_VERBOSE);
            }
        }
        catch (IPasLibrarianException ex2) {
            JOptionPane.showMessageDialog(this, "Problem initializing program.\n" + ex2, "Program Startup", 0);
            System.exit(0);
        }
    }

    private boolean _$4008() {
        if (this._$2752.isMacintosh()) {
            if (FileUtils.isValid(Constants.CD_MAC_VOLUME_NAME + Constants.CD_IDENTIFIER)) {
                return true;
            }
            if (FileUtils.isValid(Constants.CDKEY_MAC_VOLUME_NAME + Constants.CD_IDENTIFIER)) {
                return true;
            }
        } else {
            StringBuffer path = new StringBuffer("C:/" + Constants.CD_IDENTIFIER);
            StringBuffer drives = new StringBuffer("CDEFGHIJKLMNOPQRSTUVWXYZ");
            for (int i2 = 0; i2 < drives.length(); ++i2) {
                path.setCharAt(0, drives.charAt(i2));
                if (!FileUtils.isValid(path.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public void encodeConnectionSettings(IniFile iniFile) {
        Decoder decoder = new Decoder();
        String host = iniFile.getLine("FTP", "H", "*");
        String user = iniFile.getLine("FTP", "U", "*");
        String pwd = iniFile.getLine("FTP", "P", "*");
        String root = iniFile.getLine("FTP", "R", "*");
        if (!host.startsWith("*")) {
            iniFile.setLine("FTP", "H", decoder.encodeStr(host));
        }
        if (!user.startsWith("*")) {
            iniFile.setLine("FTP", "U", decoder.encodeStr(user));
        }
        if (!pwd.startsWith("*")) {
            iniFile.setLine("FTP", "P", decoder.encodeStr(pwd));
        }
        if (!root.startsWith("*")) {
            iniFile.setLine("FTP", "R", decoder.encodeStr(root));
        }
        host = iniFile.getLine("HEAD", "H", "*");
        user = iniFile.getLine("HEAD", "U", "*");
        pwd = iniFile.getLine("HEAD", "P", "*");
        root = iniFile.getLine("HEAD", "R", "*");
        if (!host.startsWith("*")) {
            iniFile.setLine("HEAD", "H", decoder.encodeStr(host));
        }
        if (!user.startsWith("*")) {
            iniFile.setLine("HEAD", "U", decoder.encodeStr(user));
        }
        if (!pwd.startsWith("*")) {
            iniFile.setLine("HEAD", "P", decoder.encodeStr(pwd));
        }
        if (!root.startsWith("*")) {
            iniFile.setLine("HEAD", "R", decoder.encodeStr(root));
        }
        host = iniFile.getLine("MAIL", "H", "*");
        user = iniFile.getLine("MAIL", "U", "*");
        pwd = iniFile.getLine("MAIL", "P", "*");
        root = iniFile.getLine("MAIL", "C", "*");
        if (!host.startsWith("*")) {
            iniFile.setLine("MAIL", "H", decoder.encodeStr(host));
        }
        if (!user.startsWith("*")) {
            iniFile.setLine("MAIL", "U", decoder.encodeStr(user));
        }
        if (!pwd.startsWith("*")) {
            iniFile.setLine("MAIL", "P", decoder.encodeStr(pwd));
        }
        if (!root.startsWith("*")) {
            iniFile.setLine("MAIL", "C", decoder.encodeStr(root));
        }
        try {
            iniFile.save();
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
    }

    private void _$2750() {
        License license;
        if (!new AskForPassword((Frame)this, this._$2752, this._$2752.getApplicationName(), "Enter the password to begin.").verify()) {
            System.exit(0);
        }
        if (Constants.OVERRIDE_SECURITY) {
            if (Constants.CREATE_A_DDATE == 0) {
                this._$2752.setLine("Licensing", "DDate", "");
            } else {
                this._$2752.advanceDDate(Constants.CREATE_A_DDATE);
            }
            this._$2752.setLicenseValid();
            this._$2752.trySave();
            JOptionPane.showMessageDialog(this, "License security is overridden.");
        }
        if (!this._$2752.isLicenseValid()) {
            JOptionPane.showMessageDialog(this, "Secured information appears to have been altered.");
            System.exit(0);
        }
        if (!this._$2752.isInstallDateSet() && !(license = new License(this)).accepted()) {
            System.exit(0);
        }
        if (!this._$2752.isComputerIDValid()) {
            ComputerChangedAfterInstall reencrypt = new ComputerChangedAfterInstall((Frame)this, this._$2752);
            reencrypt.show();
            if (!reencrypt.isEncrypted()) {
                this._$2752.setAllRestrictions(true);
            }
        }
        if (!this._$2752.isInstallDateSet()) {
            if (this._$2752.isSecuritySet(Settings.REQUIRED_CD_TO_INSTALL) && !this._$4008()) {
                JOptionPane.showMessageDialog(this, this._$2752.getApplicationName() + " needs the original installer CD in the drive to install properly.");
                System.exit(0);
            }
        }
        if (this._$2752.isSecuritySet(Settings.REQUIRED_CD_TO_RUN) && !this._$4008()) {
            JOptionPane.showMessageDialog(this, this._$2752.getApplicationName() + " needs the original installer CD in the drive to run.");
            System.exit(0);
        }
        if (!this._$2752.isInstallDateSet() && new Activator((Frame)this, this._$2752).requestActivation()) {
            this._$4005();
            new NewPassword((Frame)this, this._$2752).show();
        }
        if (Constants.FORCE_DEMO_MODE) {
            this._$2752.setAllRestrictions(true);
        }
        if (this._$2752.isInstallBlocked()) {
            this._$2752.setAllRestrictions(true);
            JOptionPane.showMessageDialog(this, "This installation of " + this._$2752.getApplicationName() + " has been deactivated." + '\n' + this._$2752.getBlockDescription() + '\n' + '\n' + this._$2752.getApplicationName() + " will operate with restricted access.", "Software Validation", 0);
        }
        if (!this._$2752.isAnyRestrictionSet()) {
            new InstallValidater(this, this._$3981, this._$2752).validate();
        }
        this._$2752.createVersionFile();
    }

    protected void processWindowEvent(WindowEvent e2) {
        if (e2.getID() == 200) {
            super.processWindowEvent(e2);
            this._$4005();
            this._$2750();
            this._$2856();
            this._$600();
        } else if (e2.getID() == 201) {
            this._$2669.getFileMenu().exit();
        }
    }

    private void _$3997(ChangeEvent e2) {
        Component component = this._$3986.getSelectedComponent();
        if (component != null && MOPanel.class.isInstance(component)) {
            this._$531.setFrontDataBase(((MOPanel)component).getOwnerDataBase());
        }
    }

    private void _$4001(DataBaseEvent e2) {
        DataBase db = e2.getDataBase();
        if (!db.isVisible()) {
            return;
        }
        MOTablePanel panel = db.getPanelManager().getMainTablePanel();
        int index = this._$3986.indexOfComponent(panel);
        if (index != -1) {
            this._$3986.setTitleAt(index, db.getHeader().getTitle());
        }
    }

    private void _$3998(DataBaseEvent e2) {
        DataBase db = e2.getDataBase();
        if (!db.isVisible()) {
            return;
        }
        this._$3986.addTab(db.getHeader().getTitle(), db.getPanelManager().getMainTablePanel());
        this._$3986.setSelectedIndex(this._$531.indexOf(db));
        if (db.getHeader().getFileType() == Constants.STUDENT_FILE_TYPE) {
            db.getPanelManager().addPanel(new StudentRecordPanel(this, db));
        } else if (db.getHeader().getFileType() == Constants.MUSIC_LIBRARY_FILE_TYPE) {
            db.getPanelManager().addPanel(new LibraryRecordPanel(this, db));
        } else {
            JOptionPane.showMessageDialog(this, db.getHeader().getTitle() + " is an unknown database type.", "Database Manager", 0);
        }
    }

    private void _$4000(DataBaseEvent e2) {
        MOTablePanel mainTablePanel = e2.getDataBase().getPanelManager().getMainTablePanel();
        int index = this._$3986.indexOfComponent(mainTablePanel);
        if (index != -1) {
            this._$3986.removeTabAt(index);
        }
    }

    private void _$4003(DataBaseEvent e2) {
        this._$3984.setText(e2.title);
    }
}

