/*
 * Decompiled with CFR 0.152.
 */
package pymo.dataBases;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;
import pymo.dataBases.DataBaseManager;
import pymo.descriptors.AbstractFieldDescriptor;
import pymo.descriptors.DescriptorList;
import pymo.descriptors.DescriptorReader;
import pymo.descriptors.IPasDescriptor;
import pymo.io.MOFileHeader;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;
import pymo.panels.PanelManager;
import pymo.records.MasterList;
import pymo.records.Record;
import pymo.records.RecordDialog;
import pymo.records.RecordEvent;
import pymo.records.RecordList;
import pymo.records.RecordListener;
import pymo.records.RecordManager;
import pymo.records.RecordReader;
import pymo.security.Constants;
import pymo.security.FilePath;

public class DataBase {
    public static boolean VISIBLE = true;
    public static boolean INVISIBLE = false;
    private static String _$8609 = "Untitled" + Constants.DATA_FILE_SUFFIX;
    private String _$1611 = _$8609;
    private MOFileReader _$1613 = null;
    private MOFileWriter _$2383 = null;
    private MOFileHeader _$1617 = null;
    private DescriptorList _$8076 = null;
    private MasterList _$6752 = null;
    private RecordList _$2873 = null;
    private RecordManager _$8610 = null;
    private PanelManager _$8611 = null;
    private DataBaseManager _$531 = null;
    private int _$8612 = 0;
    private boolean _$5457 = true;
    private boolean _$8613 = false;

    public DataBase(DataBaseManager dbManager, String fileName, boolean visible) throws IOException {
        this._$531 = dbManager;
        this._$5457 = visible;
        this._$1613 = new MOFileReader(fileName);
        this._$2383 = new MOFileWriter(fileName, MOFileWriter.OPEN);
        this._$8610 = new RecordManager(this, this._$1613, this._$2383);
        this._$1617 = new MOFileHeader(this._$1613);
        if (fileName.toLowerCase().endsWith(".tpt")) {
            this._$1617.setFileID(System.currentTimeMillis());
        }
        this.loadDescriptors();
        RecordReader recordReader = new RecordReader(this._$8610);
        this._$6752 = recordReader.createMasterList();
        this._$8612 = recordReader.getPercentEmpty();
        recordReader = null;
        this._$2873 = this._$8610.createRecordList(this._$6752);
        this._$8611 = new PanelManager(dbManager.getMainFrame(), this);
        this._$1611 = fileName;
        this._$6752.addListener(new RecordListener(){

            public void recordAdded(RecordEvent e2) {
                DataBase.this._$8621(e2);
            }
        });
        this._$6752.addListener(new RecordListener(){

            public void recordDeleted(RecordEvent e2) {
                DataBase.this._$2881(e2);
            }
        });
        this._$6752.addListener(new RecordListener(){

            public void recordChanged(RecordEvent e2) {
                DataBase.this._$2879(e2);
            }
        });
        this._$2873.addListener(new RecordListener(){

            public void recordAdded(RecordEvent e2) {
                DataBase.this._$8624(e2);
            }
        });
        this._$2873.addListener(new RecordListener(){

            public void recordDeleted(RecordEvent e2) {
                DataBase.this._$8624(e2);
            }
        });
        this._$2873.addListener(new RecordListener(){

            public void listChanged(RecordEvent e2) {
                DataBase.this._$8624(e2);
            }
        });
    }

    public void setReadOnly(boolean readOnly) {
        this._$8613 = readOnly;
    }

    public boolean isReadOnly() {
        return this._$8613;
    }

    public void loadDescriptors() throws IOException {
        this._$8076 = new DescriptorReader(this._$1613, this).readList();
    }

    public MOFileHeader getHeader() {
        return this._$1617;
    }

    public DataBaseManager getDataBaseManager() {
        return this._$531;
    }

    public RecordManager getRecordManager() {
        return this._$8610;
    }

    public RecordList getSelectedRecords() {
        return this._$2873;
    }

    public boolean isSelectedIndexValid(int index) {
        return this._$2873.indexValid(index);
    }

    public RecordList getRecords() {
        return this._$6752;
    }

    public void setTitle(String title) {
        this._$1617.setTitle(title);
        this._$531.dispatchDataBaseTitleChanged(this, title);
    }

    public void setFileID(long id) {
        this._$1617.setFileID(id);
    }

    public int getEmptySpace() {
        return this._$8612;
    }

    public void setSelectedRecords(RecordList recordList) {
        this._$2873.setList(recordList);
        this._$531.dispatchDataBaseSelectionChanged(this);
    }

    public void resetSelectedRecords() {
        this._$2873.setList(this._$6752);
        this._$531.dispatchDataBaseSelectionChanged(this);
    }

    public PanelManager getPanelManager() {
        return this._$8611;
    }

    public DescriptorList getDescriptors() {
        return this._$8076;
    }

    public String getFullFileName() {
        return this._$2383.getFileName();
    }

    public String getFileName() {
        return FilePath.extractFileName(this.getFullFileName());
    }

    public boolean needsSaving() {
        if (this._$1617.needsSaving()) {
            return true;
        }
        if (this._$8610.needsSaving()) {
            return true;
        }
        return this._$8076.needsSaving();
    }

    public boolean isVisible() {
        return this._$5457;
    }

    public int getDBIndex() {
        return this._$531.indexOf(this);
    }

    public int getTotalRecords() {
        return this._$6752.getRecordCount();
    }

    public int getTotalSelectedRecords() {
        return this._$2873.getRecordCount();
    }

    public long getHighlightedRowID() {
        int index = this._$8611.getMainTablePanel().getHighlightedRowIndex();
        return index == -1 ? -1L : this._$2873.idAt(index);
    }

    public boolean checkIntegrity(Frame mainFrame) {
        try {
            this._$6752.checkIntegrity();
            this._$2873.checkIntegrity();
            this._$6752.verifyValidFields(this._$8076.getFieldIndexes());
            this._$8076.renumberFieldIndexes();
            IPasDescriptor ipas = null;
            ipas = (IPasDescriptor)this._$8076.getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE);
            if (ipas != null) {
                ipas.buildStudentIDs(this);
            }
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(mainFrame, e2, "Data Integrity Problem", 0);
            return false;
        }
        return true;
    }

    public void close() throws IOException {
        this.save();
        this._$1613.close();
        this._$2383.close();
        this._$531.dispatchDataBaseClosed(this);
    }

    public void save() throws IOException {
        this._$8611.stopEditing();
        this._$1617.save(this._$2383);
        this._$8076.save(this._$2383);
        this._$8610.saveRecords();
        this._$531.dispatchDataBaseSaved(this);
    }

    public void saveAs(String newFileName) throws IOException {
        this.save();
        MOFileWriter tempFileWriter = new MOFileWriter(Constants.SAFE_SAVE_FILE_NAME, MOFileWriter.RESET);
        this._$1617.create(tempFileWriter);
        this._$8076.appendTo(tempFileWriter);
        this._$6752.appendTo(tempFileWriter);
        tempFileWriter.close();
        this._$1613.close();
        this._$2383.close();
        newFileName = FilePath.appendSuffix(newFileName, Constants.DATA_FILE_SUFFIX);
        File tempFile = new File(Constants.SAFE_SAVE_FILE_NAME);
        File actualFile = new File(newFileName);
        if (actualFile.exists()) {
            actualFile.delete();
        }
        tempFile.renameTo(actualFile);
        this._$1613.open(newFileName);
        this._$2383.open(newFileName, MOFileWriter.OPEN);
        RecordReader recordReader = new RecordReader(this._$8610);
        recordReader.readList(this._$6752);
        this._$2873.setList(this._$6752);
        this._$8612 = recordReader.getPercentEmpty();
        this._$1611 = newFileName;
        this._$531.dispatchDataBaseSaved(this);
    }

    public void backup(String backupFileName) throws IOException {
        this.save();
        MOFileWriter backupWriter = new MOFileWriter(backupFileName, MOFileWriter.RESET);
        this._$1617.create(backupWriter);
        this._$8076.appendTo(backupWriter);
        this._$6752.appendTo(backupWriter);
        backupWriter.close();
    }

    private void _$8649(Record record) throws IOException {
        int recordIndex = this._$6752.indexOf(record);
        AbstractFieldDescriptor[] fieldDescriptors = this._$8076.getFieldDescriptorList();
        for (int i2 = 0; i2 < fieldDescriptors.length; ++i2) {
            AbstractFieldDescriptor descriptor = fieldDescriptors[i2];
            Object wrapper = descriptor.getInitialValue();
            this._$6752.putField(recordIndex, descriptor.getFieldIndex(), descriptor.toField(wrapper));
        }
    }

    public long newRecord() throws IOException {
        this._$8611.stopEditing();
        Record record = new Record();
        this._$6752.addRecord(record);
        this._$2873.addRecord(record);
        this._$8610.open(record);
        this._$8649(record);
        this._$8610.save(record);
        return record.getRecordID();
    }

    public int newRecord(long id) throws IOException {
        this._$8611.stopEditing();
        Record record = new Record(id);
        this._$6752.addRecord(record);
        this._$2873.addRecord(record);
        this._$8610.open(record);
        this._$8610.save(record);
        return this._$2873.size() - 1;
    }

    public void editNewRecord(Frame mainFrame, long id) throws IOException {
        this._$8611.stopEditing();
        RecordDialog rd = this._$8611.createRecordDialog(mainFrame, RecordDialog.NEW_RECORD);
        rd.show(this._$2873.indexOf(id));
    }

    public void editRecord(Frame mainFrame, long id) throws IOException {
        this._$8611.stopEditing();
        RecordDialog rd = this._$8611.createRecordDialog(mainFrame, RecordDialog.EDIT_RECORD);
        rd.show(this._$2873.indexOf(id));
    }

    public void deleteRecord(long id) throws IOException {
        this._$6752.deleteRecord(id);
        this._$2873.deleteRecord(id);
    }

    public void deleteSelectedRecords() throws IOException {
        int numRecords = this._$2873.getRecordCount();
        for (int i2 = 0; i2 < numRecords; ++i2) {
            this.deleteRecord(this._$2873.idAt(0));
        }
    }

    public void deleteDescriptors(Vector deletionList) throws IOException {
        if (deletionList.size() == 0) {
            return;
        }
        this._$6752.verifyValidFields(this._$8076.getFieldIndexes());
        for (int i2 = 0; i2 < deletionList.size(); ++i2) {
            AbstractFieldDescriptor descriptor = (AbstractFieldDescriptor)deletionList.elementAt(i2);
            this._$8076.removeDescriptor(this._$2383, descriptor);
        }
        this._$8076.renumberFieldIndexes();
    }

    private void _$8621(RecordEvent e2) {
        this._$531.dispatchDataBaseRecordAdded(this, e2.getRecord(), e2.getRecordIndex());
    }

    private void _$2879(RecordEvent e2) {
        this._$531.dispatchDataBaseRecordChanged(this, e2.getRecord(), e2.getRecordIndex());
    }

    private void _$2881(RecordEvent e2) {
        this._$531.dispatchDataBaseRecordDeleted(this, e2.getRecord(), e2.getRecordIndex());
    }

    private void _$8624(RecordEvent e2) {
        this._$531.dispatchDataBaseSelectionChanged(this);
    }

    private void _$8664(RecordEvent e2) {
        this._$531.dispatchDataBaseRecordHighlighted(this, e2.getRecordIndex());
    }
}

