/*
 * Decompiled with CFR 0.152.
 */
package pymo.dataBases;

import java.awt.Frame;
import java.io.IOException;
import java.util.Vector;
import pymo.dataBases.DataBase;
import pymo.dataBases.DataBaseEvent;
import pymo.dataBases.DataBaseListener;
import pymo.iPasDBTools.IPasDBOrganizer;
import pymo.records.Record;
import pymo.security.FilePath;
import pymo.security.Settings;
import pyware.iPasToolkit.interactive.IPasLibrarian;

public class DataBaseManager {
    private Vector _$517 = new Vector();
    private Vector _$7407 = new Vector();
    private DataBase _$7532 = null;
    private Settings _$2752;
    private Frame _$483;
    private IPasLibrarian _$6591;
    private IPasDBOrganizer _$7533;

    public DataBaseManager(Frame frame, Settings settings, IPasLibrarian librarian) {
        this._$2752 = settings;
        this._$483 = frame;
        this._$6591 = librarian;
        this._$7533 = new IPasDBOrganizer(frame, this);
    }

    public DataBase dataBaseAt(int index) {
        return (DataBase)this._$517.elementAt(index);
    }

    public DataBase getDataBase(long id) {
        for (int i2 = 0; i2 < this._$517.size(); ++i2) {
            DataBase db = this.dataBaseAt(i2);
            if (db.getHeader().getDataBaseID() != id) continue;
            return db;
        }
        return null;
    }

    public DataBase getDataBase(String fileName) {
        fileName = FilePath.extractFileName(fileName);
        for (int i2 = 0; i2 < this._$517.size(); ++i2) {
            DataBase db = this.dataBaseAt(i2);
            String testFileName = db.getFileName();
            if (testFileName.compareToIgnoreCase(fileName) != 0) continue;
            return db;
        }
        return null;
    }

    public DataBase[] getDataBases() {
        int count = this.getDataBaseCount();
        DataBase[] dataBases = new DataBase[count];
        for (int i2 = 0; i2 < count; ++i2) {
            dataBases[i2] = this.dataBaseAt(i2);
        }
        return dataBases;
    }

    public DataBase openDataBase(String fileName) throws IOException {
        DataBase db = null;
        if (this.getDataBase(fileName) != null) {
            throw new IOException("Database " + fileName + " already opened.");
        }
        db = new DataBase(this, fileName, DataBase.VISIBLE);
        if (db != null) {
            DataBase existID = this.getDataBase(db.getHeader().getDataBaseID());
            if (existID != null) {
                throw new IOException("Database \"" + fileName + "\" could not be opened.\n\n" + "You are attempting to open two databases that have the same database ID.\n" + "1) " + existID.getHeader().getTitle() + "  (File: " + existID.getFileName() + ")\n" + "2) " + db.getHeader().getTitle() + "  (File: " + db.getFileName() + ")");
            }
            db.checkIntegrity(this._$483);
            this._$517.addElement(db);
            this._$7538(db);
        }
        return db;
    }

    public void closeDataBase(DataBase db) throws IOException {
        if (db == null) {
            return;
        }
        int index = this.indexOf(db);
        if (index == -1) {
            return;
        }
        this._$7540(db);
        this._$517.removeElementAt(index);
        db.close();
        if (this.getDataBaseCount() == 0) {
            this._$7532 = null;
        }
    }

    public void saveAllDataBases() throws IOException {
        for (int i2 = 0; i2 < this.getDataBaseCount(); ++i2) {
            DataBase dataBase = this.dataBaseAt(i2);
            if (!dataBase.needsSaving()) continue;
            dataBase.save();
        }
    }

    public void closeAllDataBases() throws IOException {
        for (int i2 = this.getDataBaseCount() - 1; i2 >= 0; --i2) {
            this.closeDataBase(this.dataBaseAt(i2));
        }
    }

    public int getDataBaseCount() {
        return this._$517.size();
    }

    public int indexOf(DataBase dataBase) {
        return this._$517.indexOf(dataBase);
    }

    public void setFrontDataBase(DataBase dataBase) {
        this._$7532 = dataBase;
        this._$7541(dataBase);
    }

    public DataBase getFrontDataBase() {
        return this._$7532;
    }

    public boolean anyFilesUnsaved() {
        for (int i2 = 0; i2 < this._$517.size(); ++i2) {
            if (!this.dataBaseAt(i2).needsSaving()) continue;
            return true;
        }
        return false;
    }

    public Settings getSettings() {
        return this._$2752;
    }

    public Frame getMainFrame() {
        return this._$483;
    }

    public IPasLibrarian getIPasLibrarian() {
        return this._$6591;
    }

    public IPasDBOrganizer getIPasDBOrganizer() {
        return this._$7533;
    }

    public synchronized void addListener(DataBaseListener listener) {
        this._$7407.addElement(listener);
    }

    public synchronized void removeListener(DataBaseListener listener) {
        this._$7407.removeElement(listener);
    }

    private void _$7538(DataBase db) {
        DataBaseEvent e2 = new DataBaseEvent(db);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((DataBaseListener)this._$7407.elementAt(i2)).dbOpened(e2);
        }
    }

    private void _$7540(DataBase db) {
        DataBaseEvent e2 = new DataBaseEvent(db);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((DataBaseListener)this._$7407.elementAt(i2)).dbClosing(e2);
        }
    }

    public void dispatchDataBaseClosed(DataBase db) {
        DataBaseEvent e2 = new DataBaseEvent(db);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((DataBaseListener)this._$7407.elementAt(i2)).dbClosed(e2);
        }
    }

    private void _$7541(DataBase db) {
        DataBaseEvent e2 = new DataBaseEvent(db);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((DataBaseListener)this._$7407.elementAt(i2)).dbBroughtForward(e2);
        }
    }

    public void dispatchDataBaseSaved(DataBase db) {
        DataBaseEvent e2 = new DataBaseEvent(db);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((DataBaseListener)this._$7407.elementAt(i2)).dbSaved(e2);
        }
    }

    public void dispatchDataBaseSelectionChanged(DataBase db) {
        DataBaseEvent e2 = new DataBaseEvent(db);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((DataBaseListener)this._$7407.elementAt(i2)).dbSelectionChanged(e2);
        }
    }

    public void dispatchDataBaseRecordAdded(DataBase db, Record record, int recordIndex) {
        DataBaseEvent e2 = new DataBaseEvent(db, record, recordIndex);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((DataBaseListener)this._$7407.elementAt(i2)).dbRecordAdded(e2);
        }
    }

    public void dispatchDataBaseRecordDeleted(DataBase db, Record record, int recordIndex) {
        DataBaseEvent e2 = new DataBaseEvent(db, record, recordIndex);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((DataBaseListener)this._$7407.elementAt(i2)).dbRecordDeleted(e2);
        }
    }

    public void dispatchDataBaseRecordChanged(DataBase db, Record record, int recordIndex) {
        DataBaseEvent e2 = new DataBaseEvent(db, record, recordIndex);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((DataBaseListener)this._$7407.elementAt(i2)).dbRecordChanged(e2);
        }
    }

    public void dispatchDataBaseRecordHighlighted(DataBase db, int recordIndex) {
        DataBaseEvent e2 = new DataBaseEvent(db, recordIndex);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((DataBaseListener)this._$7407.elementAt(i2)).dbRecordHighlighted(e2);
        }
    }

    public void dispatchDataBaseTitleChanged(DataBase db, String title) {
        DataBaseEvent e2 = new DataBaseEvent(db, title);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((DataBaseListener)this._$7407.elementAt(i2)).dbTitleChanged(e2);
        }
    }

    public void dispatchDataBaseStatusInfoChanged(DataBase db, String msg) {
        DataBaseEvent e2 = new DataBaseEvent(db, msg);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((DataBaseListener)this._$7407.elementAt(i2)).dbStatusInfoChanged(e2);
        }
    }
}

