/*
 * Decompiled with CFR 0.152.
 */
package pymo.descriptors;

import java.io.IOException;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jbc.grid.JbcCellEditorBoolean;
import jbc.grid.JbcCellRendererBoolean;
import pymo.components.MOCheckBox;
import pymo.components.MOComponent;
import pymo.descriptors.AbstractFieldDescriptor;
import pymo.fields.Field;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;
import pymo.security.Constants;

public class CheckBoxDescriptor
extends AbstractFieldDescriptor {
    public static String CHECKBOX_DESCRIPTOR_SIGNATURE = "dCHK";
    private static int _$20180 = 1;
    private boolean _$10383 = false;

    public CheckBoxDescriptor() {
    }

    public CheckBoxDescriptor(MOFileReader reader) throws IOException {
        this.read(reader);
    }

    public CheckBoxDescriptor(MOFileReader reader, long dID) throws IOException {
        this.setID(dID);
        this.read(reader);
    }

    public void readUniqueData(MOFileReader reader) throws IOException {
        super.readUniqueData(reader);
        int val = reader.readByte();
        this._$10383 = val != 0;
    }

    public void writeUniqueData(MOFileWriter writer) throws IOException {
        super.writeUniqueData(writer);
        int val = 0;
        if (this._$10383) {
            val = 1;
        }
        writer.writeByte(val);
    }

    public int getVersion() {
        return _$20180;
    }

    public String getSignature() {
        return CHECKBOX_DESCRIPTOR_SIGNATURE;
    }

    public int getSearchType() {
        return Constants.BOOLEAN_SEARCH;
    }

    public int compare(int modifier, Field field1, Field field2) {
        return this.compare(field1, field2);
    }

    public int compare(Field field1, Field field2) {
        boolean val2;
        boolean val1 = this.toBoolean(field1);
        if (val1 == (val2 = this.toBoolean(field2))) {
            return 0;
        }
        if (!val1 && val2) {
            return -1;
        }
        return 1;
    }

    public int getSize() {
        return 1 + super.getSize();
    }

    public void setInitialValue(Object initialValue) {
        this._$10383 = (Boolean)initialValue;
        this.setChanged();
    }

    public Object getInitialValue() {
        return new Boolean(this._$10383);
    }

    public String toString(Field field) {
        if (field.isEmpty()) {
            return "not checked";
        }
        if (field.getData()[0] == 0) {
            return "not checked";
        }
        return "checked";
    }

    public boolean toBoolean(Field field) {
        if (field.isEmpty()) {
            return false;
        }
        return field.getData()[0] != 0;
    }

    public Object toWrapper(Field field) {
        return new Boolean(this.toBoolean(field));
    }

    public Field toField(Object object) {
        byte[] data = new byte[]{(Boolean)object != false ? (byte)1 : 0};
        return new Field(data);
    }

    public MOComponent makePanelComponent() {
        MOCheckBox aComponent = new MOCheckBox(this);
        aComponent.setBounds(this.getBounds());
        return aComponent;
    }

    public TableCellEditor makeCellEditor() {
        return new JbcCellEditorBoolean();
    }

    public TableCellRenderer makeCellRenderer() {
        return new JbcCellRendererBoolean();
    }
}

