/*
 * Decompiled with CFR 0.152.
 */
package pymo.descriptors;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import pymo.components.MOComponent;
import pymo.components.MODateBox;
import pymo.descriptors.AbstractFieldDescriptor;
import pymo.fields.Field;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;
import pymo.security.Constants;
import pymo.tableCellEditors.DateCellEditor;
import pymo.tableCellEditors.DateField;
import pymo.tableCellEditors.MODateCellRenderer;
import pyware.toolkit.Utils;

public class DateDescriptor
extends AbstractFieldDescriptor {
    public static String DATE_DESCRIPTOR_SIGNATURE = "dDAT";
    public static long EMPTY_DATE_VALUE = 253370786400000L;
    private static int _$20184 = 1;
    private long _$10383 = 0L;
    private DateFormat _$16095 = DateFormat.getDateInstance();
    private DateFormat _$20185 = DateFormat.getDateInstance(3);

    public DateDescriptor() {
    }

    public DateDescriptor(MOFileReader reader) throws IOException {
        this.read(reader);
    }

    public DateDescriptor(MOFileReader reader, long dID) throws IOException {
        this.setID(dID);
        this.read(reader);
    }

    public void readUniqueData(MOFileReader reader) throws IOException {
        super.readUniqueData(reader);
        this._$10383 = reader.readLong();
    }

    public void writeUniqueData(MOFileWriter writer) throws IOException {
        super.writeUniqueData(writer);
        writer.writeLong(this._$10383);
    }

    public int getVersion() {
        return _$20184;
    }

    public String getSignature() {
        return DATE_DESCRIPTOR_SIGNATURE;
    }

    public int getSize() {
        return 8 + super.getSize();
    }

    public String toString(Field field) {
        Date date = new Date(this._$20186(field.getData()));
        return this._$16095.format(date);
    }

    private long _$20186(byte[] data) {
        if (data.length != 8) {
            return EMPTY_DATE_VALUE;
        }
        return Utils.byteArrayToLongValue(data);
    }

    private Calendar _$20187(Field field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this._$20186(field.getData()));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public Object toWrapper(Field field) {
        return this._$20187(field);
    }

    public Field toField(Object object) {
        Calendar fieldCalendar = Calendar.getInstance();
        fieldCalendar.setTimeInMillis(0L);
        fieldCalendar.set(11, 0);
        fieldCalendar.set(12, 0);
        fieldCalendar.set(14, 0);
        if (String.class.isInstance(object)) {
            try {
                Date date = this._$20185.parse((String)object);
                fieldCalendar.setTimeInMillis(date.getTime());
            }
            catch (Exception e2) {
                return new Field();
            }
        } else {
            fieldCalendar.set(1, ((Calendar)object).get(1));
            fieldCalendar.set(2, ((Calendar)object).get(2));
            fieldCalendar.set(5, ((Calendar)object).get(5));
        }
        long time = fieldCalendar.getTimeInMillis();
        if (time == EMPTY_DATE_VALUE) {
            return new Field();
        }
        return new Field(Utils.longValueToByteArray(time));
    }

    public MOComponent makePanelComponent() {
        MODateBox component = new MODateBox(this);
        component.setBounds(this.getBounds());
        return component;
    }

    public TableCellEditor makeCellEditor() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(0L);
        return new DateCellEditor(new DateField(calendar, 8));
    }

    public TableCellRenderer makeCellRenderer() {
        return new MODateCellRenderer();
    }

    public int getSearchType() {
        return Constants.NUMERIC_SEARCH;
    }

    public int compare(Field field1, Field field2) {
        long time2;
        long time1 = this._$20186(field1.getData());
        if (time1 == (time2 = this._$20186(field2.getData()))) {
            return 0;
        }
        if (time1 < time2) {
            return -1;
        }
        return 1;
    }

    public void setInitialValue(Object calendar) {
        this._$10383 = calendar == null ? EMPTY_DATE_VALUE : ((Calendar)calendar).getTimeInMillis();
        this.setChanged();
    }

    public Object getInitialValue() {
        long value = this._$10383;
        if (value == 0L) {
            value = System.currentTimeMillis();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0);
        calendar.set(2, 0);
        calendar.set(5, 0);
        calendar.setTimeInMillis(value);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        return calendar;
    }
}

