/*
 * Decompiled with CFR 0.152.
 */
package pymo.descriptors;

import java.awt.Point;
import java.io.IOException;
import java.util.Vector;
import pymo.dataBases.DataBase;
import pymo.descriptors.AbstractDescriptor;
import pymo.descriptors.AbstractFieldDescriptor;
import pymo.io.MOFileWriter;

public class DescriptorList
extends Vector {
    private boolean _$6003 = false;
    private DataBase _$10050;

    public DescriptorList(DataBase db) {
        this._$10050 = db;
    }

    public void appendTo(MOFileWriter writer) throws IOException {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.descriptorAt(i2).appendTo(writer);
        }
        this._$6003 = true;
    }

    public void save(MOFileWriter writer) throws IOException {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            AbstractDescriptor descriptor = this.descriptorAt(i2);
            if (!descriptor.isChanged()) continue;
            descriptor.write(writer);
        }
        this._$6003 = false;
    }

    public boolean needsSaving() {
        if (this._$6003) {
            return true;
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!this.descriptorAt(i2).isChanged()) continue;
            return true;
        }
        return false;
    }

    public AbstractDescriptor descriptorAt(int index) {
        return (AbstractDescriptor)this.elementAt(index);
    }

    public void addDescriptor(AbstractDescriptor descriptor) {
        descriptor.setOwnerDataBase(this._$10050);
        this.addElement(descriptor);
        this._$6003 = true;
    }

    public void removeDescriptor(AbstractDescriptor descriptor) {
        this.removeElement(descriptor);
        this._$6003 = true;
    }

    public void removeDescriptor(MOFileWriter writer, AbstractDescriptor descriptor) throws IOException {
        this.removeDescriptor(descriptor);
        descriptor.delete(writer);
    }

    public AbstractDescriptor getDescriptor(String signature) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.descriptorAt(i2).getSignature().compareTo(signature) != 0) continue;
            return this.descriptorAt(i2);
        }
        return null;
    }

    public AbstractFieldDescriptor getDescriptorAt(Point location) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            AbstractFieldDescriptor fieldDescriptor;
            Point aLocation;
            AbstractDescriptor descriptor = this.descriptorAt(i2);
            if (!this.isFieldDescriptor(descriptor) || (aLocation = (fieldDescriptor = (AbstractFieldDescriptor)this.descriptorAt(i2)).getLocation()).getX() != location.getX() || aLocation.getY() != location.getY()) continue;
            return fieldDescriptor;
        }
        return null;
    }

    public AbstractDescriptor getNamedDescriptor(String descriptorName) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.descriptorAt(i2).getName().compareToIgnoreCase(descriptorName) != 0) continue;
            return this.descriptorAt(i2);
        }
        return null;
    }

    public AbstractFieldDescriptor getFieldDescriptor(String fieldName) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            AbstractDescriptor descriptor = this.descriptorAt(i2);
            if (!this.isFieldDescriptor(descriptor) || descriptor.getName().compareToIgnoreCase(fieldName) != 0) continue;
            return (AbstractFieldDescriptor)descriptor;
        }
        return null;
    }

    public AbstractFieldDescriptor[] getFieldDescriptorList() {
        Vector<AbstractDescriptor> list = new Vector<AbstractDescriptor>();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            AbstractDescriptor descriptor = this.descriptorAt(i2);
            if (!this.isFieldDescriptor(descriptor)) continue;
            list.add(descriptor);
        }
        Object[] result = new AbstractFieldDescriptor[list.size()];
        list.copyInto(result);
        return result;
    }

    public int getLastFieldIndex() {
        int lastIndex = -1;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            int thisIndex;
            AbstractDescriptor descriptor = this.descriptorAt(i2);
            if (!this.isFieldDescriptor(descriptor) || (thisIndex = ((AbstractFieldDescriptor)descriptor).getFieldIndex()) <= lastIndex) continue;
            lastIndex = thisIndex;
        }
        return lastIndex;
    }

    public AbstractDescriptor getDescriptor(long id) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.descriptorAt(i2).getID() != id) continue;
            return this.descriptorAt(i2);
        }
        return null;
    }

    public DataBase getOwnerDataBase() {
        return this._$10050;
    }

    public AbstractFieldDescriptor getFieldDescriptor(long id) {
        return (AbstractFieldDescriptor)this.getDescriptor(id);
    }

    public boolean isFieldDescriptor(AbstractDescriptor descriptor) {
        return AbstractFieldDescriptor.class.isInstance(descriptor);
    }

    public int[] getFieldIndexes() {
        AbstractFieldDescriptor[] list = this.getFieldDescriptorList();
        int[] result = new int[list.length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = list[i2].getFieldIndex();
        }
        return result;
    }

    public void renumberFieldIndexes() {
        int lastIndex = this.getLastFieldIndex();
        AbstractFieldDescriptor[] origList = this.getFieldDescriptorList();
        AbstractFieldDescriptor[] sortList = new AbstractFieldDescriptor[origList.length];
        int k2 = 0;
        for (int nextIndex = 0; nextIndex <= lastIndex; ++nextIndex) {
            for (int i2 = 0; i2 < origList.length; ++i2) {
                if (origList[i2].getFieldIndex() != nextIndex) continue;
                sortList[k2++] = origList[i2];
            }
        }
        for (int i3 = 0; i3 < sortList.length; ++i3) {
            sortList[i3].setFieldIndex(i3);
        }
    }
}

