/*
 * Decompiled with CFR 0.152.
 */
package pymo.descriptors;

import java.io.IOException;
import pymo.descriptors.AbstractDescriptor;
import pymo.descriptors.DescriptorList;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;

public class LabelDescriptor
extends AbstractDescriptor {
    public static String LABEL_DESCRIPTOR_SIGNATURE = "dLBL";
    private static int _$16437 = 2;
    public int rows = 10;
    public int columns = 3;
    public int lftMargin = 9;
    public int rhtMargin = 9;
    public int topMargin = 36;
    public int botMargin = 36;
    public int hGutter = 9;
    public int vGutter = 9;
    public String layout = "";
    public String fontName = "Dialog";
    public int fontSize = 12;
    public boolean fontBold = false;
    public boolean printBorder = false;

    public LabelDescriptor() {
    }

    public LabelDescriptor(MOFileReader reader) throws IOException {
        this.read(reader);
    }

    public LabelDescriptor(MOFileReader reader, long dID) throws IOException {
        this.setID(dID);
        this.read(reader);
    }

    public void readUniqueData(MOFileReader reader) throws IOException {
        if (this.getReadVersion() < 2) {
            return;
        }
        this.rows = reader.readShort();
        this.columns = reader.readShort();
        this.lftMargin = reader.readShort();
        this.rhtMargin = reader.readShort();
        this.topMargin = reader.readShort();
        this.botMargin = reader.readShort();
        this.hGutter = reader.readShort();
        this.vGutter = reader.readShort();
        this.layout = reader.readFixedString(256);
        this.fontName = reader.readFixedString(32);
        this.fontSize = reader.readByte();
        this.fontBold = reader.readByte() == 1;
    }

    public void writeUniqueData(MOFileWriter writer) throws IOException {
        writer.writeShort(new Integer(this.rows).shortValue());
        writer.writeShort(new Integer(this.columns).shortValue());
        writer.writeShort(new Integer(this.lftMargin).shortValue());
        writer.writeShort(new Integer(this.rhtMargin).shortValue());
        writer.writeShort(new Integer(this.topMargin).shortValue());
        writer.writeShort(new Integer(this.botMargin).shortValue());
        writer.writeShort(new Integer(this.hGutter).shortValue());
        writer.writeShort(new Integer(this.vGutter).shortValue());
        writer.writeFixedString(this.layout, 256);
        writer.writeFixedString(this.fontName, 32);
        writer.writeByte(this.fontSize);
        if (this.fontBold) {
            writer.writeByte(1);
        } else {
            writer.writeByte(0);
        }
    }

    public int getVersion() {
        return _$16437;
    }

    public String getSignature() {
        return LABEL_DESCRIPTOR_SIGNATURE;
    }

    public int getSize() {
        int len = super.getSize() + 306;
        return len;
    }

    public static LabelDescriptor aquire(DescriptorList descriptors) {
        LabelDescriptor descriptor = (LabelDescriptor)descriptors.getDescriptor(LABEL_DESCRIPTOR_SIGNATURE);
        if (descriptor == null) {
            descriptor = new LabelDescriptor();
            descriptors.addDescriptor(descriptor);
        }
        return descriptor;
    }
}

