/*
 * Decompiled with CFR 0.152.
 */
package pymo.descriptors;

import java.awt.Font;
import java.io.IOException;
import pymo.descriptors.AbstractDescriptor;
import pymo.descriptors.DescriptorList;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;

public class ListReportDescriptor
extends AbstractDescriptor {
    public static String LIST_REPORT_DESCRIPTOR_SIGNATURE = "dLRP";
    private static int _$20289 = 1;
    public String header = "";
    public String subHeader = "";
    public String footerLeft = "";
    public String footerRight = "";
    public boolean horzGrid = true;
    public boolean vertGrid = true;
    public Font font = new Font("Dialog", 0, 12);
    public int rowHeight = 16;

    public ListReportDescriptor() {
    }

    public ListReportDescriptor(MOFileReader reader) throws IOException {
        this.read(reader);
    }

    public ListReportDescriptor(MOFileReader reader, long dID) throws IOException {
        this.setID(dID);
        this.read(reader);
    }

    public void readUniqueData(MOFileReader reader) throws IOException {
        this.header = reader.readFixedString(64);
        this.subHeader = reader.readFixedString(64);
        this.footerLeft = reader.readFixedString(64);
        this.footerRight = reader.readFixedString(64);
        this.horzGrid = reader.readByte() == 1;
        this.vertGrid = reader.readByte() == 1;
        String fontName = reader.readFixedString(32);
        int fontStyle = reader.readInt();
        int fontSize = reader.readInt();
        this.font = new Font(fontName, fontStyle, fontSize);
        this.rowHeight = reader.readInt();
    }

    public void writeUniqueData(MOFileWriter writer) throws IOException {
        writer.writeFixedString(this.header, 64);
        writer.writeFixedString(this.subHeader, 64);
        writer.writeFixedString(this.footerLeft, 64);
        writer.writeFixedString(this.footerRight, 64);
        if (this.horzGrid) {
            writer.writeByte(1);
        } else {
            writer.writeByte(0);
        }
        if (this.vertGrid) {
            writer.writeByte(1);
        } else {
            writer.writeByte(0);
        }
        writer.writeFixedString(this.font.getName(), 32);
        writer.writeInt(this.font.getStyle());
        writer.writeInt(this.font.getSize());
        writer.writeInt(this.rowHeight);
    }

    public int getVersion() {
        return _$20289;
    }

    public String getSignature() {
        return LIST_REPORT_DESCRIPTOR_SIGNATURE;
    }

    public int getSize() {
        return super.getSize() + 64 + 64 + 64 + 64 + 1 + 1 + 32 + 4 + 4 + 4;
    }

    public static ListReportDescriptor aquire(DescriptorList descriptors) {
        ListReportDescriptor descriptor = (ListReportDescriptor)descriptors.getDescriptor(LIST_REPORT_DESCRIPTOR_SIGNATURE);
        if (descriptor == null) {
            descriptor = new ListReportDescriptor();
            descriptors.addDescriptor(descriptor);
        }
        return descriptor;
    }
}

