/*
 * Decompiled with CFR 0.152.
 */
package pymo.iPasDBTools;

import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import pymo.dataBases.DataBase;
import pymo.dataBases.DataBaseManager;
import pymo.descriptors.AbstractFieldDescriptor;
import pymo.descriptors.IPasDescriptor;
import pymo.descriptors.ListDescriptor;
import pymo.fields.Field;
import pymo.iPasDBTools.IPasMOStudentTable;
import pymo.iPasDBTools.reports.DuplicateIDReport;
import pymo.records.RecordList;
import pyware.iPasToolkit.interactive.AssignmentItem;
import pyware.iPasToolkit.interactive.IPasLibrarian;
import pyware.iPasToolkit.interactive.IPasStudentTableRow;
import pyware.iPasToolkit.interactive.StudentRosterItem;

public class IPasDBOrganizer {
    Frame frame;
    DataBaseManager dbm;
    IPasLibrarian librarian;
    DataBase[] dataBases;

    public IPasDBOrganizer(Frame frame, DataBaseManager dbm) {
        this.frame = frame;
        this.dbm = dbm;
        this.librarian = dbm.getIPasLibrarian();
        this.dataBases = this.getIPasDBList();
    }

    public boolean checkIntegrity() {
        try {
            this.dataBases = this.getIPasDBList();
            this.validateIDs();
            this.rebuildRoster();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            return false;
        }
        return this.checkForDuplicates();
    }

    public boolean isIPasDB(DataBase db) {
        return db.getDescriptors().getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE) != null;
    }

    public boolean canBeIPasDB(DataBase db) {
        AbstractFieldDescriptor nameLast;
        AbstractFieldDescriptor nameFirst = db.getDescriptors().getFieldDescriptor("~Name (First)");
        return !(nameFirst == null | (nameLast = db.getDescriptors().getFieldDescriptor("~Name (Last)")) == null);
    }

    public DataBase[] getIPasDBList() {
        Vector<DataBase> list = new Vector<DataBase>();
        int len = this.dbm.getDataBaseCount();
        for (int i2 = 0; i2 < len; ++i2) {
            DataBase db = this.dbm.dataBaseAt(i2);
            IPasDescriptor d2 = (IPasDescriptor)db.getDescriptors().getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE);
            if (d2 == null) continue;
            list.add(db);
        }
        DataBase[] result = new DataBase[list.size()];
        for (int i3 = 0; i3 < result.length; ++i3) {
            result[i3] = (DataBase)list.elementAt(i3);
        }
        return result;
    }

    public void validateIDs() throws Exception {
        for (int i2 = 0; i2 < this.dataBases.length; ++i2) {
            DataBase db = this.dataBases[i2];
            IPasDescriptor iPasDescriptor = (IPasDescriptor)db.getDescriptors().getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE);
            iPasDescriptor.buildStudentIDs(db);
        }
    }

    public void rebuildRoster() throws Exception {
        this.validateIDs();
        this.librarian.clearRoster();
        DataBase[] dbList = this.getIPasDBList();
        int totalDBs = dbList.length;
        for (int i2 = 0; i2 < totalDBs; ++i2) {
            DataBase db = dbList[i2];
            long dbID = db.getHeader().getDataBaseID();
            AbstractFieldDescriptor dFirstName = db.getDescriptors().getFieldDescriptor("~Name (First)");
            AbstractFieldDescriptor dLastName = db.getDescriptors().getFieldDescriptor("~Name (Last)");
            IPasDescriptor iPasDescriptor = (IPasDescriptor)db.getDescriptors().getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE);
            RecordList records = db.getRecords();
            int totalStudents = records.getRecordCount();
            for (int recordIndex = 0; recordIndex < totalStudents; ++recordIndex) {
                String firstName = dFirstName.toString(records.getField(recordIndex, dFirstName.getFieldIndex()));
                String lastName = dLastName.toString(records.getField(recordIndex, dLastName.getFieldIndex()));
                String studentID = iPasDescriptor.toString(records.getField(recordIndex, iPasDescriptor.getFieldIndex()));
                String password = iPasDescriptor.extractPassword(records.getField(recordIndex, iPasDescriptor.getFieldIndex()));
                this.librarian.addStudent(firstName, lastName, studentID, password, dbID);
            }
        }
    }

    public boolean removeDeadAssignmentResults(DataBase db) {
        try {
            RecordList records = db.getRecords();
            int totalStudents = records.getRecordCount();
            IPasDescriptor d2 = (IPasDescriptor)db.getDescriptors().getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE);
            if (d2 == null) {
                throw new Exception("Database does not have an iPAS field.");
            }
            int fieldIndex = d2.getFieldIndex();
            for (int recordIndex = 0; recordIndex < totalStudents; ++recordIndex) {
                Field field = records.getField(recordIndex, fieldIndex);
                IPasMOStudentTable table = (IPasMOStudentTable)d2.toWrapper(field);
                int len = table.getRowCount();
                boolean changed = false;
                for (int i2 = len - 1; i2 >= 0; --i2) {
                    boolean dead;
                    IPasStudentTableRow row = table.getRowAt(i2);
                    long lessonID = row.getLessonID();
                    AssignmentItem assignment = d2.findAssignment(lessonID);
                    boolean bl2 = dead = assignment == null;
                    if (!dead) {
                        boolean bl3 = dead = !assignment.assigned;
                        if (!dead && row.isCompleted() && row.getCompletionDate() < assignment.assignDate) {
                            dead = true;
                        }
                    }
                    if (!dead) continue;
                    table.removeRow(i2);
                    changed = true;
                }
                if (!changed) continue;
                field = d2.toField(table);
                records.putField(recordIndex, fieldIndex, field);
            }
            return true;
        }
        catch (Exception ex2) {
            JOptionPane.showMessageDialog(this.frame, "Problem cleaning up old assignments.\n\nError: " + ex2.getMessage(), "IPas Librarian", 0);
            return false;
        }
    }

    public boolean checkForDuplicates() {
        StudentRosterItem[] dups = this.librarian.getIPasIDDuplicates();
        if (dups.length == 0) {
            return true;
        }
        new DuplicateIDReport(this.frame, dups, this.dbm).show();
        return false;
    }

    public boolean configureForIPas(DataBase db, boolean ask) {
        int rslt;
        if (this.isIPasDB(db)) {
            return true;
        }
        if (!this.canBeIPasDB(db)) {
            JOptionPane.showMessageDialog(this.frame, "This database is not the correct type for setting up iPAS.");
            return false;
        }
        if (ask && (rslt = JOptionPane.showConfirmDialog(this.frame, "This database [" + db.getHeader().getTitle() + "] needs to be configured for use with iPAS.  Do you want to do that now?", "iPAS Database Manager", 0)) != 0) {
            return false;
        }
        IPasDescriptor iPasDescriptor = IPasDescriptor.aquire(db.getDescriptors());
        ListDescriptor listDescriptor = ListDescriptor.aquire(db.getDescriptors());
        listDescriptor.addField(iPasDescriptor.getID(), iPasDescriptor.getDefaultColumnWidth());
        try {
            iPasDescriptor.buildStudentIDs(db);
            db.getPanelManager().setupFields();
            db.save();
            JOptionPane.showMessageDialog(this.frame, db.getHeader().getTitle() + " has been configured and any student records currently\nin the database have been given unique iPAS ID's.\n\n" + "This and other iPAS information for each student is found under the\n" + "iPAS tab of the student record.  For convenience, a master list of IDs\n" + "and passwords can be printed through iPAS reports.");
            return true;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            return false;
        }
    }
}

