/*
 * Decompiled with CFR 0.152.
 */
package pymo.iPasDBTools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import pymo.descriptors.IPasDescriptor;
import pyware.iPasToolkit.interactive.AssignmentList;
import pyware.iPasToolkit.interactive.GradingScheme;
import pyware.iPasToolkit.interactive.IPasLibrarian;
import pyware.iPasToolkit.interactive.IPasStudentTable;
import pyware.iPasToolkit.interactive.IPasStudentTableRow;
import pyware.iPasToolkit.interactive.OnlineFileInfo;

public class IPasMainTableIcon
extends ImageIcon {
    IPasStudentTable data = null;
    Color backColor;
    int iconsPerPage = 0;
    int iconPageView = 0;
    IPasLibrarian librarian;
    AssignmentList assignments;

    public IPasMainTableIcon() {
    }

    public IPasMainTableIcon(IPasStudentTable data, IPasDescriptor descriptor, Color backColor, Rectangle r2) {
        this.data = data;
        this.iconPageView = descriptor.getIconViewPage();
        this.backColor = backColor;
        this.iconsPerPage = r2.width / 16 - 1;
        this.librarian = descriptor.getIPasFileLibrarian();
        this.assignments = descriptor.getAssignmentList();
    }

    private void _$22794(Graphics g2, int grade) {
        String gradeStr = grade == -1 ? "-" : grade + "";
        int xOffset = 0;
        if (gradeStr.length() == 1) {
            xOffset = 2;
        }
        if (gradeStr.length() == 2) {
            xOffset = 0;
        }
        if (gradeStr.length() == 3) {
            xOffset = -3;
        }
        g2.setColor(Color.black);
        g2.drawString(gradeStr, 5 + xOffset, 12);
    }

    private void _$22800(Graphics g2, int x2, Color fillColor) {
        if (fillColor != null) {
            g2.setColor(fillColor);
            g2.fillRoundRect(x2 - 4, 0, 16, 16, 8, 8);
        }
        g2.setColor(Color.gray);
        g2.drawRoundRect(x2 - 4, 0, 16, 16, 8, 8);
    }

    private void _$22804(Graphics g2, int x2, IPasStudentTableRow item) {
        if ((!item.canAttachGraph() && !item.canAttachRecording()) | item.getAttachmentID() == 0L) {
            this._$22800(g2, x2, Color.white);
        } else if (this.librarian.isLocalAssessmentAvailable(this.data.getIPasID(), OnlineFileInfo.STUDENT_ASSESSMENT_WAV, item.getAttachmentID())) {
            this._$22800(g2, x2, Color.green);
        } else if (this.librarian.isLocalAssessmentAvailable(this.data.getIPasID(), OnlineFileInfo.STUDENT_ASSESSMENT_PNG, item.getAttachmentID())) {
            this._$22800(g2, x2, Color.green);
        } else if (this.librarian.isOnlineAssessmentAvailable(this.data.getIPasID(), OnlineFileInfo.STUDENT_ASSESSMENT_WAV, item.getAttachmentID())) {
            this._$22800(g2, x2, Color.yellow);
        } else if (this.librarian.isOnlineAssessmentAvailable(this.data.getIPasID(), OnlineFileInfo.STUDENT_ASSESSMENT_PNG, item.getAttachmentID())) {
            this._$22800(g2, x2, Color.yellow);
        } else {
            this._$22800(g2, x2, Color.lightGray);
        }
        boolean completed = item.isCompleted();
        boolean donePastDue = item.isCompletedPastDue();
        boolean overdue = item.isOverdue();
        boolean black = true;
        if (!completed && !overdue) {
            g2.setColor(Color.gray);
            g2.drawLine(x2, 8, x2 + 8, 8);
            return;
        }
        if (!(completed || donePastDue || overdue)) {
            black = true;
        }
        if (!completed && !donePastDue && overdue) {
            black = false;
        }
        if (completed && !donePastDue && !overdue) {
            black = true;
        }
        if (completed && !donePastDue && overdue) {
            black = true;
        }
        if (completed && donePastDue && !overdue) {
            black = false;
        }
        if (completed && donePastDue && overdue) {
            black = false;
        }
        if (black) {
            g2.setColor(Color.black);
        } else {
            g2.setColor(Color.red);
        }
        GradingScheme scheme = this.data.getGradingScheme();
        int grade = scheme.gradeStyle == GradingScheme.GRADE_STYLE_AVERAGE ? item.getGrade() - item.getOverdueDeduction(scheme) : (item.getGrade() < scheme.meritPassScore ? 0 : scheme.meritPassPoints - item.getOverdueDeduction(scheme));
        String gradeStr = new Integer(grade).toString();
        int xOffset = 0;
        if (gradeStr.length() == 1) {
            xOffset = 2;
        }
        if (gradeStr.length() == 2) {
            xOffset = 0;
        }
        if (gradeStr.length() == 3) {
            xOffset = -3;
        }
        g2.drawString(gradeStr, x2 + xOffset, 12);
    }

    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        if (this.data == null) {
            return;
        }
        Rectangle r2 = g2.getClipBounds();
        g2.setColor(this.backColor);
        g2.fillRect(0, 0, r2.width, r2.height);
        g2.setFont(new Font("Dialog", 0, 9));
        int xCellWidth = 16;
        int xPos = xCellWidth + xCellWidth / 2;
        int start = this.iconPageView * this.iconsPerPage;
        int stop = Math.min(start + this.iconsPerPage, this.assignments.assignmentCount());
        for (int i2 = start; i2 < stop; ++i2) {
            long id = this.assignments.assignmentAt((int)i2).lessonID;
            IPasStudentTableRow row = this.data.find(id);
            if (row != null) {
                this._$22804(g2, xPos, row);
            }
            xPos += xCellWidth;
        }
        this._$22794(g2, this.data.getGradingScheme().grade);
    }
}

