/*
 * Decompiled with CFR 0.152.
 */
package pymo.iPasDBTools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import pymo.dataBases.DataBase;
import pymo.dataBases.DataBaseManager;
import pymo.descriptors.IPasDescriptor;
import pymo.fields.Field;
import pymo.iPasDBTools.AssignmentUploader_btnFinished_actionAdapter;
import pymo.iPasDBTools.IPasDBOrganizer;
import pymo.iPasDBTools.IPasMOStudentTable;
import pymo.iPasDBTools.IPasTeacherManager_btnStart_actionAdapter;
import pymo.iPasDBTools.IPasTeacherManager_cbTop10_actionAdapter;
import pymo.records.RecordList;
import pymo.searcher.SearchItem;
import pymo.searcher.SearchModel;
import pymo.searcher.Searcher;
import pymo.security.Constants;
import pymo.security.FilePath;
import pyware.iPasToolkit.interactive.IPasLibrarian;
import pyware.iPasToolkit.interactive.IPasLibrarianEvent;
import pyware.iPasToolkit.interactive.IPasLibrarianException;
import pyware.iPasToolkit.interactive.IPasLibrarianListener;
import pyware.iPasToolkit.interactive.IPasLibrarianTask;
import pyware.iPasToolkit.interactive.IPasStudentTable;
import pyware.iPasToolkit.interactive.StudentRosterItem;
import pyware.toolkit.Utils;

public class IPasTeacherManager
extends JDialog {
    private static int _$16991 = 1;
    private long _$16992 = 0L;
    private static Color _$6757 = new Color(172, 172, 172);
    private JPanel _$6758 = new JPanel();
    private BorderLayout _$1764 = new BorderLayout();
    private JPanel _$1765 = new JPanel();
    private JTextArea _$1954 = new JTextArea();
    private BorderLayout _$1771 = new BorderLayout();
    private JPanel _$1766 = new JPanel();
    private JButton _$6557 = new JButton();
    private Border _$546;
    private BorderLayout _$1775 = new BorderLayout();
    private JButton _$6373 = new JButton();
    private JPanel _$6759 = new JPanel();
    private JLabel _$16993 = new JLabel();
    private BorderLayout _$2161 = new BorderLayout();
    private Border _$1955;
    private Border _$1957;
    private JTextArea _$1959 = new JTextArea();
    private Border _$2182;
    private StringBuffer _$16994 = new StringBuffer();
    private DataBase[] _$8947;
    private DataBaseManager _$8792;
    private IPasLibrarian _$6591;
    private Frame _$483;
    private ImageIcon _$5163 = new ImageIcon(FilePath.toImages("logo.gray.animated.gif"));
    JPanel jPanel5 = new JPanel();
    private IPasDBOrganizer _$16995;
    private IPasLibrarianListener _$6592 = new IPasLibrarianListener(){

        public void taskStarted(IPasLibrarianEvent event) {
            if (event.getTaskListID() == (long)_$16991 && event.getTaskID() == IPasTeacherManager.this._$16992) {
                IPasTeacherManager.this._$16996();
                IPasTeacherManager.this._$16997();
                IPasTeacherManager.this._$6591.resumeTasks();
            }
        }

        public void taskListFinished(IPasLibrarianEvent event) {
            if (event.getTaskListID() == (long)_$16991) {
                IPasTeacherManager.this._$16998(true, event);
            }
        }

        public void taskListAborted(IPasLibrarianEvent event) {
            if (event.getTaskListID() == (long)_$16991) {
                IPasTeacherManager.this._$16998(false, event);
            }
        }
    };
    JScrollPane jScrollPane1 = new JScrollPane();
    JCheckBox cbTop10 = new JCheckBox();

    public IPasTeacherManager(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.enableEvents(64L);
        try {
            this._$550();
            this.pack();
            this.setSize(new Dimension(500, 600));
            Utils.centerDialog(frame, this);
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public IPasTeacherManager() {
        this((Frame)null, "", false);
    }

    public IPasTeacherManager(Frame frame, DataBaseManager dbm) throws Exception {
        this(frame, "Assignment Transporter", true);
        this._$483 = frame;
        this._$8792 = dbm;
        this._$6591 = dbm.getIPasLibrarian();
        this._$16995 = dbm.getIPasDBOrganizer();
        dbm.saveAllDataBases();
        this._$17000();
        this._$16995.rebuildRoster();
        this._$6758.setBackground(_$6757);
        this._$6591.addListener(this._$6592);
        if (!this._$16995.checkIntegrity()) {
            this._$6373.setEnabled(false);
        }
        this.cbTop10.setSelected(dbm.getSettings().getBoolLine("Preferences", "UseTop10", true));
    }

    private void _$550() throws Exception {
        this._$546 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this._$1955 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this._$1957 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(124, 124, 124), new Color(178, 178, 178)), BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._$2182 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this._$6758.setLayout(this._$1764);
        this._$1954.setFont(new Font("Dialog", 1, 12));
        this._$1954.setBorder(this._$1957);
        this._$1954.setPreferredSize(new Dimension(300, 300));
        this._$1954.setEditable(false);
        this._$1954.setLineWrap(true);
        this._$1954.setWrapStyleWord(true);
        this._$1765.setLayout(this._$1771);
        this._$6557.setPreferredSize(new Dimension(80, 23));
        this._$6557.setFocusPainted(false);
        this._$6557.setText("Exit");
        this._$6557.addActionListener(new AssignmentUploader_btnFinished_actionAdapter(this));
        this._$1765.setBorder(this._$546);
        this._$1765.setOpaque(false);
        this._$1766.setLayout(this._$1775);
        this._$6373.setForeground(Color.red);
        this._$6373.setPreferredSize(new Dimension(80, 23));
        this._$6373.setFocusPainted(false);
        this._$6373.setText("START");
        this._$6373.addActionListener(new IPasTeacherManager_btnStart_actionAdapter(this));
        this._$6759.setLayout(this._$2161);
        this._$16993.setBorder(this._$1955);
        this._$16993.setText("");
        this._$1959.setBackground(Color.white);
        this._$1959.setFont(new Font("Dialog", 1, 12));
        this._$1959.setBorder(this._$2182);
        this._$1959.setOpaque(false);
        this._$1959.setEditable(false);
        this._$1959.setText("Transmit information bewteen the iPAS Student Manager and all lab and home instllations of iPAS.  Students receive their assignments, announcements, top 10 lists.  The teacher receives the student's scores, graphs and performance recordings.");
        this._$1959.setLineWrap(true);
        this._$1959.setWrapStyleWord(true);
        this._$1766.setOpaque(false);
        this._$6759.setOpaque(false);
        this.jPanel5.setOpaque(false);
        this.cbTop10.setOpaque(false);
        this.cbTop10.setText("Transmit Top 10 List");
        this.cbTop10.addActionListener(new IPasTeacherManager_cbTop10_actionAdapter(this));
        this._$1766.add((Component)this.jPanel5, "East");
        this.jPanel5.add((Component)this._$6373, null);
        this.jPanel5.add((Component)this._$6557, null);
        this._$1766.add((Component)this.cbTop10, "West");
        this.getContentPane().add(this._$6758);
        this._$6758.add((Component)this._$1765, "Center");
        this._$1765.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this._$1954, null);
        this._$6758.add((Component)this._$1766, "South");
        this._$6758.add((Component)this._$6759, "North");
        this._$6759.add((Component)this._$16993, "West");
        this._$6759.add((Component)this._$1959, "Center");
        this._$16993.setIcon(this._$5163);
    }

    private void _$6438() {
        this._$8792.getSettings().setBoolLine("Preferences", "UseTop10", this.cbTop10.isSelected());
        this._$6591.removeListener(this._$6592);
        for (int i2 = 0; i2 < this._$8792.getDataBaseCount(); ++i2) {
            this._$8792.dataBaseAt(i2).getPanelManager().getMainTablePanel().fireModelChanged();
        }
    }

    protected void processWindowEvent(WindowEvent e2) {
        if (e2.getID() == 201) {
            this._$6438();
            super.processWindowEvent(e2);
        }
    }

    private void _$16998(boolean succeeded, IPasLibrarianEvent event) {
        if (succeeded) {
            JOptionPane.showMessageDialog(this._$483, "Online iPAS Student information has been successfully transferred.", "iPAS Online Librarian", 1);
            this._$6557.doClick();
        } else {
            String msg = "The iPAS Student information was not successfully transferred.\n\nReason:  " + event.getErrorMessage();
            JOptionPane.showMessageDialog(this._$483, msg, "iPAS Online Librarian", 0);
            if (event.getErrorID() == (long)IPasLibrarianException.ACCOUNT_EXPIRED) {
                this._$8792.getSettings().askSwitchProgramToLocalOnly(this._$483);
            }
        }
    }

    private boolean _$16996() {
        try {
            String dirPath = this._$6591.getLocalPath();
            String[] logFileNames = this._$17004(dirPath);
            if (logFileNames.length == 0) {
                return false;
            }
            this._$17005("");
            this._$17005("Updating Student Records");
            for (int i2 = 0; i2 < logFileNames.length; ++i2) {
                IPasStudentTable data = IPasStudentTable.readStudentLog(logFileNames[i2]);
                RecordList students = this._$17007(data.getIPasID());
                if (students == null || students.size() != 1) continue;
                this._$17005("    iPAS ID#" + data.getIPasID() + " in " + students.getDataBase().getHeader().getTitle());
                this._$17008(logFileNames[i2]);
                this._$17009(students, data);
                FilePath.eraseFile(logFileNames[i2]);
            }
            this._$8792.saveAllDataBases();
            return true;
        }
        catch (Exception ex2) {
            JOptionPane.showMessageDialog(this._$483, "There was a problem updating the database for the student assessments.");
            return false;
        }
    }

    private void _$17008(String fullFileName) {
        String fileName = new File(fullFileName).getName();
        int pos1 = fileName.indexOf(46);
        if (pos1 == -1) {
            return;
        }
        int pos2 = fileName.indexOf(46, pos1 + 1);
        if (pos2 == -1) {
            return;
        }
        String id = fileName.substring(0, pos1);
        String sn = fileName.substring(pos1 + 1, pos2);
        StudentRosterItem student = this._$6591.findStudent(id);
        if (student == null) {
            return;
        }
        try {
            boolean exists = new File("student.use.log").exists();
            DateFormat formatter = DateFormat.getDateInstance(3);
            BufferedWriter writer = new BufferedWriter(new FileWriter("student.use.log", true));
            StringBuffer buf = new StringBuffer();
            if (!exists) {
                writer.write("Student Use Log");
                writer.newLine();
                writer.write("Date\tName\tiPAS SN\t");
                writer.newLine();
            }
            buf.append(formatter.format(new Date(System.currentTimeMillis())));
            buf.append('\t');
            buf.append(student.getFullName());
            buf.append('\t');
            buf.append(sn);
            buf.append('\t');
            writer.write(buf.toString());
            writer.newLine();
            writer.close();
        }
        catch (Exception ex2) {
            return;
        }
    }

    private void _$17005(String line) {
        this._$16994.append(line + '\n');
        this._$1954.setText(this._$16994.toString());
    }

    private void _$17000() {
        this._$8947 = this._$16995.getIPasDBList();
        int len = this._$8947.length;
        this._$17005("Student access will only be allowed for the following online databases.  To change the list of online databases, use the File Manager.");
        this._$17005("");
        if (len == 1) {
            this._$17005("One database is currently online:");
        }
        if (len > 1) {
            this._$17005("There are " + len + " databases are online:");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            this._$17005("    " + (i2 + 1) + ": " + this._$8947[i2].getHeader().getTitle());
        }
        this._$17005("");
        this._$17005("Click the Start button to begin.  If you are disconnected during this transmission, click the Start button again and the transmission will continue where it stopped.");
    }

    private void _$17013() throws Exception {
        try {
            String filePath = this._$6591.getLocalPath();
            String fileName = "students.lst";
            String tempFileName = fileName + ".tmp";
            String existingFilePath = filePath + fileName;
            String newTempFilePath = filePath + tempFileName;
            this._$6591.saveRoster(newTempFilePath);
            if (!FilePath.compareFiles(newTempFilePath, existingFilePath)) {
                this._$6591.addTask(IPasLibrarianTask.createUploadTask(newTempFilePath, fileName, true, true, "Uploading student roster."));
                this._$6591.addTask(IPasLibrarianTask.createLocalRenameTask(newTempFilePath, existingFilePath, "Saving a copy."));
            } else {
                this._$6591.addTask(IPasLibrarianTask.createUploadTask(existingFilePath, fileName, true, false, "Uploading student roster."));
                FilePath.eraseFile(newTempFilePath);
            }
        }
        catch (Exception ex2) {
            System.out.println(ex2.getMessage());
            ex2.printStackTrace();
            throw new Exception("Problem creating student roster file.");
        }
    }

    private void _$17019() throws Exception {
        try {
            String oldFilePath = this._$6591.getLocalPath();
            String newFilePath = Constants.LESSON_WIZARD_PATH;
            String fileName = "lessons.pkg";
            String newFile = newFilePath + fileName;
            String oldFile = oldFilePath + fileName;
            if (new File(newFile).exists()) {
                if (!FilePath.compareFiles(newFile, oldFile)) {
                    this._$6591.addTask(IPasLibrarianTask.createUploadTask(newFile, fileName, true, true, "Uploading custom lessons."));
                    this._$6591.addTask(IPasLibrarianTask.createLocalCopyTask(newFile, oldFile, "Saving a copy."));
                } else {
                    this._$6591.addTask(IPasLibrarianTask.createUploadTask(newFilePath, fileName, true, false, "Uploading custom lessons."));
                }
            }
        }
        catch (Exception ex2) {
            System.out.println(ex2.getMessage());
            ex2.printStackTrace();
            throw new Exception("Problem creating online lessons file.");
        }
    }

    private void _$17025(DataBase db) throws Exception {
        try {
            String filePath = this._$6591.getLocalPath();
            String fileName = db.getHeader().getDataBaseID() + ".asn";
            String tempFileName = fileName + ".tmp";
            String existingFilePath = filePath + fileName;
            String newTempFilePath = filePath + tempFileName;
            IPasDescriptor iPasDescriptor = (IPasDescriptor)db.getDescriptors().getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE);
            iPasDescriptor.createAsnFile(newTempFilePath, this.cbTop10.isSelected());
            if (!FilePath.compareFiles(newTempFilePath, existingFilePath)) {
                this._$6591.addTask(IPasLibrarianTask.createUploadTask(newTempFilePath, fileName, true, true, "Uploading " + db.getHeader().getTitle() + " assignments."));
                this._$6591.addTask(IPasLibrarianTask.createLocalRenameTask(newTempFilePath, existingFilePath, "Saving a copy."));
            } else {
                this._$6591.addTask(IPasLibrarianTask.createUploadTask(existingFilePath, fileName, true, false, "Uploading " + db.getHeader().getTitle() + " assignments."));
                FilePath.eraseFile(newTempFilePath);
            }
        }
        catch (Exception ex2) {
            System.out.println(ex2.getMessage());
            ex2.printStackTrace();
            throw new Exception("Problem creating online assignment list file.");
        }
    }

    private void _$17026(DataBase db) throws Exception {
        try {
            IPasDescriptor descriptor = (IPasDescriptor)db.getDescriptors().getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE);
            String filePath = this._$6591.getLocalPath();
            String fileName = db.getHeader().getDataBaseID() + ".anc";
            String tempFileName = fileName + ".tmp";
            String existingFilePath = filePath + fileName;
            String newTempFilePath = filePath + tempFileName;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(newTempFilePath)));
            writer.write(descriptor.getAnnouncement());
            writer.close();
            if (!FilePath.compareFiles(newTempFilePath, existingFilePath)) {
                if (new File(newTempFilePath).length() == 0L) {
                    this._$6591.addTask(IPasLibrarianTask.createDeleteFromServer(fileName, false, "Clearing announcements for " + db.getHeader().getTitle() + "."));
                } else {
                    this._$6591.addTask(IPasLibrarianTask.createUploadTask(newTempFilePath, fileName, true, true, "Uploading " + db.getHeader().getTitle() + " announcements."));
                }
                if (!this._$6591.isWorkingOffline()) {
                    this._$6591.addTask(IPasLibrarianTask.createLocalRenameTask(newTempFilePath, existingFilePath, "Saving a copy."));
                }
            } else {
                if (new File(existingFilePath).length() > 0L) {
                    this._$6591.addTask(IPasLibrarianTask.createUploadTask(existingFilePath, fileName, true, false, "Uploading " + db.getHeader().getTitle() + " announcements."));
                }
                FilePath.eraseFile(newTempFilePath);
            }
        }
        catch (Exception ex2) {
            System.out.println(ex2.getMessage());
            ex2.printStackTrace();
            throw new Exception("Problem creating online announcements file.");
        }
    }

    private String[] _$17004(String dirPath) {
        Vector<String> items = new Vector<String>();
        String[] fileList = FilePath.getFileList(dirPath);
        for (int i2 = 0; i2 < fileList.length; ++i2) {
            String fileName = fileList[i2];
            if (!fileName.endsWith(".log")) continue;
            items.add(dirPath + fileName);
        }
        String[] batch = new String[items.size()];
        for (int i3 = 0; i3 < batch.length; ++i3) {
            batch[i3] = (String)items.elementAt(i3);
        }
        return batch;
    }

    private RecordList _$17007(String studentID) {
        for (int i2 = 0; i2 < this._$8947.length; ++i2) {
            try {
                DataBase db = this._$8947[i2];
                Searcher searcher = new Searcher(db);
                IPasDescriptor d2 = (IPasDescriptor)db.getDescriptors().getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE);
                IPasMOStudentTable studentData = new IPasMOStudentTable(studentID);
                Field field = d2.toField(studentData);
                SearchItem searchItem = new SearchItem(d2.getID(), SearchItem.COMPARE_EQUAL, field, 1);
                SearchModel searchModel = new SearchModel();
                searchModel.addSearchItem(searchItem);
                RecordList list = searcher.linearSearch(db.getRecords(), searchModel);
                if (list.getRecordCount() != 1) continue;
                return list;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private void _$17009(RecordList list, IPasStudentTable newData) {
        DataBase db = list.getDataBase();
        IPasDescriptor d2 = (IPasDescriptor)db.getDescriptors().getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE);
        int fieldIndex = d2.getFieldIndex();
        try {
            Field field = list.getField(0, fieldIndex);
            IPasStudentTable existingData = (IPasStudentTable)d2.toWrapper(field);
            existingData.updateStudentInfo(newData);
            field = d2.toField(existingData);
            list.putField(0, fieldIndex, field);
            db.save();
        }
        catch (IOException ex2) {
            // empty catch block
        }
    }

    private void _$16997() {
        try {
            this._$17013();
            this._$17019();
            for (int i2 = 0; i2 < this._$8947.length; ++i2) {
                this._$17025(this._$8947[i2]);
                this._$17026(this._$8947[i2]);
            }
            if (!this._$6591.isWorkingOffline()) {
                this._$6591.addTask(IPasLibrarianTask.createDeleteExpiredAttachmentsFromServer());
            }
        }
        catch (Exception ex2) {
            System.out.println(ex2.getMessage());
            JOptionPane.showMessageDialog(this._$483, ex2.getMessage());
            return;
        }
    }

    void btnStart_actionPerformed(ActionEvent e2) {
        this._$8792.getFrontDataBase().getPanelManager().getMainTablePanel().collapseTable();
        this._$6591.setWorkingOffline(!this._$8792.getSettings().isRemoteFTPAccessEnabled());
        this._$6591.createNewTaskList(_$16991);
        try {
            this._$6591.addTask(IPasLibrarianTask.createOpenRootDirectory("Accessing iPAS Online."));
            if (!this._$6591.isWorkingOffline()) {
                this._$6591.addTask(IPasLibrarianTask.createDownloadSystemPrefsTask(this._$6591.getLocalPath()));
            }
            this._$6591.addTask(IPasLibrarianTask.createOpenAccountTask("Opening the online school account."));
            if (!this._$6591.isWorkingOffline()) {
                this._$6591.addTask(IPasLibrarianTask.createDownloadAccountPrefsTask(this._$6591.getLocalPath()));
            }
            this._$6591.addTask(IPasLibrarianTask.createDownloadAllLogsTask());
            if (!this._$6591.isWorkingOffline()) {
                this._$6591.addTask(IPasLibrarianTask.createDeleteExpiredAttachmentsFromServer());
            }
            this._$16992 = this._$6591.addTask(IPasLibrarianTask.createPauseTask("Updating teacher databases."));
        }
        catch (Exception ex2) {
            System.out.println(ex2.getMessage());
            JOptionPane.showMessageDialog(this._$483, ex2.getMessage());
            return;
        }
        this._$6591.executeTaskList();
    }

    void btnFinished_actionPerformed(ActionEvent e2) {
        this._$6438();
        this.hide();
    }

    void cbTop10_actionPerformed(ActionEvent e2) {
    }
}

