/*
 * Decompiled with CFR 0.152.
 */
package pymo.iPasDBTools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import pymo.dataBases.DataBase;
import pymo.descriptors.IPasDescriptor;
import pymo.iPasDBTools.GradingOptions;
import pymo.iPasDBTools.IPasBridgeDialog;
import pymo.iPasDBTools.IPasScheduler_btnBridge_actionAdapter;
import pymo.iPasDBTools.IPasScheduler_btnCancel_actionAdapter;
import pymo.iPasDBTools.IPasScheduler_btnSave_actionAdapter;
import pymo.iPasDBTools.IPasScheduler_jButton1_actionAdapter;
import pymo.iPasDBTools.SchedulerTableModel;
import pymo.iPasDBTools.Scheduler_btnReset_actionAdapter;
import pyware.iPasToolkit.interactive.IPasLibrarian;
import pyware.iPasToolkit.interactive.LessonList;
import pyware.toolkit.Utils;

public class Scheduler
extends JDialog {
    Frame frame;
    JPanel mainPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel bottomPanel = new JPanel();
    JButton btnCancel = new JButton();
    JPanel centerPanel = new JPanel();
    JScrollPane scrollPane = new JScrollPane();
    JTable table = new JTable();
    JButton btnSave = new JButton();
    DataBase db;
    SchedulerTableModel model;
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    IPasDescriptor descriptor;
    JPanel jPanel2 = new JPanel();
    JButton btnBridge = new JButton();
    JButton jButton1 = new JButton();
    JButton btnReset = new JButton();

    public Scheduler() {
        this((Frame)null, "", false);
    }

    public Scheduler(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.frame = frame;
        try {
            this._$550();
            this.pack();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public Scheduler(Frame frame, DataBase db) {
        this(frame, "iPAS Lesson Scheduler", true);
        this.db = db;
        if (db.getDataBaseManager().getIPasDBOrganizer().configureForIPas(db, true)) {
            this.descriptor = IPasDescriptor.aquire(db.getDescriptors());
            this._$16944();
            this._$16945();
            this.btnSave.setEnabled(true);
        }
        this.pack();
        Utils.centerDialog(frame, this);
        db.getPanelManager().getMainTablePanel().collapseTable();
        this.setTitle("iPAS Assignment Scheduler for " + db.getHeader().getTitle());
    }

    private void _$550() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 0, 10);
        this.mainPanel.setLayout(this.borderLayout1);
        this.btnCancel.setFocusPainted(false);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new IPasScheduler_btnCancel_actionAdapter(this));
        this.mainPanel.setBorder(this.border1);
        this.mainPanel.setPreferredSize(new Dimension(790, 550));
        this.btnSave.setEnabled(false);
        this.btnSave.setFocusPainted(false);
        this.btnSave.setText("Save");
        this.btnSave.addActionListener(new IPasScheduler_btnSave_actionAdapter(this));
        this.centerPanel.setLayout(this.borderLayout2);
        this.bottomPanel.setLayout(this.borderLayout3);
        this.btnBridge.setFocusPainted(false);
        this.btnBridge.setText("Find Lessons");
        this.btnBridge.addActionListener(new IPasScheduler_btnBridge_actionAdapter(this));
        this.jButton1.setFocusPainted(false);
        this.jButton1.setText("Grading Options");
        this.jButton1.addActionListener(new IPasScheduler_jButton1_actionAdapter(this));
        this.btnReset.setFocusPainted(false);
        this.btnReset.setText("Clear Schetule");
        this.btnReset.addActionListener(new Scheduler_btnReset_actionAdapter(this));
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.bottomPanel, "South");
        this.bottomPanel.add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.btnSave, null);
        this.jPanel1.add((Component)this.btnCancel, null);
        this.bottomPanel.add((Component)this.jPanel2, "West");
        this.jPanel2.add((Component)this.btnBridge, null);
        this.jPanel2.add((Component)this.jButton1, null);
        this.jPanel2.add((Component)this.btnReset, null);
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.table, null);
        this.table.getTableHeader().setFont(new Font("Dialog", 0, 10));
        this.table.setFont(new Font("Dialog", 0, 10));
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
    }

    private boolean _$16944() {
        int rslt;
        IPasLibrarian librarian = this.descriptor.getIPasFileLibrarian();
        LessonList lessonList = librarian.getLessonList();
        if (lessonList.size() == 0 && (rslt = JOptionPane.showConfirmDialog(this.frame, "In order do display lessons, an iPAS Student Edition\ninstallation must be bridged to the iPAS Student Manager.\n\nDo you want to do that now?", "iPAS Librarian", 0, 3)) == 0) {
            IPasBridgeDialog dialog = new IPasBridgeDialog(this.frame, librarian, this.db.getDataBaseManager().getSettings());
            dialog.show();
            return dialog.isSuccess();
        }
        return false;
    }

    private void _$16945() {
        this.descriptor.getIPasFileLibrarian().getLessonList().reload();
        this.model = new SchedulerTableModel(this.frame, this.table, this.descriptor);
        this.db.getPanelManager().getMainTablePanel().fireModelChanged();
    }

    private void _$16948() {
        this.model.updateDescriptor(this.descriptor);
        this.db.getPanelManager().getMainTablePanel().fireModelChanged();
    }

    private void _$16950() {
        int rowIndex = this.table.getEditingRow();
        int colIndex = this.table.getEditingColumn();
        if (rowIndex > -1 && colIndex > -1) {
            this.table.getCellEditor(rowIndex, colIndex).stopCellEditing();
        }
        this._$16948();
        this.db.getDataBaseManager().getIPasDBOrganizer().removeDeadAssignmentResults(this.db);
    }

    void btnCancel_actionPerformed(ActionEvent e2) {
        if (this._$16952()) {
            this.hide();
        }
    }

    protected void processWindowEvent(WindowEvent e2) {
        if (e2.getID() == 200) {
            this.model.checkRecordOveruse();
        }
        if (e2.getID() == 201 && this._$16952()) {
            super.processWindowEvent(e2);
        }
    }

    private boolean _$16952() {
        if (this.model == null) {
            return true;
        }
        if (!this.model.hasChanged()) {
            return true;
        }
        int rslt = JOptionPane.showConfirmDialog(this, "Do you want to save the changes?", "iPAS Scheduler", 1);
        if (rslt == 0) {
            this._$16950();
        }
        return rslt != 2;
    }

    void btnSave_actionPerformed(ActionEvent e2) {
        this._$16950();
        this.hide();
    }

    void btnBridge_actionPerformed(ActionEvent e2) {
        IPasLibrarian librarian = this.descriptor.getIPasFileLibrarian();
        new IPasBridgeDialog(this.frame, librarian, this.db.getDataBaseManager().getSettings()).show();
        this._$16945();
    }

    void jButton1_actionPerformed(ActionEvent e2) {
        new GradingOptions(this.frame, this.descriptor).show();
    }

    void btnReset_actionPerformed(ActionEvent e2) {
        int rslt = JOptionPane.showConfirmDialog(this.frame, "You are about to remove all of the assignments from the class schedule.\nIf any students have turned in results for these assignment, the results\nwill be deleted from their student record.  This is useful for starting a\nnew grading period with a new list of assignments.\n\nOkay to remove all assignments from the class schedule?", "iPAS Librarian Notice", 0, 3);
        if (rslt != 0) {
            return;
        }
        rslt = JOptionPane.showConfirmDialog(this.frame, "ARE YOU SURE YOU WANT TO REMOVE ALL ASSIGNMENTS FROM THE CLASS SCHEDULE?\n\nIf any students have turned in results for these assignments, the results\nwill be deleted from their student record.\n", "iPAS Librarian Notice", 0, 3);
        if (rslt == 0) {
            this.model.resetAllAssignments();
            this.db.getPanelManager().getMainTablePanel().fireModelChanged();
        }
    }
}

