/*
 * Decompiled with CFR 0.152.
 */
package pymo.iPasDBTools.reports;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.wildcrest.j2printerworks.J2Printer;
import com.wildcrest.j2printerworks.J2TablePrinter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pymo.dataBases.DataBase;
import pymo.dataBases.DataBaseManager;
import pymo.iPasDBTools.reports.StudentListDialog_btnDone_actionAdapter;
import pymo.iPasDBTools.reports.StudentListDialog_btnPageSetup_actionAdapter;
import pymo.iPasDBTools.reports.StudentListDialog_btnPreview_actionAdapter;
import pymo.iPasDBTools.reports.StudentListDialog_btnPrint_actionAdapter;
import pymo.iPasDBTools.reports.StudentListDialog_cbIncludePassword_actionAdapter;
import pymo.security.Constants;
import pymo.security.Settings;
import pyware.iPasToolkit.interactive.StudentRoster;
import pyware.iPasToolkit.interactive.StudentRosterItem;
import pyware.toolkit.Utils;

public class StudentListDialog
extends JDialog {
    static int COLM_NAME = 0;
    static int COLM_ID = 1;
    static int COLM_PWD = 2;
    static int COLM_DB = 3;
    StudentRoster roster = null;
    DataBaseManager dbm;
    Settings settings;
    J2Printer printer = new J2Printer(Constants.J2PW_SN);
    Frame frame;
    TableModel dataModel = new AbstractTableModel(){

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return StudentListDialog.this.roster == null ? 0 : StudentListDialog.this.roster.getStudentCount();
        }

        public Object getValueAt(int row, int col) {
            if (StudentListDialog.this.roster == null) {
                return "";
            }
            StudentRosterItem student = StudentListDialog.this.roster.studentAt(row);
            if (col == COLM_NAME) {
                return student.getFullNameLastFirst();
            }
            if (col == COLM_ID) {
                return student.getIPasID();
            }
            if (col == COLM_PWD) {
                return StudentListDialog.this.cbIncludePassword.isSelected() ? student.getPassword() : "***";
            }
            if (col == COLM_DB) {
                DataBase db = StudentListDialog.this.dbm.getDataBase(student.getDataBaseID());
                return db != null ? db.getHeader().getTitle() : "";
            }
            return "";
        }

        public String getColumnName(int col) {
            if (col == COLM_NAME) {
                return "Name";
            }
            if (col == COLM_ID) {
                return "ID";
            }
            if (col == COLM_PWD) {
                return "Password";
            }
            if (col == COLM_DB) {
                return "Database";
            }
            return null;
        }
    };
    JPanel mainPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel bottomPanel = new JPanel();
    JPanel centerPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton btnPrint = new JButton();
    JButton btnDone = new JButton();
    Border border1;
    JPanel panelView = new JPanel();
    JScrollPane scrollPane = new JScrollPane();
    BorderLayout borderLayout4 = new BorderLayout();
    JTable table = new JTable();
    JPanel panelPrint = new JPanel();
    JCheckBox cbIncludePassword = new JCheckBox();
    JButton btnPageSetup = new JButton();
    JButton jButton1 = new JButton();
    JButton btnPreview = new JButton();
    JLabel lblStatus = new JLabel();
    VerticalFlowLayout verticalFlowLayout2 = new VerticalFlowLayout();
    int totalPages = 0;
    PropertyChangeListener printListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("printing")) {
                if (StudentListDialog.this.printer.isPrinting()) {
                    StudentListDialog.this._$21328("About to print...");
                } else if (StudentListDialog.this.printer.isPrintDialogResponse()) {
                    StudentListDialog.this._$21328("Printing finished.");
                    StudentListDialog.this._$21329();
                    StudentListDialog.this._$21330(StudentListDialog.this.panelPrint);
                }
            }
            if (evt.getPropertyName().equalsIgnoreCase("printDialogResponse")) {
                if (StudentListDialog.this.printer.isPrintDialogResponse()) {
                    StudentListDialog.this._$21328("Start printing...");
                    StudentListDialog.this.totalPages = StudentListDialog.this.printer.getPageable().getNumberOfPages();
                } else {
                    StudentListDialog.this._$21328("Printing cancelled...");
                    StudentListDialog.this._$21329();
                    StudentListDialog.this._$21330(StudentListDialog.this.panelPrint);
                }
            }
            if (evt.getPropertyName().equalsIgnoreCase("pageBeingPrinted") && StudentListDialog.this.printer.isPrinting() && StudentListDialog.this.printer.getPageBeingPrinted() > 0) {
                StudentListDialog.this.lblStatus.setText("Printing page " + StudentListDialog.this.printer.getPageBeingPrinted() + " of " + StudentListDialog.this.totalPages);
            }
        }
    };
    JPanel jPanel5 = new JPanel();
    JTextArea jTextArea1 = new JTextArea();
    BorderLayout borderLayout5 = new BorderLayout();
    Border border2;
    Border border3;
    CardLayout cardLayout1 = new CardLayout();
    Border border4;

    public StudentListDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
            this.setSize(new Dimension(600, 600));
            Utils.centerDialog(frame, this);
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public StudentListDialog() {
        this((Frame)null, "", false);
    }

    public StudentListDialog(Frame frame, DataBaseManager dbm) {
        this(frame, "iPAS Student ID's and Passwords", true);
        this.frame = frame;
        this.dbm = dbm;
        this.roster = dbm.getIPasLibrarian().getStudentRoster();
        this.settings = dbm.getSettings();
        this.table.setModel(this.dataModel);
        if (!dbm.getIPasDBOrganizer().checkIntegrity()) {
            this.setPrintButtonsEnabled(false);
        }
        this.roster.sortByName();
        this.printer.addPropertyChangeListener(this.printListener);
        this.printer.setPrintPreviewScale(1.25);
        for (int col = 0; col < this.dataModel.getColumnCount(); ++col) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(col);
            if (col == 0) {
                tableColumn.setPreferredWidth(250);
            }
            if (col == 1) {
                tableColumn.setPreferredWidth(75);
            }
            if (col == 2) {
                tableColumn.setPreferredWidth(75);
            }
            if (col != 3) continue;
            tableColumn.setPreferredWidth(150);
        }
        this._$21330(this.panelView);
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 0, 10);
        this.border2 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border3 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(109, 109, 110), new Color(156, 156, 158)), BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border4 = BorderFactory.createEmptyBorder(10, 0, 0, 0);
        this.mainPanel.setLayout(this.borderLayout1);
        this.bottomPanel.setLayout(this.borderLayout2);
        this.centerPanel.setLayout(this.cardLayout1);
        this.btnPrint.setPreferredSize(new Dimension(80, 23));
        this.btnPrint.setFocusPainted(false);
        this.btnPrint.setText("Print");
        this.btnPrint.addActionListener(new StudentListDialog_btnPrint_actionAdapter(this));
        this.btnDone.setPreferredSize(new Dimension(80, 23));
        this.btnDone.setFocusPainted(false);
        this.btnDone.setText("Done");
        this.btnDone.addActionListener(new StudentListDialog_btnDone_actionAdapter(this));
        this.panelView.setLayout(this.borderLayout4);
        this.cbIncludePassword.setFocusPainted(false);
        this.cbIncludePassword.setHorizontalAlignment(0);
        this.cbIncludePassword.setSelected(true);
        this.cbIncludePassword.setText("Include Password");
        this.cbIncludePassword.addActionListener(new StudentListDialog_cbIncludePassword_actionAdapter(this));
        this.btnPageSetup.setPreferredSize(new Dimension(120, 23));
        this.btnPageSetup.setFocusPainted(false);
        this.btnPageSetup.setText("Page Setup");
        this.btnPageSetup.addActionListener(new StudentListDialog_btnPageSetup_actionAdapter(this));
        this.jButton1.setText("Page Setup");
        this.jButton1.setText("jButton1");
        this.btnPreview.setPreferredSize(new Dimension(120, 23));
        this.btnPreview.setFocusPainted(false);
        this.btnPreview.setText("Preview");
        this.btnPreview.addActionListener(new StudentListDialog_btnPreview_actionAdapter(this));
        this.lblStatus.setFont(new Font("Dialog", 1, 12));
        this.lblStatus.setForeground(Color.red);
        this.lblStatus.setHorizontalAlignment(0);
        this.lblStatus.setText("(status)");
        this.panelPrint.setLayout(this.verticalFlowLayout2);
        this.verticalFlowLayout2.setAlignment(1);
        this.scrollPane.setEnabled(false);
        this.table.setEnabled(false);
        this.jTextArea1.setFont(new Font("Dialog", 0, 12));
        this.jTextArea1.setOpaque(false);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setText("Displays and prints a list of students with their Student ID's and Password's.");
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setWrapStyleWord(true);
        this.jPanel5.setLayout(this.borderLayout5);
        this.mainPanel.setBorder(this.border2);
        this.jPanel5.setBorder(this.border3);
        this.centerPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.bottomPanel.setBorder(this.border4);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.bottomPanel, "South");
        this.bottomPanel.add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.btnPrint, null);
        this.jPanel1.add((Component)this.btnDone, null);
        this.bottomPanel.add((Component)this.jPanel2, "West");
        this.jPanel2.add((Component)this.btnPageSetup, null);
        this.jPanel2.add((Component)this.btnPreview, null);
        this.jPanel2.add((Component)this.cbIncludePassword, null);
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.panelPrint, "panelPrint");
        this.panelPrint.add((Component)this.lblStatus, null);
        this.centerPanel.add((Component)this.panelView, "panelView");
        this.panelView.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.table, null);
        this.mainPanel.add((Component)this.jPanel5, "North");
        this.jPanel5.add((Component)this.jTextArea1, "Center");
    }

    private void _$21330(JPanel page) {
        this.panelPrint.setVisible(page == this.panelPrint);
        this.panelView.setVisible(page == this.panelView);
    }

    private void _$21328(String txt) {
        this._$21330(this.panelPrint);
        this.lblStatus.setText(txt);
    }

    private void _$21329() {
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean _$21370() {
        try {
            J2TablePrinter tablePrinter = new J2TablePrinter(this.table);
            this.printer.clearHeaders();
            this.printer.clearFooters();
            this.printer.setHeaderFont(new Font("Serif", 0, 14));
            this.printer.setCenterHeader("Student ID & Password Master List");
            this.printer.setFooterFont(new Font("Serif", 0, 10));
            this.printer.addPageable(tablePrinter);
            return true;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            return false;
        }
    }

    private boolean _$16304() {
        this.printer.clearPageable();
        return this._$21370();
    }

    public void setPrintButtonsEnabled(boolean enabled) {
        this.btnPrint.setEnabled(enabled);
        this.btnPageSetup.setEnabled(enabled);
        this.btnPreview.setEnabled(enabled);
    }

    public void setPrintMessage(String msg) {
        this.lblStatus.setText(msg);
    }

    void btnDone_actionPerformed(ActionEvent e2) {
        this.hide();
    }

    void btnPrint_actionPerformed(ActionEvent e2) {
        if (this._$16304()) {
            this.printer.print();
        }
    }

    void cbIncludePassword_actionPerformed(ActionEvent e2) {
        this.table.repaint();
    }

    void btnPreview_actionPerformed(ActionEvent e2) {
        if (this._$16304()) {
            this.printer.showPrintPreviewDialog(this);
        }
    }

    void btnPageSetup_actionPerformed(ActionEvent e2) {
        this.printer.showPageSetupDialog();
    }
}

