/*
 * Decompiled with CFR 0.152.
 */
package pymo.iPasDBTools.reports;

import com.borland.jbcl.layout.BoxLayout2;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.wildcrest.j2printerworks.J2PanelPrinter;
import com.wildcrest.j2printerworks.J2Printer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import pymo.dataBases.DataBase;
import pymo.dataBases.DataBaseManager;
import pymo.descriptors.IPasDescriptor;
import pymo.fields.Field;
import pymo.iPasDBTools.reports.ProfileReportPanel;
import pymo.iPasDBTools.reports.StudentProfileDialog_btnDone_actionAdapter;
import pymo.iPasDBTools.reports.StudentProfileDialog_btnPageSetup_actionAdapter;
import pymo.iPasDBTools.reports.StudentProfileDialog_btnPreview_actionAdapter;
import pymo.iPasDBTools.reports.StudentProfileDialog_btnPrint_actionAdapter;
import pymo.iPasDBTools.reports.StudentProfileDialog_rbPrintHighlight_actionAdapter;
import pymo.iPasDBTools.reports.StudentProfileDialog_rbPrintRoster_actionAdapter;
import pymo.iPasDBTools.reports.StudentProfileDialog_rbPrintSelection_actionAdapter;
import pymo.records.RecordList;
import pymo.security.Constants;
import pymo.security.Settings;
import pyware.iPasToolkit.interactive.IPasStudentTable;
import pyware.iPasToolkit.interactive.StudentRoster;
import pyware.iPasToolkit.interactive.StudentRosterItem;
import pyware.toolkit.Utils;

public class StudentSetupReport
extends JDialog {
    static int COLM_NAME = 0;
    static int COLM_ID = 1;
    static int COLM_PWD = 2;
    static int COLM_DB = 3;
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel panelPreferences = new JPanel();
    JPanel panelProgress = new JPanel();
    JPanel jPanel3 = new JPanel();
    JButton btnDone = new JButton();
    JButton btnPrint = new JButton();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JPanel jPanel5 = new JPanel();
    JCheckBox cbIncludePassword = new JCheckBox();
    JPanel jPanel6 = new JPanel();
    JTextArea jTextArea1 = new JTextArea();
    BorderLayout borderLayout4 = new BorderLayout();
    Border border1;
    StudentRoster roster = null;
    DataBaseManager dbManager;
    DataBase frontDB;
    Frame frame;
    TableModel dataModel = new AbstractTableModel(){

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return StudentSetupReport.this.roster == null ? 0 : StudentSetupReport.this.roster.getStudentCount();
        }

        public Object getValueAt(int row, int col) {
            if (StudentSetupReport.this.roster == null) {
                return "";
            }
            StudentRosterItem student = StudentSetupReport.this.roster.studentAt(row);
            if (col == COLM_NAME) {
                return student.getFullNameLastFirst();
            }
            if (col == COLM_ID) {
                return student.getIPasID();
            }
            if (col == COLM_PWD) {
                return StudentSetupReport.this.cbIncludePassword.isSelected() ? student.getPassword() : "***";
            }
            if (col == COLM_DB) {
                DataBase db = StudentSetupReport.this.dbManager.getDataBase(student.getDataBaseID());
                return db != null ? db.getHeader().getTitle() : "";
            }
            return "";
        }

        public String getColumnName(int col) {
            if (col == COLM_NAME) {
                return "Name";
            }
            if (col == COLM_ID) {
                return "ID";
            }
            if (col == COLM_PWD) {
                return "Password";
            }
            if (col == COLM_DB) {
                return "Database";
            }
            return null;
        }
    };
    int totalPages = 0;
    PropertyChangeListener printListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("printing")) {
                if (StudentSetupReport.this.printer.isPrinting()) {
                    StudentSetupReport.this._$21328("About to print...");
                } else if (StudentSetupReport.this.printer.isPrintDialogResponse()) {
                    StudentSetupReport.this._$21328("Printing finished.");
                    StudentSetupReport.this._$21329();
                    StudentSetupReport.this._$21330(StudentSetupReport.this.panelPreferences);
                }
            }
            if (evt.getPropertyName().equalsIgnoreCase("printDialogResponse")) {
                if (StudentSetupReport.this.printer.isPrintDialogResponse()) {
                    StudentSetupReport.this._$21328("Start printing...");
                    StudentSetupReport.this.totalPages = StudentSetupReport.this.printer.getPageable().getNumberOfPages();
                } else {
                    StudentSetupReport.this._$21328("Printing cancelled...");
                    StudentSetupReport.this._$21329();
                    StudentSetupReport.this._$21330(StudentSetupReport.this.panelPreferences);
                }
            }
            if (evt.getPropertyName().equalsIgnoreCase("pageBeingPrinted") && StudentSetupReport.this.printer.isPrinting() && StudentSetupReport.this.printer.getPageBeingPrinted() > 0) {
                StudentSetupReport.this.lblProgress.setText("Printing page " + StudentSetupReport.this.printer.getPageBeingPrinted() + " of " + StudentSetupReport.this.totalPages);
            }
        }
    };
    Border border2;
    VerticalFlowLayout verticalFlowLayout2 = new VerticalFlowLayout();
    JLabel lblProgress = new JLabel();
    JButton btnPageSetup = new JButton();
    JButton btnPreview = new JButton();
    JPanel jPanel9 = new JPanel();
    Border border3;
    Border border4;
    BorderLayout borderLayout5 = new BorderLayout();
    J2Printer printer = new J2Printer(Constants.J2PW_SN);
    CardLayout cardLayout1 = new CardLayout();
    Border border5;
    Border border6;
    Border border7;
    Border border8;
    JPanel jPanel7 = new JPanel();
    JPanel jPanel8 = new JPanel();
    JPanel jPanel10 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JRadioButton rbPrintRoster = new JRadioButton();
    JRadioButton rbPrintSelection = new JRadioButton();
    JRadioButton rbPrintHighlight = new JRadioButton();
    VerticalFlowLayout verticalFlowLayout3 = new VerticalFlowLayout();
    JPanel jPanel11 = new JPanel();
    BoxLayout2 boxLayout21 = new BoxLayout2();
    BorderLayout borderLayout6 = new BorderLayout();

    public StudentSetupReport(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this._$550();
            this.pack();
            this.setSize(new Dimension(500, 400));
            Utils.centerDialog(frame, this);
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public StudentSetupReport() {
        this((Frame)null, "", false);
    }

    public StudentSetupReport(Frame frame, DataBaseManager dbManager) {
        this(frame, "Student Setup Instructions", true);
        this.frame = frame;
        this.dbManager = dbManager;
        this.frontDB = dbManager.getFrontDataBase();
        this.printer.addPropertyChangeListener(this.printListener);
        this.printer.setPrintPreviewScale(1.25);
        this.roster = dbManager.getIPasLibrarian().getStudentRoster();
        if (!dbManager.getIPasDBOrganizer().checkIntegrity()) {
            this.setPrintButtonsEnabled(false);
        }
        this.setupRadioButtons();
        this._$21336();
        this._$21330(this.panelPreferences);
    }

    private void _$550() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(109, 109, 110), new Color(156, 156, 158)), BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border2 = BorderFactory.createEmptyBorder(10, 10, 0, 10);
        this.border3 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border4 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border5 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border6 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border7 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(109, 109, 110), new Color(156, 156, 158)), BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.border8 = BorderFactory.createEmptyBorder(10, 0, 0, 0);
        this.panel1.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.cardLayout1);
        this.btnDone.setPreferredSize(new Dimension(80, 23));
        this.btnDone.setToolTipText("");
        this.btnDone.setFocusPainted(false);
        this.btnDone.setText("Done");
        this.btnDone.addActionListener(new StudentProfileDialog_btnDone_actionAdapter(this));
        this.btnPrint.setPreferredSize(new Dimension(80, 23));
        this.btnPrint.setFocusPainted(false);
        this.btnPrint.setText("Print");
        this.btnPrint.addActionListener(new StudentProfileDialog_btnPrint_actionAdapter(this));
        this.jPanel1.setLayout(this.borderLayout3);
        this.panelPreferences.setLayout(this.verticalFlowLayout1);
        this.cbIncludePassword.setFocusPainted(false);
        this.cbIncludePassword.setSelected(true);
        this.cbIncludePassword.setText("Include the Student Password on each report.");
        this.jTextArea1.setFont(new Font("Dialog", 0, 12));
        this.jTextArea1.setBorder(this.border4);
        this.jTextArea1.setOpaque(false);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setText("This prints help sheets for students to aid them in setting up their home version of iPAS to access the online school account.  Each printout includes your online school account name and number and the students iPAS ID and password.   It is best to pass this help sheet out to each student participating in iPAS program before they install their home version of iPAS.");
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setWrapStyleWord(true);
        this.jPanel6.setLayout(this.borderLayout4);
        this.verticalFlowLayout1.setAlignment(1);
        this.verticalFlowLayout1.setVgap(15);
        this.panelProgress.setLayout(this.verticalFlowLayout2);
        this.lblProgress.setFont(new Font("Dialog", 1, 12));
        this.lblProgress.setForeground(Color.red);
        this.lblProgress.setHorizontalAlignment(0);
        this.lblProgress.setText("(status)");
        this.verticalFlowLayout2.setAlignment(1);
        this.btnPageSetup.setPreferredSize(new Dimension(120, 23));
        this.btnPageSetup.setFocusPainted(false);
        this.btnPageSetup.setText("Page Setup");
        this.btnPageSetup.addActionListener(new StudentProfileDialog_btnPageSetup_actionAdapter(this));
        this.btnPreview.setPreferredSize(new Dimension(120, 23));
        this.btnPreview.setFocusPainted(false);
        this.btnPreview.setText("Preview");
        this.btnPreview.addActionListener(new StudentProfileDialog_btnPreview_actionAdapter(this));
        this.jPanel9.setBackground(Color.lightGray);
        this.jPanel9.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPanel9.setLayout(this.borderLayout5);
        this.panel1.setBorder(this.border6);
        this.jPanel6.setBorder(null);
        this.jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPanel1.setBorder(this.border8);
        this.jPanel7.setLayout(this.borderLayout2);
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("Print a report for:");
        this.jLabel1.setVerticalAlignment(1);
        this.jPanel8.setLayout(this.verticalFlowLayout3);
        this.jPanel5.setLayout(this.boxLayout21);
        this.jPanel11.setMaximumSize(new Dimension(100, Short.MAX_VALUE));
        this.jPanel11.setPreferredSize(new Dimension(100, 10));
        this.jPanel10.setPreferredSize(new Dimension(100, 25));
        this.jPanel10.setLayout(this.borderLayout6);
        this.rbPrintHighlight.setFocusPainted(false);
        this.rbPrintHighlight.setText("Currently Highlighted Student");
        this.rbPrintRoster.addActionListener(new StudentProfileDialog_rbPrintRoster_actionAdapter(this));
        this.rbPrintSelection.setFocusPainted(false);
        this.rbPrintSelection.setText("Currently Selected Student List");
        this.rbPrintSelection.addActionListener(new StudentProfileDialog_rbPrintSelection_actionAdapter(this));
        this.rbPrintRoster.setFocusPainted(false);
        this.rbPrintRoster.setText("Entire iPAS Student Roster (All Classes)");
        this.rbPrintHighlight.addActionListener(new StudentProfileDialog_rbPrintHighlight_actionAdapter(this));
        this.verticalFlowLayout3.setHgap(0);
        this.verticalFlowLayout3.setVgap(0);
        this.jPanel1.add((Component)this.jPanel4, "West");
        this.jPanel4.add((Component)this.btnPageSetup, null);
        this.jPanel4.add((Component)this.btnPreview, null);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "South");
        this.panelPreferences.add((Component)this.jPanel7, null);
        this.jPanel7.add((Component)this.jPanel8, "Center");
        this.jPanel8.add((Component)this.jLabel1, null);
        this.jPanel8.add((Component)this.rbPrintRoster, null);
        this.jPanel8.add((Component)this.rbPrintSelection, null);
        this.jPanel8.add((Component)this.rbPrintHighlight, null);
        this.jPanel7.add((Component)this.jPanel10, "West");
        this.panelPreferences.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.jPanel11, null);
        this.jPanel5.add((Component)this.cbIncludePassword, null);
        this.jPanel2.add((Component)this.panelProgress, "panelProgress");
        this.panelProgress.add((Component)this.lblProgress, null);
        this.panel1.add((Component)this.jPanel6, "North");
        this.jPanel6.add((Component)this.jPanel9, "North");
        this.jPanel9.add((Component)this.jTextArea1, "Center");
        this.jPanel1.add((Component)this.jPanel3, "East");
        this.jPanel3.add((Component)this.btnPrint, null);
        this.jPanel3.add((Component)this.btnDone, null);
        this.panel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.panelPreferences, "panelPreferences");
    }

    private void _$21336() {
        File[] files = new File("lib/reports/Student Setup").listFiles();
        if (files != null) {
            for (int i2 = 0; i2 < files.length; ++i2) {
                if (!files[i2].getName().startsWith("temp.")) continue;
                files[i2].delete();
            }
        }
    }

    public void setupRadioButtons() {
        if (this.frontDB.getHighlightedRowID() == -1L) {
            this.rbPrintHighlight.setEnabled(false);
        }
        if (this.frontDB.getDescriptors().getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE) == null) {
            this.rbPrintSelection.setEnabled(false);
        }
        this.rbPrintRoster.setSelected(true);
        this.rbPrintSelection.setText(this.rbPrintSelection.getText() + " in " + this.frontDB.getHeader().getTitle());
        this.rbPrintHighlight.setText(this.rbPrintHighlight.getText() + " in " + this.frontDB.getHeader().getTitle());
    }

    public void setPrintButtonsEnabled(boolean enabled) {
        this.btnPrint.setEnabled(enabled);
        this.btnPageSetup.setEnabled(enabled);
        this.btnPreview.setEnabled(enabled);
    }

    private void _$21330(JPanel page) {
        this.panelPreferences.setVisible(page == this.panelPreferences);
        this.panelProgress.setVisible(page == this.panelProgress);
    }

    private void _$21328(String txt) {
        this._$21330(this.panelProgress);
        this.lblProgress.setText(txt);
    }

    private void _$21329() {
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void _$21338(StudentRosterItem student) {
        long dbID;
        DataBase db;
        String user = student.getFullNameLastFirst();
        String id = student.getIPasID();
        String pwd = "***";
        if (this.cbIncludePassword.isSelected()) {
            pwd = student.getPassword();
        }
        String dbName = (db = this.dbManager.getDataBase(dbID = student.getDataBaseID())) == null ? "DATABASE OFFLINE" : db.getHeader().getTitle();
        Settings settings = this.dbManager.getSettings();
        ProfileReportPanel panel = new ProfileReportPanel(this.frame, settings, dbName, user, id, pwd, this.cbIncludePassword.isSelected());
        J2PanelPrinter panelPrinter = new J2PanelPrinter(panel);
        this.printer.clearHeaders();
        this.printer.clearFooters();
        this.printer.addPageable(panelPrinter);
    }

    private boolean _$21341(int row) {
        try {
            IPasDescriptor descriptor = IPasDescriptor.aquire(this.frontDB.getDescriptors());
            Field field = this.frontDB.getSelectedRecords().getField(row, descriptor.getFieldIndex());
            IPasStudentTable table = (IPasStudentTable)descriptor.toWrapper(field);
            String id = table.getIPasID();
            StudentRosterItem student = this.roster.findStudent(id);
            this._$21338(student);
            return true;
        }
        catch (IOException ex2) {
            return false;
        }
    }

    private boolean _$21342() {
        int numStudents = this.roster.getStudentCount();
        if (numStudents == 0) {
            return false;
        }
        for (int i2 = 0; i2 < numStudents; ++i2) {
            this._$21338(this.roster.studentAt(i2));
        }
        return true;
    }

    private boolean _$21344() {
        long rowID = this.frontDB.getHighlightedRowID();
        int row = this.frontDB.getSelectedRecords().indexOf(rowID);
        this._$21341(row);
        return true;
    }

    private boolean _$21346() {
        RecordList records = this.frontDB.getSelectedRecords();
        int len = records.getRecordCount();
        if (len == 0) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            this._$21341(i2);
        }
        return true;
    }

    private boolean _$21347() {
        this.printer.clearPageable();
        if (this.rbPrintSelection.isSelected()) {
            return this._$21346();
        }
        if (this.rbPrintHighlight.isSelected()) {
            return this._$21344();
        }
        if (this.rbPrintRoster.isSelected()) {
            return this._$21342();
        }
        return false;
    }

    void btnPrint_actionPerformed(ActionEvent e2) {
        if (this._$21347()) {
            this.printer.print();
        }
    }

    void btnPageSetup_actionPerformed(ActionEvent e2) {
        this.printer.showPageSetupDialog();
    }

    void btnPreview_actionPerformed(ActionEvent e2) {
        if (this._$21347()) {
            this.printer.showPrintPreviewDialog(this.frame);
        }
    }

    void btnDone_actionPerformed(ActionEvent e2) {
        this.hide();
    }

    void rbPrint_actionPerformed(ActionEvent e2) {
        this.rbPrintSelection.setSelected(e2.getSource() == this.rbPrintSelection);
        this.rbPrintRoster.setSelected(e2.getSource() == this.rbPrintRoster);
        this.rbPrintHighlight.setSelected(e2.getSource() == this.rbPrintHighlight);
    }
}

