/*
 * Decompiled with CFR 0.152.
 */
package pymo.io;

import java.io.File;
import java.io.IOException;
import pymo.descriptors.DescriptorList;
import pymo.descriptors.DescriptorReader;
import pymo.descriptors.IPasDescriptor;
import pymo.io.MOFileHeader;
import pymo.io.MOFileReader;

class FileManagerFile {
    String title = "";
    String path = null;
    String fileName = null;
    boolean ipas = false;

    public FileManagerFile(String path) {
        File file = new File(path);
        try {
            MOFileReader reader = new MOFileReader(file);
            MOFileHeader header = new MOFileHeader(reader);
            DescriptorList descriptors = new DescriptorReader(reader, null).readList();
            reader.close();
            this.ipas = descriptors.getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE) != null;
            StringBuffer str = new StringBuffer();
            str.append(header.getTitle());
            str.append(" (");
            str.append(file.getName());
            str.append(")");
            this.title = str.toString();
            this.path = path;
            this.fileName = file.getName();
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
    }

    public String toString() {
        return this.title;
    }

    public String getPath() {
        return this.path;
    }

    public boolean renameTo(String newName) {
        new File(this.path).renameTo(new File(newName));
        this.path = newName;
        return new File(newName).exists();
    }

    public boolean erase() {
        new File(this.path).delete();
        return !new File(this.path).exists();
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean hasIPasDescriptor() {
        return this.ipas;
    }
}

