/*
 * Decompiled with CFR 0.152.
 */
package pymo.io;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.Timestamp;

public class MOFileWriter {
    public static int OPEN = 0;
    public static int RESET = 1;
    private RandomAccessFile _$1910 = null;
    private String _$1611 = "unknown";

    public MOFileWriter() {
    }

    public MOFileWriter(File file, int mode) throws IOException {
        if (mode == RESET) {
            file.delete();
        }
        this._$1910 = new RandomAccessFile(file, "rw");
    }

    public MOFileWriter(String fileName, int mode) throws IOException {
        this.open(fileName, mode);
    }

    public void open(String fileName, int mode) throws IOException {
        this.close();
        if (mode == RESET) {
            new File(fileName).delete();
        }
        this._$1910 = new RandomAccessFile(fileName, "rw");
        this._$1611 = fileName;
    }

    public void close() throws IOException {
        if (this._$1910 != null) {
            this._$1910.close();
        }
        this._$1910 = null;
    }

    public void writeByte(int v2) throws IOException {
        this._$1910.writeByte(v2);
    }

    public void writeShort(short v2) throws IOException {
        this._$1910.writeShort(v2);
    }

    public void writeInt(int v2) throws IOException {
        this._$1910.writeInt(v2);
    }

    public void writeLong(long v2) throws IOException {
        this._$1910.writeLong(v2);
    }

    public void writeDouble(double v2) throws IOException {
        this._$1910.writeDouble(v2);
    }

    public void writeTimestamp(Timestamp timestamp) throws IOException {
        if (timestamp == null) {
            this._$1910.writeLong(0L);
        } else {
            this._$1910.writeLong(timestamp.getTime());
        }
    }

    public void writeRectangle(Rectangle v2) throws IOException {
        if (v2 == null) {
            v2 = new Rectangle();
        }
        this._$1910.writeShort(v2.x);
        this._$1910.writeShort(v2.y);
        this._$1910.writeShort(v2.width);
        this._$1910.writeShort(v2.height);
    }

    public void writeSmallString(String s2) throws IOException {
        int len = s2.length();
        if (len > 255) {
            throw new IOException("String size > 255");
        }
        this._$1910.writeByte(len);
        for (int i2 = 0; i2 < len; ++i2) {
            this._$1910.writeByte((byte)s2.charAt(i2));
        }
    }

    public void writeByteArray(byte[] b2) throws IOException {
        this._$1910.write(b2);
    }

    public void writeFixedString(String s2, int fixedSize) throws IOException {
        if (s2 == null) {
            for (int i2 = 0; i2 < fixedSize; ++i2) {
                this._$1910.writeByte(0);
            }
            return;
        }
        for (int i3 = 0; i3 < fixedSize; ++i3) {
            if (i3 < s2.length()) {
                this._$1910.writeByte((byte)s2.charAt(i3));
                continue;
            }
            this._$1910.writeByte(0);
        }
    }

    public void writeSig(String sig) throws IOException {
        this.writeFixedString(sig, 4);
    }

    public void writeClusterHeader(String sig, int clusterSize) throws IOException {
        this.writeSig(sig);
        this.writeInt(clusterSize);
    }

    public void writeClusterMarker(String sig) throws IOException {
        this.writeClusterHeader(sig, 0);
    }

    public void seek(long pos) throws IOException {
        this._$1910.seek(pos);
    }

    public long getFileLength() throws IOException {
        return this._$1910.length();
    }

    public String getFileName() {
        return this._$1611;
    }

    public long getCurrentPosition() throws IOException {
        return this._$1910.getFilePointer();
    }
}

