/*
 * Decompiled with CFR 0.152.
 */
package pymo.io;

import com.borland.jbcl.layout.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pymo.dataBases.DataBase;
import pymo.dataBases.DataBaseManager;
import pymo.descriptors.IPasDescriptor;
import pymo.io.MOFileHeader;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;
import pymo.io.NewTemplateDialog;
import pymo.security.Constants;
import pymo.security.FilePath;
import pyware.toolkit.Utils;

public class TemplateEditorDialog
extends JDialog {
    private JPanel _$1763 = new JPanel();
    private JButton _$16453 = new JButton();
    private JButton _$16454 = new JButton();
    private JButton _$15900 = new JButton();
    private JButton _$3295 = new JButton();
    private Frame _$7451;
    private DataBaseManager _$531;
    private Vector _$16455 = new Vector();
    private Vector _$16456 = new Vector();
    private JLabel _$16457 = new JLabel();
    private JScrollPane _$16458 = new JScrollPane();
    private JList _$16459 = new JList();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    Border border1;

    public TemplateEditorDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this._$7451 = frame;
        try {
            this._$550();
            Utils.centerDialog(frame, this);
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public TemplateEditorDialog() {
        this((Frame)null, "", false);
    }

    public TemplateEditorDialog(Frame frame, DataBaseManager dbManager) {
        this(frame, "Template Editor", true);
        this._$531 = dbManager;
        this._$16460();
    }

    private void _$550() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 0, 0);
        this.setSize(new Dimension(400, 310));
        this._$1763.setLayout(this.borderLayout2);
        this._$16453.setFont(new Font("Dialog", 0, 10));
        this._$16453.setFocusPainted(false);
        this._$16453.setText("Add Template");
        this._$16453.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                TemplateEditorDialog.this._$16461(e2);
            }
        });
        this._$16454.setEnabled(false);
        this._$16454.setFont(new Font("Dialog", 0, 10));
        this._$16454.setFocusPainted(false);
        this._$16454.setText("Rename Template");
        this._$16454.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                TemplateEditorDialog.this._$16462(e2);
            }
        });
        this._$15900.setEnabled(false);
        this._$15900.setFont(new Font("Dialog", 0, 10));
        this._$15900.setFocusPainted(false);
        this._$15900.setText("Delete Template");
        this._$15900.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                TemplateEditorDialog.this._$15917(e2);
            }
        });
        this._$3295.setPreferredSize(new Dimension(80, 23));
        this._$3295.setText("Okay");
        this._$3295.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                TemplateEditorDialog.this._$12325(e2);
            }
        });
        this._$16457.setToolTipText("");
        this._$16457.setHorizontalAlignment(0);
        this._$16457.setText("Templates");
        this._$16459.setBorder(BorderFactory.createEtchedBorder());
        this._$16459.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                TemplateEditorDialog.this._$16463(e2);
            }
        });
        this.jPanel2.setLayout(this.borderLayout1);
        this.jPanel3.setLayout(this.borderLayout3);
        this.jPanel1.setLayout(this.verticalFlowLayout1);
        this.verticalFlowLayout1.setAlignment(1);
        this.jPanel2.setBorder(this.border1);
        this.getContentPane().add(this._$1763);
        this._$1763.add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this._$16453, null);
        this.jPanel1.add((Component)this._$16454, null);
        this.jPanel1.add((Component)this._$15900, null);
        this._$1763.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this._$16458, "Center");
        this._$16458.getViewport().add((Component)this._$16459, null);
        this.jPanel2.add((Component)this._$16457, "North");
        this._$1763.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.jPanel4, "East");
        this.jPanel4.add((Component)this._$3295, null);
    }

    private void _$16460() {
        this._$16455.removeAllElements();
        this._$16456.removeAllElements();
        try {
            File directory = new File(FilePath.toTemplates());
            if (!directory.exists()) {
                return;
            }
            File[] fileList = directory.listFiles();
            for (int i2 = 0; i2 < fileList.length; ++i2) {
                String fileName;
                File aFile = fileList[i2];
                if (!aFile.isFile() || !FilePath.hasSuffix(fileName = aFile.getPath(), Constants.TEMPLATE_SUFFIX)) continue;
                MOFileReader reader = new MOFileReader(fileName);
                MOFileHeader header = new MOFileHeader(reader);
                this._$16456.add(header.getTitle());
                this._$16455.add(fileName);
                reader.close();
            }
            this._$16459.setListData(this._$16456);
        }
        catch (IOException e2) {
            Utils.showErrorMessage(this._$7451, e2, "Error building template list");
        }
    }

    private boolean _$16464(String description) {
        for (int i2 = 0; i2 < this._$16456.size(); ++i2) {
            String test = (String)this._$16456.elementAt(i2);
            if (test.compareToIgnoreCase(description) != 0) continue;
            return true;
        }
        return false;
    }

    private void _$9149() {
        try {
            NewTemplateDialog dialog = new NewTemplateDialog(this._$7451, this._$531);
            dialog.show();
            if (!dialog.okayClicked) {
                return;
            }
            DataBase db = this._$531.getFrontDataBase();
            String uniquePath = FilePath.toTemplates(Long.toString(System.currentTimeMillis()) + Constants.TEMPLATE_SUFFIX);
            MOFileWriter writer = new MOFileWriter(uniquePath, MOFileWriter.RESET);
            MOFileHeader header = new MOFileHeader(db.getHeader());
            header.setTitle(dialog.getDescription());
            header.create(writer);
            db.getDescriptors().appendTo(writer);
            writer.close();
            Vector<IPasDescriptor> deletionList = new Vector<IPasDescriptor>();
            db = new DataBase(this._$531, uniquePath, DataBase.INVISIBLE);
            IPasDescriptor d2 = (IPasDescriptor)db.getDescriptors().getDescriptor(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE);
            if (d2 != null) {
                deletionList.addElement(d2);
            }
            db.deleteDescriptors(deletionList);
            db.save();
            db.close();
        }
        catch (IOException e2) {
            Utils.showErrorMessage(this._$7451, e2, "Create Template");
        }
    }

    private void _$16467(int index) {
        try {
            String path = (String)this._$16455.elementAt(index);
            MOFileReader reader = new MOFileReader(path);
            MOFileHeader header = new MOFileHeader(reader);
            reader.close();
            String newDescription = (String)JOptionPane.showInputDialog(this, "Enter new description", "Rename", 3, null, null, header.getTitle());
            if (newDescription == null | newDescription == "") {
                return;
            }
            if (this._$16464(newDescription)) {
                JOptionPane.showMessageDialog(this._$7451, "Template description [" + newDescription + "] already exists.");
                return;
            }
            header.setTitle(newDescription);
            MOFileWriter writer = new MOFileWriter(path, MOFileWriter.OPEN);
            header.write(writer);
            writer.close();
            this._$16460();
            this._$15900.setEnabled(false);
            this._$16454.setEnabled(false);
        }
        catch (IOException e12) {
            Utils.showErrorMessage(this._$7451, e12, "Error");
        }
    }

    private void _$16469(int index) {
        String description = (String)this._$16456.elementAt(index);
        if (JOptionPane.showConfirmDialog(this, "Okay to delete " + description + "?", "Template Editor", 0) != 0) {
            return;
        }
        String fileName = (String)this._$16455.elementAt(index);
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        this._$16460();
        this._$15900.setEnabled(false);
        this._$16454.setEnabled(false);
    }

    private void _$16463(ListSelectionEvent e2) {
        this._$15900.setEnabled(true);
        this._$16454.setEnabled(true);
    }

    private void _$16461(ActionEvent e2) {
        this._$9149();
        this._$16460();
        this._$15900.setEnabled(false);
        this._$16454.setEnabled(false);
    }

    private void _$16462(ActionEvent e2) {
        int index = this._$16459.getSelectedIndex();
        if (index != -1) {
            this._$16467(index);
        }
    }

    private void _$15917(ActionEvent e2) {
        int index = this._$16459.getSelectedIndex();
        if (index != -1) {
            this._$16469(index);
        }
    }

    private void _$12325(ActionEvent e2) {
        this.hide();
    }
}

