/*
 * Decompiled with CFR 0.152.
 */
package pymo.mailer;

import ipworksssl.Filemailers;
import ipworksssl.FilemailersConnectionStatusEvent;
import ipworksssl.FilemailersEndTransferEvent;
import ipworksssl.FilemailersErrorEvent;
import ipworksssl.FilemailersEventListener;
import ipworksssl.FilemailersPITrailEvent;
import ipworksssl.FilemailersSSLServerAuthenticationEvent;
import ipworksssl.FilemailersSSLStatusEvent;
import ipworksssl.FilemailersStartTransferEvent;
import ipworksssl.FilemailersTransferEvent;
import ipworksssl.IPWorksSSLException;
import java.sql.Timestamp;
import java.util.Vector;
import pymo.mailer.Mail;
import pymo.mailer.MailerEvent;
import pymo.mailer.MailerListener;
import pymo.security.Constants;
import pymo.security.Settings;
import pyware.toolkit.Decoder;
import pyware.toolkit.IniFile;

public class Mailer
implements FilemailersEventListener {
    private Vector _$7407 = new Vector();
    private Filemailers _$18384 = null;
    private Decoder _$4013;
    private String _$4014;
    private String _$4015;
    private String _$8293;
    private String _$18385;
    private String _$18386;
    private long _$18387;
    private Settings _$2752;
    private Mail _$18388;
    private boolean _$18389 = false;
    private String _$18390;
    private String _$18391;
    private String _$18392;
    private int _$18393;
    private int _$18394;

    public Mailer(Settings settings) {
        try {
            this._$2752 = settings;
            this._$4013 = new Decoder();
            IniFile params = new IniFile(Constants.FTP_PARAMETERS_FILE_PATH);
            this._$4014 = params.getLine("MAIL", "H", "");
            this._$4015 = params.getLine("MAIL", "U", "");
            this._$8293 = params.getLine("MAIL", "P", "");
            this._$18385 = params.getLine("MAIL", "C", "");
            this._$18386 = settings.getServerID();
            this._$18389 = params.getBoolLine("Firewall", "Enable", false);
            if (this._$18389) {
                this._$18390 = params.getEncodedLine("Firewall", "Host", "");
                this._$18391 = params.getEncodedLine("Firewall", "User", "");
                this._$18392 = params.getEncodedLine("Firewall", "Password", "");
                this._$18393 = new Integer(params.getEncodedLine("Firewall", "Port", "0"));
                String type = params.getEncodedLine("Firewall", "Type", "Tunnel");
                if (type.equalsIgnoreCase("tunnel")) {
                    this._$18394 = 1;
                }
                if (type.equalsIgnoreCase("socks4")) {
                    this._$18394 = 2;
                }
                if (type.equalsIgnoreCase("socks5")) {
                    this._$18394 = 3;
                }
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public void connectionStatus(FilemailersConnectionStatusEvent e2) {
    }

    public void endTransfer(FilemailersEndTransferEvent e2) {
    }

    public void PITrail(FilemailersPITrailEvent e2) {
        if (e2.message.toUpperCase().startsWith("CONNECTED")) {
            this._$18402(MailerEvent.ACTION_CONNECTED);
        }
        if (Constants.OVERRIDE_SECURITY) {
            System.out.println("Mailer Trace --->" + e2.message);
        }
    }

    public void startTransfer(FilemailersStartTransferEvent e2) {
    }

    public void SSLServerAuthentication(FilemailersSSLServerAuthenticationEvent e2) {
        if (Constants.OVERRIDE_SECURITY) {
            System.out.println("SSL Authentication --->" + e2.certIssuer);
        }
        if (!e2.accept) {
            try {
                if (this._$18384 != null) {
                    this._$18384.interrupt();
                }
            }
            catch (IPWorksSSLException iPWorksSSLException) {
                // empty catch block
            }
            this._$18410("Illegal mailer access.");
        }
    }

    public void SSLStatus(FilemailersSSLStatusEvent e2) {
        if (Constants.OVERRIDE_SECURITY) {
            System.out.println("Mailer Status --->" + e2.message);
        }
    }

    public void transfer(FilemailersTransferEvent e2) {
        int percent = new Double((double)(e2.bytesTransferred * 100L) / ((double)this._$18387 * 1.5)).intValue();
        this._$18416(percent);
    }

    public void error(FilemailersErrorEvent e2) {
        if (Constants.OVERRIDE_SECURITY) {
            System.out.println("Mailer Error --->" + e2.description);
        }
        this._$18410(e2.description);
    }

    private void _$18418() {
        int count = this._$2752.getIntLine("EMail", "Count", 0) + 1;
        this._$2752.setIntLine("EMail", "Count", count);
        this._$2752.trySave();
    }

    public boolean isMailerBusy() {
        if (this._$18384 == null) {
            return false;
        }
        return this._$18384.isConnected();
    }

    public void cancel() {
        try {
            if (this._$18384 != null && this.isMailerBusy()) {
                this._$18384.interrupt();
            }
        }
        catch (IPWorksSSLException iPWorksSSLException) {
            // empty catch block
        }
    }

    public void run() {
        try {
            this._$18402(MailerEvent.ACTION_CONNECTING);
            this._$18387 = this._$18388.getSize();
            this._$18384 = new Filemailers();
            this._$18384.setMailPort(465);
            if (Constants.OVERRIDE_SECURITY) {
                System.out.println(this._$4013.decode(this._$4014).replaceAll("<sid>", this._$18386));
                System.out.println(this._$4013.decode(this._$4015).replaceAll("<sid>", this._$18386));
                System.out.println(this._$4013.decode(this._$8293));
            }
            this._$18384.setMailServer(this._$4013.decode(this._$4014).replaceAll("<sid>", this._$18386));
            this._$18384.setUser(this._$4013.decode(this._$4015).replaceAll("<sid>", this._$18386));
            this._$18384.setPassword(this._$4013.decode(this._$8293));
            if (this._$18389) {
                this._$18384.setFirewallHost(this._$18390);
                this._$18384.setFirewallUser(this._$18391);
                this._$18384.setFirewallPassword(this._$18392);
                this._$18384.setFirewallType(this._$18394);
                if (this._$18393 != 0) {
                    this._$18384.setFirewallPort(this._$18393);
                }
            }
            this._$18384.setSSLAcceptServerCert(this._$4013.decode(this._$18385));
            this._$18384.setMessageId("*");
            this._$18384.setSendTo(this._$18388.getSendTo());
            this._$18384.setFrom(this._$18388.getFrom());
            this._$18384.setSubject(this._$18388.getSubject());
            this._$18384.setMessageText(this._$18388.getMessage());
            this._$18384.setReplyTo(this._$18388.getReplyTo());
            Vector attachments = this._$18388.getAttachments();
            for (int i2 = 0; i2 < attachments.size(); ++i2) {
                this._$18384.addAttachment((String)attachments.elementAt(i2));
            }
            this._$18384.addFilemailersEventListener(this);
            this._$18384.send();
            this._$18384.removeFilemailersEventListener(this);
            this._$18418();
            this._$18402(MailerEvent.ACTION_SENT);
        }
        catch (Exception ex2) {
            this._$18410(ex2.getMessage());
            ex2.printStackTrace();
        }
        this._$18384 = null;
    }

    public boolean checkEMailAbuse() {
        if (this._$2752.getLine("EMail", "Time", null) == null) {
            this._$2752.setTimeStampLine("EMail", "Time", new Timestamp(System.currentTimeMillis()));
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Timestamp time = this._$2752.getTimeStampLine("EMail", "Time", new Timestamp(System.currentTimeMillis()));
        if (time.before(now)) {
            Timestamp nextTime = new Timestamp(System.currentTimeMillis() + Constants.TOTAL_EMAIL_TIME_LIMIT * Constants.MILLIS_PER_HOUR);
            this._$2752.setTimeStampLine("EMail", "Time", nextTime);
            this._$2752.setIntLine("EMail", "Count", 0);
        } else {
            int count = this._$2752.getIntLine("EMail", "Count", 0);
            if (count > Constants.TOTAL_EMAIL_COUNT_LIMIT) {
                this._$18410("You can only send " + Constants.TOTAL_EMAIL_COUNT_LIMIT + " emails every " + Constants.TOTAL_EMAIL_TIME_LIMIT + " hours.");
                return false;
            }
        }
        return true;
    }

    public boolean send(Mail mail) {
        if (!this.checkEMailAbuse()) {
            return false;
        }
        this._$18388 = mail;
        this.run();
        return true;
    }

    public synchronized void addListener(MailerListener listener) {
        this._$7407.addElement(listener);
    }

    public synchronized void removeListener(MailerListener listener) {
        if (listener != null) {
            this._$7407.removeElement(listener);
        }
    }

    private void _$18416(int progress) {
        MailerEvent e2 = MailerEvent.createProgressEvent(this, progress);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((MailerListener)this._$7407.elementAt(i2)).mailProgress(e2);
        }
    }

    private void _$18410(String error) {
        MailerEvent e2 = MailerEvent.createMailerErrorEvent(this, error);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((MailerListener)this._$7407.elementAt(i2)).mailError(e2);
        }
    }

    private void _$18402(int type) {
        MailerEvent e2 = MailerEvent.createActionEvent(this, type);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((MailerListener)this._$7407.elementAt(i2)).mailAction(e2);
        }
    }
}

