/*
 * Decompiled with CFR 0.152.
 */
package pymo.menus;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import pymo.dataBases.DataBase;
import pymo.dataBases.DataBaseManager;
import pymo.iPasDBTools.IPasAnnouncementEditor;
import pymo.iPasDBTools.IPasTeacherManager;
import pymo.iPasDBTools.Scheduler;
import pymo.iPasDBTools.reports.IPasReportSelectorDialog;
import pymo.security.ApplicationOptionsDialog;
import pymo.security.Settings;
import pyware.toolkit.Utils;

public class IPasMenu
extends JMenu {
    private JFrame _$7451;
    private DataBaseManager _$531;
    private JMenuItem _$9935 = new JMenuItem();
    private JMenuItem _$9936 = new JMenuItem();
    private JMenuItem _$9937 = new JMenuItem();
    private JMenuItem _$9938 = new JMenuItem();
    private JMenuItem _$9939 = new JMenuItem();

    public IPasMenu() {
        try {
            this._$550();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public IPasMenu(JFrame mainFrame, DataBaseManager dbManager) {
        this();
        this._$7451 = mainFrame;
        this._$531 = dbManager;
    }

    private void _$550() {
        this.setText("iPAS");
        this._$9935.setText("Schedule Assignments");
        this._$9935.setEnabled(true);
        this._$9935.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IPasMenu.this.assignmentScheduler();
            }
        });
        this._$9936.setText("Send/Receive Assignments");
        this._$9936.setEnabled(true);
        this._$9936.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IPasMenu.this.lessonUploader();
            }
        });
        this._$9937.setText("Edit Announcements");
        this._$9937.setEnabled(true);
        this._$9937.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IPasMenu.this.announcementEditor();
            }
        });
        this._$9939.setText("iPAS Reports");
        this._$9939.setEnabled(true);
        this._$9939.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IPasMenu.this.reports();
            }
        });
        this._$9938.setText("iPAS Interface Setup");
        this._$9938.setEnabled(true);
        this._$9938.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                IPasMenu.this.ipasSetup();
            }
        });
        this.add(this._$9936);
        this.add(this._$9935);
        this.add(this._$9937);
        this.add(this._$9938);
        this.add(this._$9939);
    }

    public void menuSelectionChanged(boolean isIncluded) {
        try {
            this._$531.saveAllDataBases();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "Saving All DataBases");
        }
        DataBase frontDB = this._$531.getFrontDataBase();
        super.menuSelectionChanged(isIncluded);
    }

    public void assignmentScheduler() {
        try {
            DataBase db = this._$531.getFrontDataBase();
            if (db == null) {
                return;
            }
            new Scheduler((Frame)this._$7451, db).show();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "iPAS Teacher Assignment Scheduler");
        }
    }

    private boolean _$9944() {
        Settings settings = this._$531.getSettings();
        if (settings.isRestrictionSet(Settings.FTP_RESTRICTION)) {
            JOptionPane.showMessageDialog(this._$7451, "This installation of " + settings.getApplicationName() + " is restricted from online access.");
            return false;
        }
        return true;
    }

    public void lessonUploader() {
        if (!this._$9944()) {
            return;
        }
        try {
            new IPasTeacherManager((Frame)this._$7451, this._$531).show();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "iPAS Teacher Assignment Uploader");
        }
    }

    public void announcementEditor() {
        try {
            DataBase db = this._$531.getFrontDataBase();
            if (db == null) {
                return;
            }
            new IPasAnnouncementEditor((Frame)this._$7451, db).show();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "iPAS Announcement Editor");
        }
    }

    public void ipasSetup() {
        try {
            new ApplicationOptionsDialog((Frame)this._$7451, this._$531.getIPasLibrarian(), this._$531.getSettings(), ApplicationOptionsDialog.IPAS_TAB).show();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "iPAS Setup");
        }
    }

    public void reports() {
        try {
            new IPasReportSelectorDialog((Frame)this._$7451, this._$531).show();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "iPAS Reports");
        }
    }
}

