/*
 * Decompiled with CFR 0.152.
 */
package pymo.menus;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import pymo.dataBases.DataBase;
import pymo.dataBases.DataBaseManager;
import pymo.descriptors.SearchDescriptor;
import pymo.records.RecordList;
import pymo.searcher.SearchDialogII;
import pymo.searcher.SearchModel;
import pymo.searcher.Searcher;
import pyware.toolkit.Utils;

public class SearchMenu
extends JMenu {
    private JFrame _$7451;
    private DataBaseManager _$531;
    private JMenuItem[] _$9479 = new JMenuItem[0];
    private JMenuItem _$9480 = new JMenuItem();
    private JMenuItem _$9481 = new JMenuItem();
    private JMenuItem _$9482 = new JMenuItem();

    public SearchMenu() {
        try {
            this._$550();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public SearchMenu(JFrame mainFrame, DataBaseManager dbManager) {
        this();
        this._$7451 = mainFrame;
        this._$531 = dbManager;
    }

    private void _$550() {
        this.setText("Search");
        this._$9481.setText("Search entire database for...");
        this._$9481.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this._$9481.setEnabled(false);
        this._$9481.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                SearchMenu.this.search();
            }
        });
        this._$9480.setText("Search current list for... (refine search)");
        this._$9480.setEnabled(false);
        this._$9480.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                SearchMenu.this.refineSearch();
            }
        });
        this._$9482.setText("Display All");
        this._$9482.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this._$9482.setEnabled(false);
        this._$9482.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                SearchMenu.this.selectAll();
            }
        });
        this.add(this._$9481);
        this.add(this._$9480);
        this.add(this._$9482);
        this.addSeparator();
    }

    private void _$9484() {
        DataBase db = this._$531.getFrontDataBase();
        if (db == null) {
            return;
        }
        for (int i2 = 0; i2 < this._$9479.length; ++i2) {
            this.remove(this._$9479[i2]);
        }
        SearchDescriptor descriptor = SearchDescriptor.aquire(db.getDescriptors());
        Vector modelNameList = descriptor.getModelNameList();
        int len = modelNameList.size();
        this._$9479 = new JMenuItem[len];
        for (int i3 = 0; i3 < len; ++i3) {
            JMenuItem menuItem = new JMenuItem((String)modelNameList.elementAt(i3));
            menuItem.setActionCommand(Integer.toString(i3));
            menuItem.setEnabled(false);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    SearchMenu.this.presetSearchSelected(Integer.parseInt(e2.getActionCommand()));
                }
            });
            this.add(menuItem);
            this._$9479[i3] = menuItem;
        }
    }

    private void _$9489(boolean enabled) {
        for (int i2 = 0; i2 < this._$9479.length; ++i2) {
            this._$9479[i2].setEnabled(enabled);
        }
    }

    public void menuSelectionChanged(boolean isIncluded) {
        try {
            this._$531.saveAllDataBases();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "Saving All DataBases");
        }
        this._$9484();
        DataBase frontDB = this._$531.getFrontDataBase();
        this._$9481.setEnabled(false);
        this._$9480.setEnabled(false);
        this._$9482.setEnabled(false);
        if (frontDB != null) {
            int numSelected = frontDB.getTotalSelectedRecords();
            int totRecords = frontDB.getTotalRecords();
            if (totRecords > 0) {
                this._$9489(true);
                if (numSelected == totRecords) {
                    this._$9481.setEnabled(true);
                }
                if (numSelected > 0) {
                    this._$9481.setEnabled(true);
                    this._$9482.setEnabled(true);
                }
                if (numSelected > 1) {
                    this._$9480.setEnabled(true);
                }
                if (numSelected == 0) {
                    this._$9482.setEnabled(true);
                }
            }
        }
        super.menuSelectionChanged(isIncluded);
    }

    public void presetSearchSelected(int index) {
        DataBase db = this._$531.getFrontDataBase();
        if (db == null) {
            return;
        }
        SearchDescriptor descriptor = SearchDescriptor.aquire(db.getDescriptors());
        try {
            SearchModel searchModel = descriptor.searchModelAt(index);
            RecordList newSelection = new Searcher(db).linearSearch(db.getRecords(), searchModel);
            db.setSelectedRecords(newSelection);
        }
        catch (IOException e2) {
            Utils.showErrorMessage(this._$7451, e2, "Search Error");
        }
    }

    public void refineSearch() {
        try {
            this._$531.saveAllDataBases();
            DataBase db = this._$531.getFrontDataBase();
            if (db == null) {
                return;
            }
            SearchDialogII srch = new SearchDialogII((Frame)this._$7451, db, db.getSelectedRecords());
            srch.show();
            if (srch.wasOkayPressed()) {
                db.setSelectedRecords(srch.getResult());
            }
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "Refine Search Error");
        }
    }

    public void search() {
        try {
            DataBase db = this._$531.getFrontDataBase();
            if (db == null) {
                return;
            }
            SearchDialogII srch = new SearchDialogII((Frame)this._$7451, db, db.getRecords());
            srch.show();
            if (srch.wasOkayPressed()) {
                db.setSelectedRecords(srch.getResult());
            }
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "Search Error");
        }
    }

    public void selectAll() {
        try {
            DataBase db = this._$531.getFrontDataBase();
            if (db == null) {
                return;
            }
            db.save();
            db.resetSelectedRecords();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "Select All Error");
        }
    }
}

