/*
 * Decompiled with CFR 0.152.
 */
package pymo.menus;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import pymo.dataBases.DataBase;
import pymo.dataBases.DataBaseManager;
import pymo.descriptors.SortDescriptor;
import pymo.sorter.SortDialogII;
import pymo.sorter.SortModel;
import pymo.sorter.Sorter;
import pyware.toolkit.Utils;

public class SortMenu
extends JMenu {
    private JFrame _$7451;
    private DataBaseManager _$531;
    private JMenuItem[] _$9479 = new JMenuItem[0];
    private JMenuItem _$9627 = new JMenuItem();

    public SortMenu() {
        try {
            this._$550();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public SortMenu(JFrame mainFrame, DataBaseManager dbManager) {
        this();
        this._$531 = dbManager;
        this._$7451 = mainFrame;
    }

    private void _$550() {
        this.setText("Sort");
        this._$9627.setText("Sort current list...");
        this._$9627.setEnabled(false);
        this._$9627.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                SortMenu.this.sort();
            }
        });
        this.add(this._$9627);
        this.addSeparator();
    }

    private void _$9628() {
        DataBase db = this._$531.getFrontDataBase();
        if (db == null) {
            return;
        }
        for (int i2 = 0; i2 < this._$9479.length; ++i2) {
            this.remove(this._$9479[i2]);
        }
        SortDescriptor descriptor = SortDescriptor.aquire(db.getDescriptors());
        Vector modelNameList = descriptor.getModelNameList();
        int len = modelNameList.size();
        this._$9479 = new JMenuItem[len];
        for (int i3 = 0; i3 < len; ++i3) {
            JMenuItem menuItem = new JMenuItem((String)modelNameList.elementAt(i3));
            menuItem.setActionCommand(Integer.toString(i3));
            menuItem.setEnabled(false);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    SortMenu.this.presetSortSelected(Integer.parseInt(e2.getActionCommand()));
                }
            });
            this.add(menuItem);
            this._$9479[i3] = menuItem;
        }
    }

    private void _$9489(boolean enabled) {
        for (int i2 = 0; i2 < this._$9479.length; ++i2) {
            this._$9479[i2].setEnabled(enabled);
        }
    }

    public void menuSelectionChanged(boolean isIncluded) {
        int numSelected;
        try {
            this._$531.saveAllDataBases();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "Saving All DataBases");
        }
        this._$9628();
        DataBase frontDB = this._$531.getFrontDataBase();
        this._$9627.setEnabled(false);
        if (frontDB != null && (numSelected = frontDB.getTotalSelectedRecords()) > 0) {
            this._$9627.setEnabled(true);
            this._$9489(true);
        }
        super.menuSelectionChanged(isIncluded);
    }

    public void presetSortSelected(int index) {
        DataBase db = this._$531.getFrontDataBase();
        if (db == null) {
            return;
        }
        SortDescriptor descriptor = SortDescriptor.aquire(db.getDescriptors());
        try {
            SortModel sortModel = descriptor.sortModelAt(index);
            new Sorter(db).sort(db.getSelectedRecords(), sortModel);
        }
        catch (IOException e2) {
            Utils.showErrorMessage(this._$7451, e2, "Search Error");
        }
    }

    public void sort() {
        try {
            DataBase db = this._$531.getFrontDataBase();
            if (db == null) {
                return;
            }
            new SortDialogII((Frame)this._$7451, db).show();
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$7451, e2, "Sort Error");
        }
    }
}

