/*
 * Decompiled with CFR 0.152.
 */
package pymo.records;

import java.io.IOException;
import java.util.Vector;
import pymo.io.MOFileWriter;
import pymo.records.Record;
import pymo.records.RecordList;
import pymo.records.RecordManager;

public class MasterList
extends RecordList {
    int recentSearchIndex = -1;
    boolean sorted = false;

    public MasterList(RecordManager recordManager) {
        super(recordManager);
    }

    public void appendTo(MOFileWriter destination) throws IOException {
        this.recordManager.closeRecords();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.open(i2).appendTo(destination);
        }
        this.recordManager.closeRecords();
    }

    private void _$10082(int first, int last) {
        int low = first;
        int high = last;
        if (first >= last) {
            return;
        }
        long mid = this.idAt(first) + this.idAt(last) >> 1;
        while (true) {
            if (this.idAt(low) < mid) {
                ++low;
                continue;
            }
            while (this.idAt(high) > mid) {
                --high;
            }
            if (low <= high) {
                this.swap(low, high);
                ++low;
                --high;
            }
            if (low > high) break;
        }
        this._$10082(first, high);
        this._$10082(low, last);
    }

    private int _$10084(long id) {
        if (!this.sorted) {
            this.sort();
        }
        boolean found = false;
        int high = this.size() - 1;
        int low = 0;
        this.recentSearchIndex = high + low >> 1;
        if (high == -1) {
            return -1;
        }
        while (!found && high >= low) {
            long testValue = this.idAt(this.recentSearchIndex);
            if (id == testValue) {
                found = true;
            } else if (id < testValue) {
                high = this.recentSearchIndex - 1;
            } else {
                low = this.recentSearchIndex + 1;
            }
            this.recentSearchIndex = high + low >> 1;
        }
        return found ? this.recentSearchIndex : -1;
    }

    void addRecordQuietly(Record record) {
        super.addRecordQuietly(record);
        this.sorted = false;
    }

    void addRecordQueitly(Record record) {
        super.addRecordQuietly(record);
        this.sorted = false;
    }

    public int indexOf(long recordID) {
        return this._$10084(recordID);
    }

    public void sort() {
        this._$10082(0, this.size() - 1);
        this.sorted = true;
    }

    public void swap(int aIndex, int bIndex) {
        super.swap(aIndex, bIndex);
        this.sorted = false;
    }

    public void setList(Vector list) {
        super.setList(list);
        this.sorted = false;
    }

    private boolean _$10090(int index, int[] validFieldIndexes) {
        for (int i2 = 0; i2 < validFieldIndexes.length; ++i2) {
            if (validFieldIndexes[i2] != index) continue;
            return true;
        }
        return false;
    }

    private int _$10092(int[] validFieldIndexes) {
        int largest = 0;
        for (int i2 = 0; i2 < validFieldIndexes.length; ++i2) {
            if (validFieldIndexes[i2] <= largest) continue;
            largest = validFieldIndexes[i2];
        }
        return largest;
    }

    private boolean[] _$10094(int totalFields, int[] validFieldIndexes) {
        boolean[] deleteFlagList = new boolean[totalFields];
        for (int i2 = 0; i2 < deleteFlagList.length; ++i2) {
            deleteFlagList[i2] = !this._$10090(i2, validFieldIndexes);
        }
        return deleteFlagList;
    }

    public void verifyValidFields(int[] validFieldIndexes) throws IOException {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            Record record = this.recordAt(i2);
            this.recordManager.open(record);
            int minimumFieldCount = this._$10092(validFieldIndexes) + 1;
            record.expandTotalFields(minimumFieldCount);
            int realFieldCount = record.fieldCountInRecord();
            boolean[] deleteFlags = this._$10094(realFieldCount, validFieldIndexes);
            for (int j2 = 0; j2 < deleteFlags.length; ++j2) {
                if (!deleteFlags[j2]) continue;
                record.setFieldDeleteFlag(j2, true);
            }
        }
        this.recordManager.saveRecords();
    }
}

